/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.domain;

import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.schemagen.domain.DomainManager;
import io.konig.schemagen.domain.ShapeProperty;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class DomainProperty {
    private Vertex vertex;
    private URI propertyId;
    private URI domain;
    private URI range;
    private List<ShapeProperty> shapePropertyList = new ArrayList<ShapeProperty>();

    public DomainProperty(Vertex vertex) {
        this.vertex = vertex;
        this.propertyId = (URI)vertex.getId();
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public boolean isDatatypeProperty() {
        for (ShapeProperty p : this.shapePropertyList) {
            PropertyConstraint c = p.getConstraint();
            if (c.getDatatype() == null) continue;
            return true;
        }
        return false;
    }

    public URI getPropertyId() {
        return this.propertyId;
    }

    public URI derivedDomain(Graph ontology) {
        if (this.domain != null) {
            return this.domain;
        }
        URI result = null;
        for (ShapeProperty p : this.shapePropertyList) {
            URI d = p.getShape().getScopeClass();
            if (d == null) continue;
            if (result == null) {
                result = d;
                continue;
            }
            Vertex v = ontology.vertex((Resource)result);
            if (RdfUtil.isSubClassOf((Vertex)v, (Resource)d)) {
                result = d;
                continue;
            }
            v = ontology.vertex((Resource)d);
            if (RdfUtil.isSubClassOf((Vertex)v, (Resource)result)) continue;
            return null;
        }
        return result;
    }

    public URI derivedRange(Graph ontology) {
        if (this.range != null) {
            return this.range;
        }
        URI result = null;
        for (ShapeProperty p : this.shapePropertyList) {
            URI r = DomainManager.rangeOf(p, ontology);
            if (r == null) continue;
            if (result == null) {
                result = r;
                continue;
            }
            Vertex v = ontology.vertex((Resource)result);
            if (RdfUtil.isSubClassOf((Vertex)v, (Resource)r)) {
                result = r;
                continue;
            }
            v = ontology.vertex((Resource)r);
            if (RdfUtil.isSubClassOf((Vertex)v, (Resource)result)) continue;
            return null;
        }
        return result;
    }

    public URI getDomain() {
        return this.domain;
    }

    public void setDomain(URI domain) {
        this.domain = domain;
    }

    public URI getRange() {
        return this.range;
    }

    public void setRange(URI range) {
        this.range = range;
    }

    public List<ShapeProperty> getShapeProperyList() {
        return this.shapePropertyList;
    }

    public void add(ShapeProperty s) {
        if (!this.shapePropertyList.contains(s)) {
            this.shapePropertyList.add(s);
        }
    }

    public void addShapeProperty(Shape shape, PropertyConstraint p) {
        this.add(new ShapeProperty(shape, p));
    }
}

