/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.java;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.konig.core.util.StringUtil;
import io.konig.core.vocab.KOL;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.java.DataWriterBuilder;
import io.konig.schemagen.java.JavaClassBuilder;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeMediaTypeNamer;
import java.awt.List;
import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class AvonWriterBuilder {
    private DataWriterBuilder dataWriter;

    public AvonWriterBuilder(DataWriterBuilder dataWriter) {
        this.dataWriter = dataWriter;
    }

    public void buildWriter(Shape shape) throws SchemaGeneratorException {
        Worker worker = new Worker();
        worker.buildWriter(shape);
    }

    private class Worker {
        private JDefinedClass dc;

        private Worker() {
        }

        public void buildWriter(Shape shape) throws SchemaGeneratorException {
            URI scopeClass = shape.getScopeClass();
            if (scopeClass != null) {
                String className = this.avonWriterJavaClassName(shape);
                JCodeModel model = AvonWriterBuilder.this.dataWriter.getModel();
                String mediaTypeName = this.avonMediaType(shape);
                if (model._getClass(className) == null) {
                    try {
                        this.dc = model._class(className);
                        this.dc._implements(AvonWriterBuilder.this.dataWriter.getDataWriterInterface());
                        JFieldVar mediaTypeField = this.dc.field(25, String.class, "MEDIA_TYPE");
                        mediaTypeField.init(JExpr.lit((String)mediaTypeName));
                        JMethod method = this.dc.method(1, String.class, "getMediaType");
                        method.body()._return((JExpression)mediaTypeField);
                        method.annotate(Override.class);
                        String javaClassName = AvonWriterBuilder.this.dataWriter.getJavaNamer().javaClassName(scopeClass);
                        JClass javaScopeClass = model.ref(javaClassName);
                        this.buildWriteMethod(model, this.dc, javaScopeClass, shape);
                    }
                    catch (JClassAlreadyExistsException e) {
                        throw new SchemaGeneratorException(e);
                    }
                }
            }
        }

        private String avonMediaType(Shape shape) {
            String result = null;
            URI scopeClass = shape.getScopeClass();
            if (scopeClass != null) {
                ShapeMediaTypeNamer mediaTypeNamer = AvonWriterBuilder.this.dataWriter.getMediaTypeNamer();
                String mediaTypeBaseName = mediaTypeNamer.baseMediaTypeName(shape);
                result = mediaTypeBaseName + "+avon";
            }
            return result;
        }

        private String avonWriterJavaClassName(Shape shape) {
            String className = null;
            URI scopeClass = shape.getScopeClass();
            if (scopeClass == null) {
                throw new SchemaGeneratorException("scopeClass not defined for Shape: " + shape.getId());
            }
            ShapeMediaTypeNamer mediaTypeNamer = AvonWriterBuilder.this.dataWriter.getMediaTypeNamer();
            String mediaTypeBaseName = mediaTypeNamer.baseMediaTypeName(shape);
            className = mediaTypeBaseName + '.' + scopeClass.getLocalName() + "AvonWriter";
            className = AvonWriterBuilder.this.dataWriter.getJavaNamer().writerName(className);
            return className;
        }

        private void buildWriteMethod(JCodeModel model, JDefinedClass dc, JClass javaScopeClass, Shape shape) {
            URI scopeClass = shape.getScopeClass();
            JMethod method = dc.method(1, Void.TYPE, "write");
            JVar dataVar = method.param(Object.class, "data");
            JVar outVar = method.param((JType)AvonWriterBuilder.this.dataWriter.getDataSinkClass(), "out");
            method.annotate(Override.class);
            method._throws(AvonWriterBuilder.this.dataWriter.getValidationExceptionClass());
            method._throws(model.ref(IOException.class));
            JConditional conditional = method.body()._if(dataVar._instanceof((JType)javaScopeClass));
            JBlock block = conditional._then();
            JBlock elseBlock = conditional._else();
            elseBlock._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)("Invalid argument.  Expected data object of type " + scopeClass.getLocalName()))));
            JClass jsonGeneratorClass = model.ref(JsonGenerator.class);
            JVar jsonVar = block.decl((JType)jsonGeneratorClass, "json", (JExpression)JExpr.invoke((JExpression)outVar, (String)"getJsonGenerator"));
            JVar subjectVar = block.decl((JType)javaScopeClass, "subject", (JExpression)JExpr.cast((JType)javaScopeClass, (JExpression)dataVar));
            block.invoke((JExpression)jsonVar, "writeStartObject");
            for (PropertyConstraint p : shape.getProperty()) {
                this.handleProperty(block, outVar, subjectVar, jsonVar, p, scopeClass);
            }
            block.invoke((JExpression)jsonVar, "writeEndObject");
        }

        private void handleProperty(JBlock block, JVar outVar, JVar subjectVar, JVar jsonVar, PropertyConstraint p, URI subjectClass) {
            Integer maxCount = p.getMaxCount();
            Integer minCount = p.getMinCount();
            if (maxCount != null && maxCount == 1) {
                boolean required = minCount != null && minCount == 1;
                this.handleSingleValue(block, outVar, subjectVar, jsonVar, p, subjectClass, required);
            } else {
                this.handleMultiValue(block, outVar, subjectVar, jsonVar, p, subjectClass);
            }
        }

        private void handleMultiValue(JBlock block, JVar outVar, JVar subjectVar, JVar jsonVar, PropertyConstraint p, URI subjectClass) {
            Integer maxCount;
            JCodeModel model = AvonWriterBuilder.this.dataWriter.getModel();
            JClass uriClass = model.ref(URI.class);
            Shape valueShape = p.getValueShape();
            URI datatype = p.getDatatype();
            String fieldName = p.getPredicate().getLocalName() + "List";
            String getterName = JavaClassBuilder.getterName(fieldName);
            String valueTypeName = this.valueType(p);
            JClass valueClass = this.ref(valueTypeName);
            JClass listClass = this.ref(List.class);
            listClass = listClass.narrow(valueClass);
            JVar localVar = block.decl((JType)listClass, fieldName, (JExpression)subjectVar.invoke(getterName));
            Integer minCount = p.getMinCount();
            if (minCount != null && minCount > 0) {
                String value = minCount == 1 ? " value" : " values";
                block._if(JOp.cor((JExpression)localVar.eq(JExpr._null()), (JExpression)JOp.lt((JExpression)localVar.invoke("size"), (JExpression)JExpr.lit((int)minCount))))._then()._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)(subjectClass.getLocalName() + " " + fieldName + " must contain at least " + minCount + value))));
            }
            if ((maxCount = p.getMaxCount()) != null) {
                String value = maxCount == 1 ? " value" : " values";
                block._if(JOp.cand((JExpression)localVar.ne(JExpr._null()), (JExpression)JOp.gt((JExpression)localVar.invoke("size"), (JExpression)JExpr.lit((int)maxCount))))._then()._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)(subjectClass.getLocalName() + " " + fieldName + " may contain no more than " + maxCount + value))));
            }
            String elementName = p.getPredicate().getLocalName();
            JBlock thenBlock = block._if(localVar.ne(JExpr._null()))._then();
            thenBlock.invoke((JExpression)jsonVar, "writeFieldName").arg(JExpr.lit((String)p.getPredicate().getLocalName()));
            thenBlock.invoke((JExpression)jsonVar, "writeStartArray");
            JForEach forEach = thenBlock.forEach((JType)valueClass, elementName, (JExpression)localVar);
            if (datatype != null) {
                Class<?> fieldJavaType = AvonWriterBuilder.this.dataWriter.javaDatatype(datatype);
                AvonWriterBuilder.this.dataWriter.writeSimpleValue(forEach.body(), jsonVar, fieldJavaType, (JExpression)forEach.var());
            } else if (valueShape != null) {
                String writerClassName = this.avonWriterJavaClassName(valueShape);
                String writerVarName = StringUtil.firstLetterLowerCase((String)(p.getPredicate().getLocalName() + "AvonWriter"));
                JVar writerVar = (JVar)this.dc.fields().get(writerVarName);
                if (writerVar == null) {
                    JClass writerClass = this.ref(writerClassName);
                    writerVar = this.dc.field(4, (JType)writerClass, writerVarName, (JExpression)JExpr._new((JClass)writerClass));
                }
                forEach.body().invoke((JExpression)writerVar, "write").arg((JExpression)forEach.var()).arg((JExpression)outVar);
            } else if (p.getValueClass() instanceof URI) {
                JClass namespacesClass = this.ref(AvonWriterBuilder.this.dataWriter.getJavaNamer().namespacesClass());
                JVar elementIdVar = forEach.body().decl((JType)uriClass, elementName + "Id", (JExpression)forEach.var().invoke("getId"));
                forEach.body()._if(JOp.eq((JExpression)elementIdVar, (JExpression)JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)(subjectClass.getLocalName() + " " + elementName + " must have a URI as an Id "))));
                forEach.body().invoke((JExpression)jsonVar, "writeString").arg((JExpression)namespacesClass.staticInvoke("curie").arg((JExpression)elementIdVar));
            }
            thenBlock.invoke((JExpression)jsonVar, "writeEndArray");
        }

        private void handleSingleValue(JBlock block, JVar outVar, JVar subjectVar, JVar jsonVar, PropertyConstraint p, URI subjectClass, boolean required) {
            Shape valueShape = p.getValueShape();
            String fieldName = p.getPredicate().getLocalName();
            String getterName = JavaClassBuilder.getterName(fieldName);
            if (valueShape != null) {
                String writerClassName = this.avonWriterJavaClassName(valueShape);
                String valueClassName = this.valueType(p);
                JClass valueType = this.ref(valueClassName);
                String writerSimpleName = StringUtil.javaSimpleName((String)writerClassName);
                String writerVarName = StringUtil.firstLetterLowerCase((String)writerSimpleName);
                JVar writerVar = (JVar)this.dc.fields().get(writerVarName);
                if (writerVar == null) {
                    JClass writerClass = this.ref(writerClassName);
                    writerVar = this.dc.field(4, (JType)writerClass, writerVarName, (JExpression)JExpr._new((JClass)writerClass));
                }
                JVar localVar = block.decl((JType)valueType, fieldName, (JExpression)subjectVar.invoke(getterName));
                JConditional condition = block._if(localVar.ne(JExpr._null()));
                condition._then().invoke((JExpression)writerVar, "write").arg((JExpression)localVar).arg((JExpression)outVar);
                if (required) {
                    condition._else()._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)(subjectClass.getLocalName() + " " + fieldName + " is required"))));
                }
            } else if (p.getPredicate().equals((Object)KOL.id)) {
                JClass uriClass = AvonWriterBuilder.this.dataWriter.getModel().ref(URI.class);
                JVar idVar = block.decl((JType)uriClass, "id", (JExpression)JExpr.invoke((JExpression)subjectVar, (String)"getId"));
                if (required) {
                    block._if(idVar.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)("Id of " + subjectClass.getLocalName() + " is required"))));
                }
                block.invoke((JExpression)jsonVar, "writeStringField").arg(JExpr.lit((String)"id")).arg((JExpression)idVar.invoke("stringValue"));
            } else {
                URI datatype = p.getDatatype();
                Resource valueClassResource = p.getValueClass();
                if (datatype != null) {
                    Class<?> fieldJavaType = AvonWriterBuilder.this.dataWriter.javaDatatype(datatype);
                    JClass fieldType = AvonWriterBuilder.this.dataWriter.ref(fieldJavaType);
                    JVar localVar = block.decl((JType)fieldType, fieldName, (JExpression)subjectVar.invoke(getterName));
                    if (required) {
                        block._if(localVar.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)(subjectClass.getLocalName() + " " + fieldName + " is required"))));
                    }
                    AvonWriterBuilder.this.dataWriter.writeSimpleField(block, jsonVar, fieldName, fieldJavaType, (JExpression)localVar);
                } else if (valueClassResource instanceof URI) {
                    URI valueClass = (URI)valueClassResource;
                    String valueClassName = AvonWriterBuilder.this.dataWriter.getJavaNamer().javaClassName(valueClass);
                    JClass fieldType = AvonWriterBuilder.this.dataWriter.getModel().ref(valueClassName);
                    JVar localVar = block.decl((JType)fieldType, fieldName, (JExpression)subjectVar.invoke(getterName));
                    if (required) {
                        JConditional condition = block._if(localVar.eq(JExpr._null()));
                        condition._then()._throw((JExpression)JExpr._new((JClass)AvonWriterBuilder.this.dataWriter.getValidationExceptionClass()).arg(JExpr.lit((String)(subjectClass.getLocalName() + " " + fieldName + " is required"))));
                        String idName = fieldName + "Id";
                        JClass uriType = AvonWriterBuilder.this.dataWriter.getModel().ref(URI.class);
                        JBlock elseBlock = condition._else();
                        JVar stringValue = elseBlock.decl((JType)uriType, idName, (JExpression)localVar.invoke("stringValue"));
                        AvonWriterBuilder.this.dataWriter.writeSimpleField(elseBlock, jsonVar, fieldName, String.class, (JExpression)stringValue);
                    } else {
                        JBlock thenBlock = block._if(localVar.ne(JExpr._null()))._then();
                        String idName = fieldName + "Id";
                        JClass uriType = AvonWriterBuilder.this.dataWriter.getModel().ref(URI.class);
                        JVar idVar = thenBlock.decl((JType)uriType, idName, (JExpression)localVar.invoke("getId"));
                        JBlock idBlock = thenBlock._if(idVar.ne(JExpr._null()))._then();
                        AvonWriterBuilder.this.dataWriter.writeSimpleField(idBlock, jsonVar, fieldName, String.class, (JExpression)idVar.invoke("stringValue"));
                    }
                }
            }
        }

        private JClass ref(Class<?> type) {
            return AvonWriterBuilder.this.dataWriter.getModel().ref(type);
        }

        private JClass ref(String javaClassName) {
            if (javaClassName == null) {
                return null;
            }
            return AvonWriterBuilder.this.dataWriter.getModel().ref(javaClassName);
        }

        private String valueType(PropertyConstraint p) {
            URI owlClass = null;
            Resource valueClass = p.getValueClass();
            if (valueClass instanceof URI) {
                owlClass = (URI)valueClass;
            } else {
                Shape valueShape;
                owlClass = p.getDirectValueType();
                if (owlClass == null && (valueShape = p.getValueShape()) != null) {
                    owlClass = valueShape.getScopeClass();
                }
            }
            if (owlClass != null) {
                String valueClassName = AvonWriterBuilder.this.dataWriter.getJavaNamer().javaClassName(owlClass);
                return valueClassName;
            }
            URI datatype = p.getDatatype();
            if (datatype != null) {
                Class<?> javaType = AvonWriterBuilder.this.dataWriter.javaDatatype(datatype);
                return javaType.getName();
            }
            throw new SchemaGeneratorException("Type not found for " + p.getPredicate().getLocalName());
        }
    }
}

