/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.java;

import io.konig.core.NamespaceManager;
import io.konig.schemagen.java.JavaNamer;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.impl.NamespaceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicJavaNamer
implements JavaNamer {
    private static final Logger logger = LoggerFactory.getLogger(BasicJavaNamer.class);
    private static final String NAMESPACES_CLASS = "util.Namespaces";
    private String basePackage;
    private String defaultPrefix = "default";
    private NamespaceManager nsManager;
    private String writerPackage;
    private String namespacesClass;

    public BasicJavaNamer(String basePackage, NamespaceManager nsManager) {
        this(basePackage, null, nsManager);
    }

    public BasicJavaNamer(String basePackage, String writerPackage, NamespaceManager nsManager) {
        if (!basePackage.endsWith(".")) {
            basePackage = basePackage + ".";
        }
        if (writerPackage == null) {
            writerPackage = basePackage + "writer.";
        }
        if (!writerPackage.endsWith(".")) {
            writerPackage = writerPackage + ".";
        }
        this.basePackage = basePackage;
        this.nsManager = nsManager;
        this.writerPackage = writerPackage;
        this.namespacesClass = basePackage + NAMESPACES_CLASS;
    }

    @Override
    public String javaClassName(URI owlClass) {
        String namespaceName = owlClass.getNamespace();
        Namespace ns = this.nsManager.findByName(namespaceName);
        if (ns == null) {
            if (namespaceName.equals("http://www.w3.org/2002/07/owl#")) {
                ns = new NamespaceImpl("owl", namespaceName);
            } else {
                logger.warn("Prefix for namespace not found: " + owlClass.getNamespace());
            }
        }
        String prefix = ns == null ? this.defaultPrefix : ns.getPrefix();
        StringBuilder builder = new StringBuilder(this.basePackage);
        builder.append(prefix);
        builder.append('.');
        builder.append(owlClass.getLocalName());
        return builder.toString();
    }

    @Override
    public String writerName(String mediaType) {
        if (mediaType == null || mediaType.length() == 0) {
            return this.writerPackage.substring(0, this.writerPackage.length() - 1);
        }
        int slash = mediaType.indexOf(47);
        if (slash > 0) {
            mediaType = mediaType.substring(slash + 1);
        }
        mediaType = mediaType.replace('+', '.');
        return this.writerPackage + mediaType;
    }

    @Override
    public String namespacesClass() {
        return this.namespacesClass;
    }
}

