/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.java;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.konig.core.Graph;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.java.JavaDatatypeMapper;
import io.konig.schemagen.java.JavaNamer;
import io.konig.shacl.ShapeMediaTypeNamer;
import java.io.IOException;
import java.io.OutputStream;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWriterBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DataWriterBuilder.class);
    private JPackage writerPackage;
    private JClass dataWriterInterface;
    private JCodeModel model;
    private JavaNamer javaNamer;
    private ShapeMediaTypeNamer mediaTypeNamer;
    private JClass dataSinkClass;
    private JClass validationExceptionClass;
    private JavaDatatypeMapper datatypeMapper;
    private Graph ontology;

    public DataWriterBuilder(Graph ontology, JavaDatatypeMapper datatypeMapper, ShapeMediaTypeNamer mediaTypeNamer, JavaNamer javaNamer, JCodeModel model) {
        this.ontology = ontology;
        this.datatypeMapper = datatypeMapper;
        this.mediaTypeNamer = mediaTypeNamer;
        this.javaNamer = javaNamer;
        this.writerPackage = model._package(javaNamer.writerName(null));
        this.model = model;
        this.dataSinkClass = this.buildDataSinkClass();
        this.validationExceptionClass = this.buildValidationExceptionClass();
        this.dataWriterInterface = this.buildDataWriterInterface();
    }

    public JavaDatatypeMapper getDatatypeMapper() {
        return this.datatypeMapper;
    }

    public Graph getOntology() {
        return this.ontology;
    }

    public JClass getValidationExceptionClass() {
        return this.validationExceptionClass;
    }

    private JClass buildValidationExceptionClass() {
        try {
            JDefinedClass dc = this.writerPackage._class("ValidationException");
            dc._extends(RuntimeException.class);
            JMethod ctor = dc.constructor(1);
            JVar messageVar = ctor.param(String.class, "message");
            JVar causeVar = ctor.param(Throwable.class, "cause");
            JBlock block = ctor.body();
            block.invoke("super").arg((JExpression)messageVar).arg((JExpression)causeVar);
            ctor = dc.constructor(1);
            messageVar = ctor.param(String.class, "message");
            block = ctor.body();
            block.invoke("super").arg((JExpression)messageVar);
            return dc;
        }
        catch (JClassAlreadyExistsException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    public JClass getDataSinkClass() {
        return this.dataSinkClass;
    }

    private JClass buildDataSinkClass() {
        try {
            JDefinedClass dc = this.writerPackage._class("DataSink");
            JFieldVar jsonVar = dc.field(4, JsonGenerator.class, "json");
            JMethod ctor = dc.constructor(1);
            JVar outVar = ctor.param(OutputStream.class, "out");
            JBlock body = ctor.body();
            JClass jsonFactoryClass = this.model.ref(JsonFactory.class);
            JVar factoryVar = body.decl((JType)jsonFactoryClass, "jsonFactory", (JExpression)JExpr._new((JClass)jsonFactoryClass));
            body.assign((JAssignmentTarget)jsonVar, (JExpression)factoryVar.invoke("createGenerator").arg((JExpression)outVar));
            body.invoke((JExpression)jsonVar, "useDefaultPrettyPrinter");
            dc.method(1, JsonGenerator.class, "getJsonGenerator").body()._return((JExpression)jsonVar);
            return dc;
        }
        catch (JClassAlreadyExistsException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    public JavaNamer getJavaNamer() {
        return this.javaNamer;
    }

    public ShapeMediaTypeNamer getMediaTypeNamer() {
        return this.mediaTypeNamer;
    }

    public JPackage getWriterPackage() {
        return this.writerPackage;
    }

    public JClass getDataWriterInterface() {
        return this.dataWriterInterface;
    }

    public JClass datatype(URI owlClass) {
        Class<?> javaClass = this.datatypeMapper.javaDatatype(owlClass);
        return this.model.ref(javaClass);
    }

    public Class<?> javaDatatype(URI owlClass) {
        return this.datatypeMapper.javaDatatype(owlClass);
    }

    public JClass ref(Class<?> clazz) {
        return this.model.ref(clazz);
    }

    public void writeSimpleField(JBlock block, JVar jsonGenerator, String fieldName, Class<?> fieldType, JExpression fieldValue) {
        if (fieldType == String.class) {
            block.invoke((JExpression)jsonGenerator, "writeStringField").arg(JExpr.lit((String)fieldName)).arg(fieldValue);
        } else {
            logger.warn("Ignoring simple field of type " + fieldType.getSimpleName());
        }
    }

    public void writeSimpleValue(JBlock block, JVar jsonGenerator, Class<?> fieldType, JExpression value) {
        if (fieldType == String.class) {
            block.invoke((JExpression)jsonGenerator, "writeString").arg(value);
        } else {
            logger.warn("Ignoring simple field of type " + fieldType.getSimpleName());
        }
    }

    public JCodeModel getModel() {
        return this.model;
    }

    public JDefinedClass buildDataWriterInterface() throws SchemaGeneratorException {
        try {
            JDefinedClass dc = this.writerPackage._interface("DataWriter");
            JClass objectType = this.model.ref(Object.class);
            dc.method(0, String.class, "getMediaType");
            JMethod method = dc.method(0, Void.TYPE, "write");
            method.param((JType)objectType, "data");
            method.param((JType)this.dataSinkClass, "out");
            JClass ioException = this.model.ref(IOException.class);
            method._throws(this.validationExceptionClass);
            method._throws(ioException);
            return dc;
        }
        catch (JClassAlreadyExistsException e) {
            throw new SchemaGeneratorException(e);
        }
    }
}

