/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.java;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.konig.core.AmbiguousPreferredClassException;
import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.java.JavaDatatypeMapper;
import io.konig.schemagen.java.JavaNamer;
import io.konig.schemagen.java.SmartJavaDatatypeMapper;
import io.konig.shacl.ClassManager;
import io.konig.shacl.LogicalShapeNamer;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClassBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JavaClassBuilder.class);
    private JavaNamer namer;
    private JavaDatatypeMapper mapper;
    private ClassManager classManager;
    private OwlReasoner reasoner;
    private Graph graph;
    private LogicalShapeNamer logicalShapeNamer;
    private JClass owlThing;

    public JavaClassBuilder(ClassManager classManager, LogicalShapeNamer logicalShapeNamer, JavaNamer namer, OwlReasoner reasoner) {
        this.classManager = classManager;
        this.logicalShapeNamer = logicalShapeNamer;
        this.namer = namer;
        this.reasoner = reasoner;
        this.graph = reasoner.getGraph();
        this.mapper = new SmartJavaDatatypeMapper(reasoner);
    }

    public void buildAll(Collection<Shape> collection, JCodeModel model) throws SchemaGeneratorException {
        for (Shape shape : collection) {
            this.buildClass(shape, model);
        }
    }

    private JClass buildOwlThing(JCodeModel model) throws SchemaGeneratorException {
        String javaClassName = this.namer.javaClassName(OWL.THING);
        JDefinedClass prior = model._getClass(javaClassName);
        if (prior != null) {
            return prior;
        }
        try {
            JDefinedClass dc = model._class(javaClassName);
            JClass typeList = model.ref(Set.class);
            typeList = typeList.narrow(URI.class);
            JClass uriClass = model.ref(URI.class);
            String fieldName = "id";
            dc.field(4, URI.class, fieldName);
            this.createGetter(dc, fieldName, fieldName, uriClass);
            this.createSetter(dc, fieldName, fieldName, uriClass);
            fieldName = "typeSet";
            String methodBaseName = "typeSet";
            dc.field(4, (JType)typeList, fieldName);
            this.createAddTypeMethod(model, dc, uriClass);
            this.createGetter(dc, methodBaseName, fieldName, typeList);
            this.createSetter(dc, methodBaseName, fieldName, typeList);
            return dc;
        }
        catch (JClassAlreadyExistsException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    private void createAddTypeMethod(JCodeModel model, JDefinedClass dc, JClass jClass) {
        String methodName = this.addMethodName("type");
        JFieldRef field = JExpr.ref((String)"typeSet");
        JClass listClass = model.ref(HashSet.class);
        listClass = listClass.narrow(jClass);
        JMethod method = dc.method(1, Void.TYPE, methodName);
        JVar param = method.param((JType)jClass, "value");
        JBlock body = method.body();
        body._if(field.eq(JExpr._null()))._then().assign((JAssignmentTarget)field, (JExpression)JExpr._new((JClass)listClass));
        body.add((JStatement)field.invoke("add").arg((JExpression)param));
    }

    public JClass buildClass(Shape shape, JCodeModel model) throws SchemaGeneratorException {
        if (this.owlThing == null) {
            this.owlThing = this.buildOwlThing(model);
        }
        URI scopeClass = shape.getScopeClass();
        try {
            Vertex preferred = this.reasoner.preferredClass((Resource)scopeClass);
            scopeClass = (URI)preferred.getId();
        }
        catch (AmbiguousPreferredClassException e1) {
            throw new SchemaGeneratorException(e1);
        }
        String javaClassName = this.namer.javaClassName(scopeClass);
        JDefinedClass prior = model._getClass(javaClassName);
        if (prior != null) {
            return prior;
        }
        try {
            JDefinedClass dc = model._class(javaClassName);
            this.declareStaticTypeVar(model, dc, scopeClass);
            this.declareSuperClass(model, dc, shape);
            this.declareCtor(model, dc);
            this.createFields(model, shape, dc);
            return dc;
        }
        catch (JClassAlreadyExistsException e) {
            throw new SchemaGeneratorException(e);
        }
    }

    private void declareCtor(JCodeModel model, JDefinedClass dc) {
        JFieldRef typeRef = dc.staticRef("TYPE");
        dc.constructor(1).body().invoke("addType").arg((JExpression)typeRef);
    }

    private void declareStaticTypeVar(JCodeModel model, JDefinedClass dc, URI scopeClass) {
        JClass uriClass = model.ref(URIImpl.class);
        dc.field(25, URI.class, "TYPE").init((JExpression)JExpr._new((JClass)uriClass).arg(JExpr.lit((String)scopeClass.stringValue())));
    }

    private void declareSuperClass(JCodeModel model, JDefinedClass dc, Shape shape) {
        URI scopeClassId = shape.getScopeClass();
        List superClassList = this.graph.v((Resource)scopeClassId).out(RDFS.SUBCLASSOF).toVertexList();
        if (superClassList.isEmpty()) {
            dc._extends(this.owlThing);
        } else if (superClassList.size() == 1) {
            Vertex superVertex = (Vertex)superClassList.get(0);
            Resource superId = superVertex.getId();
            if (superId instanceof URI) {
                try {
                    URI superIRI = this.reasoner.preferredClassAsURI((URI)superId);
                    Shape superShape = this.classManager.getLogicalShape((Resource)superIRI);
                    if (superShape == null) {
                        URI shapeId = this.logicalShapeNamer.logicalShapeForOwlClass(superIRI);
                        superShape = new Shape((Resource)shapeId);
                        superShape.setScopeClass(superIRI);
                        this.classManager.addLogicalShape(shape);
                    }
                    JClass jSuper = this.buildClass(superShape, model);
                    dc._extends(jSuper);
                }
                catch (AmbiguousPreferredClassException e) {
                    throw new SchemaGeneratorException(e);
                }
            }
        } else {
            logger.warn("Ignoring subClassOf statement for class " + scopeClassId.getLocalName() + ": multiple inheritance not supported yet");
        }
    }

    private void createFields(JCodeModel model, Shape shape, JDefinedClass dc) {
        List list = shape.getProperty();
        for (PropertyConstraint p : list) {
            this.createField(model, p, dc);
        }
    }

    private void createField(JCodeModel model, PropertyConstraint p, JDefinedClass dc) {
        URI datatype = p.getDatatype();
        Resource owlClass = p.getValueClass();
        if (datatype != null) {
            this.createDatatypeField(model, p, dc);
        } else if (owlClass instanceof URI) {
            this.createObjectField(model, p, dc);
        }
    }

    private void createObjectField(JCodeModel model, PropertyConstraint p, JDefinedClass dc) {
        String fieldName;
        URI predicate = p.getPredicate();
        URI owlClass = (URI)p.getValueClass();
        JClass jClass = this.javaClass(model, owlClass);
        Integer maxCount = p.getMaxCount();
        String methodBaseName = fieldName = predicate.getLocalName();
        if (maxCount == null || maxCount > 1) {
            this.createAddMethod(model, dc, fieldName, jClass);
            methodBaseName = fieldName + "List";
            JClass listClass = model.ref(List.class);
            jClass = listClass.narrow(jClass);
        }
        dc.field(4, (JType)jClass, predicate.getLocalName());
        this.createGetter(dc, methodBaseName, fieldName, jClass);
        this.createSetter(dc, methodBaseName, fieldName, jClass);
    }

    private void createAddMethod(JCodeModel model, JDefinedClass dc, String fieldName, JClass jClass) {
        String methodName = this.addMethodName(fieldName);
        JFieldRef field = JExpr.ref((String)fieldName);
        JClass listClass = model.ref(ArrayList.class);
        listClass = listClass.narrow(jClass);
        JMethod method = dc.method(1, Void.TYPE, methodName);
        JVar param = method.param((JType)jClass, "value");
        JBlock body = method.body();
        body._if(field.eq(JExpr._null()))._then().assign((JAssignmentTarget)field, (JExpression)JExpr._new((JClass)listClass));
        body.add((JStatement)field.invoke("add").arg((JExpression)param));
    }

    private JClass javaClass(JCodeModel model, URI owlClass) {
        String className = this.namer.javaClassName(owlClass);
        JDefinedClass result = model._getClass(className);
        if (result == null) {
            Shape shape = this.classManager.getLogicalShape((Resource)owlClass);
            result = this.buildClass(shape, model);
        }
        return result;
    }

    private void createDatatypeField(JCodeModel model, PropertyConstraint p, JDefinedClass dc) {
        String fieldName;
        URI predicate = p.getPredicate();
        URI datatype = p.getDatatype();
        String methodBaseName = fieldName = predicate.getLocalName();
        Class<?> javaType = this.mapper.javaDatatype(datatype);
        JClass jClass = model.ref(javaType);
        Integer maxCount = p.getMaxCount();
        if (maxCount == null || maxCount > 1) {
            this.createAddMethod(model, dc, fieldName, jClass);
            methodBaseName = fieldName + "List";
            JClass listClass = model.ref(List.class);
            jClass = listClass.narrow(jClass);
        }
        dc.field(4, (JType)jClass, predicate.getLocalName());
        this.createGetter(dc, methodBaseName, fieldName, jClass);
        this.createSetter(dc, methodBaseName, fieldName, jClass);
    }

    private void createSetter(JDefinedClass dc, String methodBaseName, String fieldName, JClass javaType) {
        String methodName = this.setterName(methodBaseName);
        JMethod method = dc.method(1, Void.TYPE, methodName);
        JVar param = method.param((JType)javaType, fieldName);
        method.body().assign((JAssignmentTarget)JExpr._this().ref(fieldName), (JExpression)param);
    }

    private String setterName(String fieldName) {
        StringBuilder builder = new StringBuilder("set");
        JavaClassBuilder.capitalize(builder, fieldName);
        return builder.toString();
    }

    private void createGetter(JDefinedClass dc, String methodBaseName, String fieldName, JClass javaType) {
        String methodName = JavaClassBuilder.getterName(methodBaseName);
        JMethod method = dc.method(1, (JType)javaType, methodName);
        method.body()._return((JExpression)JExpr.ref((String)fieldName));
    }

    public static String getterName(String fieldName) {
        StringBuilder builder = new StringBuilder("get");
        JavaClassBuilder.capitalize(builder, fieldName);
        return builder.toString();
    }

    private String addMethodName(String fieldName) {
        StringBuilder builder = new StringBuilder("add");
        JavaClassBuilder.capitalize(builder, fieldName);
        return builder.toString();
    }

    public static void capitalize(StringBuilder builder, String fieldName) {
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (i == 0) {
                c = Character.toUpperCase(c);
            }
            builder.append(c);
        }
    }
}

