/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.java;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.konig.core.NamespaceManager;
import io.konig.schemagen.java.JavaNamer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;

public class NamespacesBuilder {
    private JavaNamer namer;

    public NamespacesBuilder(JavaNamer namer) {
        this.namer = namer;
    }

    public void generateNamespaces(JCodeModel model, NamespaceManager nsManager) {
        try {
            JClass hashMapClass = model.ref(HashMap.class).narrow(new Class[]{String.class, Namespace.class});
            JClass mapClass = model.ref(Map.class).narrow(new Class[]{String.class, Namespace.class});
            JDefinedClass dc = model._class(this.namer.namespacesClass());
            JFieldVar mapField = dc.field(28, (JType)mapClass, "map", (JExpression)JExpr._new((JClass)hashMapClass));
            this.generateStaticInit(model, dc, nsManager);
            this.generateAddMethod(model, dc, (JVar)mapField);
            this.generateCurieMethod(model, dc, (JVar)mapField);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            // empty catch block
        }
    }

    private void generateStaticInit(JCodeModel model, JDefinedClass dc, NamespaceManager nsManager) {
        JBlock block = dc.init();
        ArrayList list = new ArrayList(nsManager.listNamespaces());
        Collections.sort(list, new Comparator<Namespace>(){

            @Override
            public int compare(Namespace a, Namespace b) {
                return a.getPrefix().compareTo(b.getPrefix());
            }
        });
        for (Namespace ns : list) {
            JExpression prefixValue = JExpr.lit((String)ns.getPrefix());
            JExpression nameValue = JExpr.lit((String)ns.getName());
            block.add((JStatement)dc.staticInvoke("add").arg(prefixValue).arg(nameValue));
        }
    }

    private void generateCurieMethod(JCodeModel model, JDefinedClass dc, JVar mapField) {
        JClass stringBuilderClass = model.ref(StringBuilder.class);
        JClass namespaceClass = model.ref(Namespace.class);
        JMethod method = dc.method(17, String.class, "curie");
        JVar uriVar = method.param(URI.class, "uri");
        JVar nsVar = method.body().decl((JType)namespaceClass, "ns", (JExpression)mapField.invoke("get").arg((JExpression)uriVar.invoke("getNamespace")));
        method.body()._if(JOp.eq((JExpression)nsVar, (JExpression)JExpr._null()))._then()._return((JExpression)uriVar.invoke("stringValue"));
        JVar builderVar = method.body().decl((JType)stringBuilderClass, "builder", (JExpression)JExpr._new((JClass)stringBuilderClass));
        method.body().add((JStatement)builderVar.invoke("add").arg((JExpression)nsVar.invoke("getPrefix")));
        method.body().add((JStatement)builderVar.invoke("add").arg(JExpr.lit((char)':')));
        method.body().add((JStatement)builderVar.invoke("add").arg((JExpression)uriVar.invoke("getLocalName")));
        method.body()._return((JExpression)builderVar.invoke("toString"));
    }

    private void generateAddMethod(JCodeModel model, JDefinedClass dc, JVar mapField) {
        JClass namespaceClass = model.ref(Namespace.class);
        JMethod method = dc.method(20, Void.TYPE, "add");
        JVar prefixVar = method.param(String.class, "prefix");
        JVar nameVar = method.param(String.class, "name");
        JInvocation nsInvoke = JExpr._new((JClass)namespaceClass);
        nsInvoke.arg((JExpression)prefixVar).arg((JExpression)nameVar);
        JVar nsVar = method.body().decl((JType)namespaceClass, "ns", (JExpression)nsInvoke);
        method.body().invoke((JExpression)mapField, "put").arg((JExpression)prefixVar).arg((JExpression)nsVar);
        method.body().invoke((JExpression)mapField, "put").arg((JExpression)nameVar).arg((JExpression)nsVar);
    }
}

