/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.konig.core.NamespaceManager;
import io.konig.schemagen.GeneratedMediaTypeTransformer;
import io.konig.schemagen.Generator;
import io.konig.schemagen.ShapeTransformer;
import io.konig.schemagen.jsonschema.JsonSchemaDatatype;
import io.konig.schemagen.jsonschema.JsonSchemaNamer;
import io.konig.schemagen.jsonschema.JsonSchemaTypeMapper;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class JsonSchemaGenerator
extends Generator {
    private JsonSchemaNamer namer;
    private JsonSchemaTypeMapper typeMapper;
    private ShapeTransformer shapeTransformer = new GeneratedMediaTypeTransformer("+json");

    public JsonSchemaGenerator(JsonSchemaNamer namer, NamespaceManager nsManager, JsonSchemaTypeMapper typeMapper) {
        super(nsManager);
        this.namer = namer;
        this.typeMapper = typeMapper;
    }

    public JsonSchemaNamer getNamer() {
        return this.namer;
    }

    public ObjectNode generateJsonSchema(Shape shape) {
        Worker worker = new Worker();
        return worker.generateJsonSchema(shape);
    }

    private class Worker {
        private ObjectMapper mapper = new ObjectMapper();

        private Worker() {
        }

        public ObjectNode generateJsonSchema(Shape shape) {
            String schemaId = JsonSchemaGenerator.this.namer.schemaId(shape);
            ObjectNode json = this.mapper.createObjectNode();
            json.put("$schema", "http://json-schema.org/draft-04/schema#");
            json.put("id", schemaId);
            json.put("type", "object");
            this.putProperties(json, shape);
            return json;
        }

        private void putProperties(ObjectNode json, Shape shape) {
            List list = shape.getProperty();
            if (list != null && !list.isEmpty()) {
                ObjectNode properties = this.mapper.createObjectNode();
                json.put("properties", (JsonNode)properties);
                for (PropertyConstraint constraint : list) {
                    if (JsonSchemaGenerator.this.shapeTransformer != null) {
                        constraint = JsonSchemaGenerator.this.shapeTransformer.transform(shape, constraint);
                    }
                    this.putProperty(properties, constraint);
                }
            }
        }

        private void putProperty(ObjectNode properties, PropertyConstraint property) {
            URI propertyId = property.getPredicate();
            String fieldName = propertyId.getLocalName();
            Integer maxCount = property.getMaxCount();
            ObjectNode field = this.mapper.createObjectNode();
            properties.put(fieldName, (JsonNode)field);
            String doc = JsonSchemaGenerator.this.documentation(property);
            if (doc != null) {
                field.put("description", doc);
            }
            if (maxCount == null || maxCount > 1) {
                field.put("type", "array");
                field.put("items", (JsonNode)this.createType(fieldName, property, null));
            } else {
                this.createType(fieldName, property, field);
            }
        }

        private ObjectNode createType(String fieldName, PropertyConstraint property, ObjectNode field) {
            String strictValue;
            ObjectNode object = field == null ? this.mapper.createObjectNode() : field;
            NodeKind nodeKind = property.getNodeKind();
            URI datatype = property.getDatatype();
            Resource valueShapeId = property.getValueShapeId();
            List enumList = null;
            if (valueShapeId == null) {
                enumList = JsonSchemaGenerator.this.enumList(property);
            }
            if ((strictValue = JsonSchemaGenerator.this.strictValue(property)) != null) {
                object.put("type", "string");
                ArrayNode array = this.mapper.createArrayNode();
                object.put("enum", (JsonNode)array);
                array.add(strictValue);
            } else if (enumList != null) {
                object.put("type", "string");
                ArrayNode array = this.mapper.createArrayNode();
                object.put("enum", (JsonNode)array);
                for (String value : enumList) {
                    array.add(value);
                }
            } else if (nodeKind == NodeKind.IRI) {
                object.put("type", "string");
                object.put("format", "uri");
            } else if (datatype != null) {
                JsonSchemaDatatype jsonType = JsonSchemaGenerator.this.typeMapper.type(property);
                String typeName = jsonType.getTypeName();
                String format = jsonType.getFormat();
                Number minimum = jsonType.getMinimum();
                Number maximum = jsonType.getMaximum();
                Boolean exclusiveMaximum = jsonType.getExclusiveMaximum();
                Boolean exclusiveMinimum = jsonType.getExclusiveMinimum();
                if (field != null && format == null && minimum == null && maximum == null) {
                    object.put("type", typeName);
                } else {
                    object.put("type", typeName);
                    if (format != null) {
                        object.put("format", format);
                    }
                    if (minimum != null) {
                        object.put("minimum", (Double)minimum);
                        if (exclusiveMinimum != null) {
                            object.put("exclusiveMinimum", exclusiveMinimum);
                        }
                    }
                    if (maximum != null) {
                        object.put("maximum", (Double)maximum);
                        if (exclusiveMaximum != null) {
                            object.put("exclusiveMaximum", exclusiveMaximum);
                        }
                    }
                }
            } else if (valueShapeId != null) {
                Shape valueShape = property.getValueShape();
                object.put("type", (JsonNode)this.generateJsonSchema(valueShape));
            }
            return object;
        }
    }
}

