/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.jsonschema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.konig.schemagen.SchemaGeneratorException;
import io.konig.schemagen.jsonschema.JsonSchemaGenerator;
import io.konig.schemagen.jsonschema.JsonSchemaListener;
import io.konig.schemagen.jsonschema.JsonSchemaNamer;
import io.konig.shacl.Shape;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openrdf.model.URI;

public class ShapeToJsonSchema {
    private JsonSchemaGenerator generator;
    private ObjectMapper mapper;
    private JsonSchemaListener listener;

    public ShapeToJsonSchema(JsonSchemaGenerator generator) {
        this.generator = generator;
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public JsonSchemaListener getListener() {
        return this.listener;
    }

    public void setListener(JsonSchemaListener listener) {
        this.listener = listener;
    }

    public void generateAll(List<Shape> list, File outDir) throws SchemaGeneratorException {
        outDir.mkdirs();
        JsonSchemaNamer namer = this.generator.getNamer();
        for (Shape shape : list) {
            if (!(shape.getId() instanceof URI)) continue;
            File file = new File(outDir, namer.jsonSchemaFileName(shape));
            this.generateJsonSchema(shape, file);
        }
    }

    public void generateJsonSchema(Shape shape, File jsonSchemaFile) throws SchemaGeneratorException {
        ObjectNode json = this.generator.generateJsonSchema(shape);
        try {
            if (this.listener != null) {
                this.listener.handleJsonSchema(shape, json);
            }
            this.mapper.writeValue(jsonSchemaFile, (Object)json);
        }
        catch (IOException e) {
            throw new SchemaGeneratorException(e);
        }
    }
}

