/*
 * Decompiled with CFR 0.152.
 */
package io.konig.schemagen.jsonschema.impl;

import io.konig.core.DatatypeRestriction;
import io.konig.core.OwlReasoner;
import io.konig.schemagen.jsonschema.JsonSchemaDatatype;
import io.konig.schemagen.jsonschema.JsonSchemaTypeMapper;
import io.konig.schemagen.jsonschema.impl.SimpleJsonSchemaTypeMapper;
import io.konig.shacl.PropertyConstraint;
import org.openrdf.model.URI;

public class SmartJsonSchemaTypeMapper
implements JsonSchemaTypeMapper {
    private OwlReasoner reasoner;
    private SimpleJsonSchemaTypeMapper simple = new SimpleJsonSchemaTypeMapper();

    public SmartJsonSchemaTypeMapper(OwlReasoner reasoner) {
        this.reasoner = reasoner;
    }

    @Override
    public JsonSchemaDatatype type(PropertyConstraint property) {
        URI datatype = property.getDatatype();
        if (datatype != null) {
            if ("http://www.w3.org/2001/XMLSchema#".equals(datatype.getNamespace())) {
                return this.simple.type(property);
            }
            DatatypeRestriction r = this.reasoner.datatypeRestriction(datatype);
            URI onDatatype = r.getOnDatatype();
            if (onDatatype != null && "http://www.w3.org/2001/XMLSchema#".equals(onDatatype.getNamespace())) {
                PropertyConstraint p = new PropertyConstraint(property.getPredicate());
                p.setDatatype(onDatatype);
                JsonSchemaDatatype j = this.simple.type(p);
                if (j != null) {
                    String typeName = j.getTypeName();
                    String format = j.getFormat();
                    Boolean exclusiveMinimum = null;
                    Boolean exclusiveMaximum = null;
                    Number maximum = r.getMaxExclusive();
                    Number minimum = r.getMinExclusive();
                    if (maximum == null) {
                        maximum = r.getMaxInclusive();
                    } else {
                        exclusiveMaximum = true;
                    }
                    if (minimum == null) {
                        minimum = r.getMinInclusive();
                    } else {
                        exclusiveMinimum = true;
                    }
                    return new JsonSchemaDatatype(typeName, format, exclusiveMinimum, exclusiveMaximum, minimum, maximum);
                }
            }
        }
        return null;
    }
}

