/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.shacl.Constraint;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;

public class GraphFilter {
    public static final GraphFilter INSTANCE = new GraphFilter();

    public boolean matches(Vertex vertex, Shape shape) {
        List<PropertyConstraint> propertyList = shape.getProperty();
        Constraint constraint = shape.getConstraint();
        for (PropertyConstraint p : propertyList) {
            if (this.satisfies(vertex, p)) continue;
            return false;
        }
        return constraint == null || constraint.accept(vertex);
    }

    private boolean satisfies(Vertex vertex, PropertyConstraint p) {
        Vertex v;
        Value object;
        Graph graph = vertex.getGraph();
        URI predicate = p.getPredicate();
        Integer minCount = p.getMinCount();
        Integer maxCount = p.getMaxCount();
        URI datatype = p.getDatatype();
        URI directType = p.getDirectValueType();
        Shape valueShape = p.getValueShape();
        List<Value> allowedValues = p.getAllowedValues();
        Set set = vertex.outProperty(predicate);
        if (minCount != null && set.size() < minCount) {
            return false;
        }
        if (maxCount != null && set.size() > maxCount) {
            return false;
        }
        if (allowedValues != null) {
            for (Edge e : set) {
                object = e.getObject();
                if (allowedValues.contains(object)) continue;
                return false;
            }
        }
        if (datatype != null) {
            for (Edge e : set) {
                object = e.getObject();
                if (object instanceof Literal) {
                    Literal literal = (Literal)object;
                    URI type = literal.getDatatype();
                    if (datatype.equals((Object)type)) continue;
                    return false;
                }
                return false;
            }
        }
        if (directType != null) {
            for (Edge e : set) {
                object = e.getObject();
                if (object instanceof Resource) {
                    v = graph.vertex((Resource)object);
                    Set rdfType = v.outProperty(RDF.TYPE);
                    boolean ok = false;
                    if (!rdfType.isEmpty()) {
                        for (Edge te : rdfType) {
                            Value t = te.getObject();
                            if (!directType.equals((Object)t)) continue;
                            ok = true;
                            break;
                        }
                    }
                    if (ok) continue;
                    return false;
                }
                return false;
            }
        }
        if (valueShape != null) {
            for (Edge e : set) {
                object = e.getObject();
                if (object instanceof Resource) {
                    v = graph.vertex((Resource)object);
                    if (this.matches(v, valueShape)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public List<Vertex> select(Graph source, Shape shape) {
        ArrayList<Vertex> list = new ArrayList<Vertex>();
        return list;
    }
}

