/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.core.AmbiguousPreferredClassException;
import io.konig.core.OwlReasoner;
import io.konig.shacl.ClassManager;
import io.konig.shacl.LogicalShapeNamer;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class LogicalShapeBuilder {
    private OwlReasoner reasoner;
    private LogicalShapeNamer shapeNamer;
    private Set<URI> stack;

    public LogicalShapeBuilder(OwlReasoner reasoner, LogicalShapeNamer shapeNamer) {
        this.reasoner = reasoner;
        this.shapeNamer = shapeNamer;
    }

    private URI scopeClass(Shape shape) {
        URI scopeClass = shape.getScopeClass();
        try {
            return scopeClass == null ? null : this.reasoner.preferredClassAsURI(scopeClass);
        }
        catch (AmbiguousPreferredClassException e) {
            throw new RuntimeException(e);
        }
    }

    public void buildLogicalShapes(ShapeManager shapeManager, ClassManager classManager) {
        List<Shape> list = shapeManager.listShapes();
        this.stack = new HashSet<URI>();
        for (Shape shape : list) {
            URI scopeClass = this.scopeClass(shape);
            Shape logicalShape = classManager.getLogicalShape((Resource)scopeClass);
            if (logicalShape != null) continue;
            this.buildLogicalShape(list, scopeClass, classManager);
        }
        for (URI owlClass : this.stack) {
            Shape prior = classManager.getLogicalShape((Resource)owlClass);
            if (prior != null) continue;
            URI shapeId = this.shapeNamer.logicalShapeForOwlClass(owlClass);
            Shape shape = new Shape((Resource)shapeId);
            shape.setScopeClass(owlClass);
            classManager.addLogicalShape(shape);
        }
        this.stack = null;
    }

    private void buildLogicalShape(List<Shape> list, URI scopeClass, ClassManager classManager) {
        if (scopeClass == null) {
            return;
        }
        URI shapeId = this.shapeNamer.logicalShapeForOwlClass(scopeClass);
        Shape shape = new Shape((Resource)shapeId);
        shape.setScopeClass(scopeClass);
        classManager.addLogicalShape(shape);
        List<Shape> filter = this.filterByScopeClass(list, scopeClass);
        Map<String, List<PropertyConstraint>> map = this.buildPropertyMap(filter);
        for (List<PropertyConstraint> pList : map.values()) {
            this.mergeProperties(shape, pList);
        }
    }

    private Resource preferredClass(Resource owlClass) {
        try {
            return owlClass == null ? null : this.reasoner.preferredClass(owlClass).getId();
        }
        catch (AmbiguousPreferredClassException e) {
            throw new RuntimeException(e);
        }
    }

    private void mergeProperties(Shape shape, List<PropertyConstraint> pList) {
        PropertyConstraint constraint = null;
        for (PropertyConstraint p : pList) {
            if (constraint == null) {
                constraint = new PropertyConstraint(p.getPredicate());
                shape.add(constraint);
            }
            Integer minCountA = constraint.getMinCount();
            Integer minCountB = p.getMinCount();
            if (minCountA == null) {
                constraint.setMinCount(minCountB);
            } else if (minCountB == null || minCountB < minCountA) {
                constraint.setMinCount(minCountB);
            }
            Integer maxCountA = constraint.getMaxCount();
            Integer maxCountB = p.getMaxCount();
            if (maxCountA == null) {
                constraint.setMaxCount(maxCountB);
            } else if (maxCountB == null || maxCountB > maxCountA) {
                constraint.setMaxCount(maxCountB);
            }
            Resource datatypeA = this.preferredClass((Resource)constraint.getDatatype());
            Resource datatypeB = this.preferredClass((Resource)p.getDatatype());
            Resource classA = this.preferredClass(constraint.getValueClass());
            Resource classB = this.preferredClass(p.getValueClass());
            Shape valueShapeA = constraint.getValueShape();
            Shape valueShapeB = p.getValueShape();
            if (valueShapeB != null) {
                classB = this.leastUpperBound(shape, p, "sh:class", (Resource)this.scopeClass(valueShapeB), classB);
            }
            if (valueShapeA != null && classA == null) {
                classA = valueShapeA.getScopeClass();
            }
            if (valueShapeA != null && classA != null) {
                classA = this.leastUpperBound(shape, p, "sh:class", (Resource)this.scopeClass(valueShapeA), classA);
            }
            classB = this.leastUpperBound(shape, p, "sh:class", classB, classA);
            datatypeB = (URI)this.leastUpperBound(shape, p, "sh:datatype", datatypeB, datatypeA);
            if (classB instanceof URI) {
                this.stack.add((URI)classB);
            }
            constraint.setValueClass(classB);
            constraint.setDatatype((URI)datatypeB);
        }
    }

    private Resource leastUpperBound(Shape shape, PropertyConstraint p, String context, Resource classA, Resource classB) {
        if (classA != null && classB == null) {
            return classA;
        }
        if (classB != null && classA == null) {
            return classB;
        }
        if (classA != null && classB != null) {
            if (classA.equals(classB)) {
                return classA;
            }
            throw new RuntimeException("Conflicting " + context + " detected on property " + p.getPredicate().getLocalName() + " of " + shape.getScopeClass().getLocalName());
        }
        return null;
    }

    private Map<String, List<PropertyConstraint>> buildPropertyMap(List<Shape> list) {
        HashMap<String, List<PropertyConstraint>> map = new HashMap<String, List<PropertyConstraint>>();
        for (Shape shape : list) {
            List<PropertyConstraint> pList = shape.getProperty();
            for (PropertyConstraint p : pList) {
                URI predicate = p.getPredicate();
                ArrayList<PropertyConstraint> sink = (ArrayList<PropertyConstraint>)map.get(predicate.stringValue());
                if (sink == null) {
                    sink = new ArrayList<PropertyConstraint>();
                    map.put(predicate.stringValue(), sink);
                }
                sink.add(p);
            }
        }
        return map;
    }

    private List<Shape> filterByScopeClass(List<Shape> list, URI scopeClass) {
        ArrayList<Shape> result = new ArrayList<Shape>();
        for (Shape shape : list) {
            if (!scopeClass.equals((Object)this.scopeClass(shape))) continue;
            result.add(shape);
        }
        return result;
    }
}

