/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Term;
import io.konig.core.UidGenerator;
import io.konig.core.impl.KonigLiteral;
import io.konig.shacl.NodeKind;
import io.konig.shacl.Shape;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class PropertyConstraint {
    private Resource id;
    private URI predicate;
    private List<Value> allowedValues;
    private Integer minCount;
    private Integer maxCount;
    private Integer minLength;
    private Integer maxLength;
    private Double minExclusive;
    private Double maxExclusive;
    private Double minInclusive;
    private Double maxInclusive;
    private URI datatype;
    private URI directType;
    private Resource valueShapeId;
    private Shape valueShape;
    private NodeKind nodeKind;
    private Set<Value> hasValue;
    private String pattern;
    private Resource valueClass;
    private String documentation;
    private List<Value> knownValue;
    private boolean uniqueCountKey;
    private URI dimensionTerm;
    private boolean timeParam;
    private Term term;

    public PropertyConstraint(URI predicate) {
        this.id = new BNodeImpl(UidGenerator.INSTANCE.next());
        this.predicate = predicate;
    }

    public PropertyConstraint(Resource id, URI predicate) {
        this.id = id;
        this.predicate = predicate;
    }

    public PropertyConstraint() {
    }

    public void setId(Resource id) {
        this.id = id;
    }

    public PropertyConstraint clone() {
        PropertyConstraint other = new PropertyConstraint(this.id, this.predicate);
        other.allowedValues = this.allowedValues;
        other.datatype = this.datatype;
        other.directType = this.directType;
        other.documentation = this.documentation;
        other.hasValue = this.hasValue;
        other.knownValue = this.knownValue;
        other.maxCount = this.maxCount;
        other.maxExclusive = this.maxExclusive;
        other.maxInclusive = this.maxInclusive;
        other.maxLength = this.maxLength;
        other.minCount = this.minCount;
        other.minExclusive = this.minExclusive;
        other.minInclusive = this.minInclusive;
        other.minLength = this.minLength;
        other.nodeKind = this.nodeKind;
        other.pattern = this.pattern;
        other.term = this.term;
        other.valueClass = this.valueClass;
        other.valueShape = this.valueShape;
        other.valueShapeId = this.valueShapeId;
        return other;
    }

    public Resource getId() {
        return this.id;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Double getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(Double minExclusive) {
        this.minExclusive = minExclusive;
    }

    public Double getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(Double maxExclusive) {
        this.maxExclusive = maxExclusive;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public Double getMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(Double minInclusive) {
        this.minInclusive = minInclusive;
    }

    public Double getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(Double maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public URI getPredicate() {
        return this.predicate;
    }

    public void setPredicate(URI predicate) {
        this.predicate = predicate;
    }

    public NodeKind getNodeKind() {
        return this.nodeKind;
    }

    public void setNodeKind(NodeKind nodeKind) {
        this.nodeKind = nodeKind;
    }

    public void addAllowedValue(Value value) {
        if (this.allowedValues == null) {
            this.allowedValues = new ArrayList<Value>();
        }
        this.allowedValues.add(value);
    }

    public void setAllowedValue(List<Value> list) {
        this.allowedValues = list;
    }

    public void addKnownValue(Value value) {
        if (this.knownValue == null) {
            this.knownValue = new ArrayList<Value>();
        }
        this.knownValue.add(value);
    }

    public List<Value> getKnownValue() {
        return this.knownValue;
    }

    public void addHasValue(Value value) {
        Literal literal;
        URI datatype;
        if (this.hasValue == null) {
            this.hasValue = new HashSet<Value>();
        }
        if (value instanceof Literal && (datatype = (literal = (Literal)value).getDatatype()) != null && XMLSchema.STRING.equals((Object)datatype)) {
            value = new KonigLiteral(literal.stringValue());
        }
        this.hasValue.add(value);
    }

    public Set<Value> getHasValue() {
        return this.hasValue;
    }

    public void setHasValue(Set<Value> set) {
        this.hasValue = set;
    }

    public List<Value> getAllowedValues() {
        return this.allowedValues;
    }

    public Integer getMinCount() {
        return this.minCount;
    }

    public void setMinCount(Integer minCount) {
        this.minCount = minCount;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        this.maxCount = maxCount;
    }

    public URI getDatatype() {
        return this.datatype;
    }

    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    public URI getDirectValueType() {
        return this.directType;
    }

    public void setDirectValueType(URI directType) {
        this.directType = directType;
    }

    public Resource getValueShapeId() {
        return this.valueShapeId;
    }

    public void setValueShapeId(URI valueShape) {
        this.valueShapeId = valueShape;
    }

    public Shape getValueShape() {
        return this.valueShape;
    }

    public void setValueShape(Shape valueShape) {
        this.valueShape = valueShape;
        this.valueShapeId = valueShape.getId();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator json = factory.createGenerator((Writer)out);
            json.useDefaultPrettyPrinter();
            this.toJson(json);
            json.flush();
        }
        catch (IOException e) {
            return "ERROR:" + e.getMessage();
        }
        return out.toString();
    }

    public void toJson(JsonGenerator json) throws IOException {
        json.writeStartObject();
        if (this.predicate != null) {
            json.writeStringField("predicate", this.predicate.toString());
        }
        if (this.minCount != null) {
            json.writeNumberField("minCount", this.minCount.intValue());
        }
        if (this.maxCount != null) {
            json.writeNumberField("maxCount", this.maxCount.intValue());
        }
        if (this.datatype != null) {
            json.writeStringField("datatype", this.datatype.stringValue());
        }
        if (this.directType != null) {
            json.writeStringField("directType", this.directType.stringValue());
        }
        if (this.minInclusive != null) {
            json.writeNumberField("minInclusive", this.minInclusive.doubleValue());
        }
        if (this.maxInclusive != null) {
            json.writeNumberField("maxInclusive", this.maxInclusive.doubleValue());
        }
        if (this.nodeKind != null) {
            json.writeStringField("nodeKind", "sh:" + this.nodeKind.getURI().getLocalName());
        }
        if (this.valueClass != null) {
            json.writeStringField("class", this.valueClass.stringValue());
        }
        if (this.valueShape != null) {
            json.writeFieldName("valueShape");
            this.valueShape.toJson(json);
        } else if (this.valueShapeId != null) {
            json.writeStringField("valueShape", this.valueShapeId.toString());
        }
        json.writeEndObject();
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Resource getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Resource valueClass) {
        this.valueClass = valueClass;
    }

    public boolean isUniqueCountKey() {
        return this.uniqueCountKey;
    }

    public void setUniqueCountKey(boolean uniqueCountKey) {
        this.uniqueCountKey = uniqueCountKey;
    }

    public URI getDimensionTerm() {
        return this.dimensionTerm;
    }

    public void setDimensionTerm(URI dimensionTerm) {
        this.dimensionTerm = dimensionTerm;
    }

    public boolean isTimeParam() {
        return this.timeParam;
    }

    public void setTimeParam(boolean timeParam) {
        this.timeParam = timeParam;
    }
}

