/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.annotation.RdfProperty;
import io.konig.core.Context;
import io.konig.core.UidGenerator;
import io.konig.shacl.Constraint;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.impl.EmptyList;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.BNodeImpl;

public class Shape {
    private static final List<PropertyConstraint> EMPTY_PROPERTY_LIST = new EmptyList<PropertyConstraint>();
    private Resource id;
    private URI scopeClass;
    private List<PropertyConstraint> property;
    private Constraint constraint;
    private Context jsonldContext;
    private URI equivalentRelationalShape;

    public Shape() {
        String bnodeId = UidGenerator.INSTANCE.next();
        this.id = new BNodeImpl(bnodeId);
    }

    public Shape(Resource id) {
        this.id = id;
    }

    public List<PropertyConstraint> getProperty() {
        return this.property == null ? EMPTY_PROPERTY_LIST : this.property;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Shape setConstraint(Constraint constraint) {
        this.constraint = constraint;
        return this;
    }

    public PropertyConstraint getTimeParam() {
        if (this.property != null) {
            for (PropertyConstraint c : this.property) {
                if (!c.isTimeParam()) continue;
                return c;
            }
        }
        return null;
    }

    public PropertyConstraint getDimensionConstraint(URI dimension) {
        if (this.property != null) {
            for (PropertyConstraint c : this.property) {
                URI d = c.getDimensionTerm();
                if (!dimension.equals((Object)d)) continue;
                return c;
            }
        }
        return null;
    }

    public PropertyConstraint getPropertyConstraint(URI predicate) {
        if (this.property != null) {
            for (PropertyConstraint c : this.property) {
                if (!predicate.equals((Object)c.getPredicate())) continue;
                return c;
            }
        }
        return null;
    }

    public boolean hasPropertyConstraint(URI predicate) {
        if (this.getPropertyConstraint(predicate) != null) {
            return true;
        }
        if (this.constraint != null) {
            return this.constraint.hasPropertyConstraint(predicate);
        }
        return false;
    }

    public PropertyConstraint property(URI predicate) {
        if (this.property != null) {
            for (PropertyConstraint p : this.property) {
                if (!p.getPredicate().equals((Object)predicate)) continue;
                return p;
            }
        }
        return null;
    }

    @RdfProperty(value="http://www.w3.org/ns/shacl#property")
    public Shape add(PropertyConstraint c) {
        if (this.property == null) {
            this.property = new ArrayList<PropertyConstraint>();
        }
        URI id = c.getPredicate();
        for (PropertyConstraint p : this.property) {
            URI predicate = p.getPredicate();
            if (predicate == null || !predicate.equals((Object)id)) continue;
            return this;
        }
        this.property.add(c);
        return this;
    }

    public URI getScopeClass() {
        return this.scopeClass;
    }

    public void setScopeClass(URI scopeClass) {
        this.scopeClass = scopeClass;
    }

    public Resource getId() {
        return this.id;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator json = factory.createGenerator((Writer)out);
            json.useDefaultPrettyPrinter();
            this.toJson(json);
            json.flush();
        }
        catch (IOException e) {
            return "ERROR: " + e.getMessage();
        }
        return out.toString();
    }

    public void toJson(JsonGenerator json) throws IOException {
        json.writeStartObject();
        json.writeStringField("id", this.id.toString());
        if (this.scopeClass != null) {
            json.writeStringField("scopeClass", this.scopeClass.stringValue());
        }
        if (this.property != null && !this.property.isEmpty()) {
            json.writeFieldName("property");
            json.writeStartArray();
            for (PropertyConstraint p : this.property) {
                p.toJson(json);
            }
            json.writeEndArray();
        }
        json.writeEndObject();
    }

    public Context getJsonldContext() {
        return this.jsonldContext;
    }

    public void setJsonldContext(Context jsonldContext) {
        this.jsonldContext = jsonldContext;
    }

    public URI getEquivalentRelationalShape() {
        return this.equivalentRelationalShape;
    }

    public void setEquivalentRelationalShape(URI equivalentRelationalShape) {
        this.equivalentRelationalShape = equivalentRelationalShape;
    }
}

