/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl;

import io.konig.shacl.AndConstraint;
import io.konig.shacl.NodeKind;
import io.konig.shacl.OrConstraint;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeConsumer;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.impl.MemoryShapeManager;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;

public class ShapeBuilder {
    private PropertyBuilder propertyBuilder;
    private ShapeManager shapeManager;
    private ValueFactory valueFactory = new ValueFactoryImpl();
    private List<Object> stack = new ArrayList<Object>();

    public ShapeBuilder(PropertyBuilder propertyBuilder, ShapeManager shapeManager, ValueFactory valueFactory, Shape shape) {
        this.propertyBuilder = propertyBuilder;
        this.shapeManager = shapeManager;
        this.valueFactory = valueFactory;
        this.stack.add(shape);
    }

    public ShapeBuilder(ShapeManager shapeManager, ValueFactory valueFactory, Shape shape) {
        this.shapeManager = shapeManager;
        this.valueFactory = valueFactory;
        this.stack.add(shape);
    }

    public PropertyBuilder endValueShape() {
        return this.propertyBuilder;
    }

    public Shape getShape(String uri) {
        return this.shapeManager.getShapeById((URI)new URIImpl(uri));
    }

    private ShapeConsumer peekConsumer() {
        Object result = this.peek();
        return result instanceof ShapeConsumer ? (ShapeConsumer)result : null;
    }

    private Object peek() {
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    private Shape peekShape() {
        Object result = this.peek();
        return result instanceof Shape ? (Shape)result : null;
    }

    public ShapeBuilder(Shape shape) {
        this.shapeManager = new MemoryShapeManager();
        this.stack.add(shape);
        this.shapeManager.addShape(shape);
    }

    public ShapeBuilder() {
        this.shapeManager = new MemoryShapeManager();
    }

    public ShapeBuilder(String shapeId) {
        this((Resource)new URIImpl(shapeId));
    }

    public ShapeBuilder(Resource shapeId) {
        this(new Shape(shapeId));
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public ShapeBuilder documentation(String text) {
        return this;
    }

    public ShapeBuilder shape(String shapeIRI) {
        return this.beginShape((URI)new URIImpl(shapeIRI));
    }

    public ShapeBuilder scopeClass(URI type) {
        this.peekShape().setScopeClass(type);
        return this;
    }

    public PropertyBuilder beginProperty(URI predicate) {
        return this.property(predicate);
    }

    public PropertyBuilder property(URI predicate) {
        BNode id = this.valueFactory.createBNode();
        PropertyConstraint p = new PropertyConstraint((Resource)id, predicate);
        this.peekShape().add(p);
        return new PropertyBuilder(this, p);
    }

    public ShapeBuilder beginShape(URI shapeId) {
        Shape shape = this.shapeManager.getShapeById(shapeId);
        if (shape == null) {
            shape = new Shape((Resource)shapeId);
            this.shapeManager.addShape(shape);
        }
        this.stack.add(shape);
        return this;
    }

    public ShapeBuilder beginOr() {
        OrConstraint constraint = new OrConstraint();
        this.peekShape().setConstraint(constraint);
        this.stack.add(constraint);
        return this;
    }

    public ShapeBuilder endOr() {
        return this.pop();
    }

    public ShapeBuilder beginAnd() {
        AndConstraint constraint = new AndConstraint();
        this.peekShape().setConstraint(constraint);
        this.stack.add(constraint);
        return this;
    }

    public ShapeBuilder endAnd() {
        return this.pop();
    }

    public ShapeBuilder beginShape(Resource resource) {
        ShapeConsumer consumer;
        Shape shape = new Shape(resource);
        if (resource instanceof URI) {
            this.shapeManager.addShape(shape);
        }
        if ((consumer = this.peekConsumer()) != null) {
            consumer.add(shape);
        }
        this.stack.add(shape);
        return this;
    }

    public ShapeBuilder beginShape(String iri) {
        URI uri = this.valueFactory.createURI(iri);
        return this.beginShape(uri);
    }

    public ShapeBuilder beginShape() {
        BNode shapeId = this.valueFactory.createBNode();
        Shape shape = new Shape((Resource)shapeId);
        ShapeConsumer consumer = this.peekConsumer();
        if (consumer != null) {
            consumer.add(shape);
        }
        this.stack.add(shape);
        return this;
    }

    public ShapeBuilder endShape() {
        return this.pop();
    }

    private ShapeBuilder pop() {
        if (!this.stack.isEmpty()) {
            this.stack.remove(this.stack.size() - 1);
        }
        return this;
    }

    public Shape shape() {
        return this.peekShape();
    }

    public static class PropertyBuilder {
        private ShapeBuilder parent;
        private PropertyConstraint property;

        PropertyBuilder(ShapeBuilder parent, PropertyConstraint property) {
            this.parent = parent;
            this.property = property;
        }

        public ShapeBuilder beginValueShape(String iri) {
            URI uri = this.parent.valueFactory.createURI(iri);
            return this.beginValueShape(uri);
        }

        public ShapeBuilder endProperty() {
            return this.parent;
        }

        public PropertyBuilder endValueShape() {
            return this.parent.endValueShape();
        }

        public ShapeBuilder beginValueShape(URI shapeId) {
            Shape shape = this.parent.shapeManager.getShapeById(shapeId);
            if (shape == null) {
                shape = new Shape((Resource)shapeId);
                this.parent.shapeManager.addShape(shape);
            }
            this.property.setValueShapeId(shapeId);
            this.property.setValueShape(shape);
            return new ShapeBuilder(this, this.parent.shapeManager, this.parent.valueFactory, shape);
        }

        public PropertyBuilder isTimeParam(boolean truth) {
            this.property.setTimeParam(truth);
            return this;
        }

        public PropertyBuilder documentation(String text) {
            this.property.setDocumentation(text);
            return this;
        }

        public PropertyBuilder nodeKind(NodeKind kind) {
            this.property.setNodeKind(kind);
            return this;
        }

        public PropertyBuilder allowedValue(Value value) {
            this.property.addAllowedValue(value);
            return this;
        }

        public PropertyBuilder allowedIRI(String iri) {
            this.property.addAllowedValue((Value)new URIImpl(iri));
            return this;
        }

        public PropertyBuilder minInclusive(double value) {
            this.property.setMinInclusive(value);
            return this;
        }

        public PropertyBuilder maxInclusive(double value) {
            this.property.setMaxInclusive(value);
            return this;
        }

        public PropertyBuilder datatype(URI type) {
            this.property.setDatatype(type);
            return this;
        }

        public PropertyBuilder dimension(URI dimension) {
            this.property.setDimensionTerm(dimension);
            return this;
        }

        public PropertyBuilder maxCount(int value) {
            this.property.setMaxCount(value);
            return this;
        }

        public PropertyBuilder minCount(int value) {
            this.property.setMinCount(value);
            return this;
        }

        public PropertyBuilder valueShape(URI shapeId) {
            Shape shape = this.parent.shapeManager.getShapeById(shapeId);
            if (shape == null) {
                shape = new Shape((Resource)shapeId);
                this.parent.shapeManager.addShape(shape);
            }
            this.property.setValueShapeId(shapeId);
            this.property.setValueShape(shape);
            return this;
        }

        public PropertyBuilder valueClass(URI type) {
            this.property.setValueClass((Resource)type);
            return this;
        }

        public PropertyBuilder directType(URI type) {
            this.property.setDirectValueType(type);
            return this;
        }

        public PropertyBuilder property(URI predicate) {
            return this.parent.property(predicate);
        }

        public ShapeBuilder shape(String shapeIRI) {
            return this.parent.shape(shapeIRI);
        }

        public Shape shape() {
            return this.parent.shape();
        }

        public ShapeBuilder endShape() {
            return this.parent.endShape();
        }
    }
}

