/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.impl;

import io.konig.core.NamespaceManager;
import io.konig.shacl.LogicalShapeNamer;
import org.openrdf.model.Namespace;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class BasicLogicalShapeNamer
implements LogicalShapeNamer {
    private String defaultPrefix = "default";
    private String baseURI;
    private NamespaceManager nsManager;

    public BasicLogicalShapeNamer(String baseURI, NamespaceManager nsManager) {
        if (!baseURI.endsWith("/")) {
            baseURI = baseURI + "/";
        }
        this.baseURI = baseURI;
        this.nsManager = nsManager;
    }

    @Override
    public URI logicalShapeForOwlClass(URI owlClass) {
        if (owlClass == null) {
            return null;
        }
        Namespace ns = this.nsManager.findByName(owlClass.getNamespace());
        String prefix = ns == null ? this.defaultPrefix : ns.getPrefix();
        StringBuilder builder = new StringBuilder();
        builder.append(this.baseURI);
        builder.append(prefix);
        builder.append('/');
        builder.append(owlClass.getLocalName());
        return new URIImpl(builder.toString());
    }
}

