/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.impl;

import io.konig.core.UnnamedResourceException;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.URI;

public class MemoryShapeManager
implements ShapeManager {
    private Map<String, Shape> shapeMap = new HashMap<String, Shape>();

    @Override
    public Shape getShapeById(URI shapeId) {
        return this.shapeMap.get(shapeId.stringValue());
    }

    @Override
    public void addShape(Shape shape) throws UnnamedResourceException {
        if (shape.getId() instanceof BNode) {
            throw new UnnamedResourceException("Cannot add unnamed Shape to this manager");
        }
        this.shapeMap.put(shape.getId().stringValue(), shape);
    }

    public List<Shape> getShapesByPredicate(URI predicate) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        for (Shape s : this.shapeMap.values()) {
            if (!s.hasPropertyConstraint(predicate)) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public List<Shape> getShapesByScopeClass(URI scopeClass) {
        ArrayList<Shape> list = new ArrayList<Shape>();
        for (Shape s : this.shapeMap.values()) {
            if (!scopeClass.equals((Object)s.getScopeClass())) continue;
            list.add(s);
        }
        return list;
    }

    @Override
    public List<Shape> listShapes() {
        return new ArrayList<Shape>(this.shapeMap.values());
    }
}

