/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.io;

import io.konig.core.ContextManager;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.KonigValueFactory;
import io.konig.core.ListHandler;
import io.konig.core.NamespaceManager;
import io.konig.core.io.CompositeRdfHandler;
import io.konig.core.io.JsonldParser;
import io.konig.core.io.ListRdfHandler;
import io.konig.core.io.NamespaceRDFHandler;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.io.ShapeLoadException;
import io.konig.shacl.io.ShapeRdfHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.turtle.TurtleParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeLoader {
    private static final Logger logger = LoggerFactory.getLogger(ShapeLoader.class);
    private ContextManager contextManager;
    private ShapeManager shapeManager;
    private NamespaceManager namespaceManager;
    private ValueFactory valueFactory;
    private RDFHandler listener;

    public ShapeLoader(ContextManager contextManager, ShapeManager shapeManager) {
        this(contextManager, shapeManager, null, null);
    }

    public RDFHandler getListener() {
        return this.listener;
    }

    public void setListener(RDFHandler listener) {
        this.listener = listener;
    }

    public ShapeLoader(ContextManager contextManager, ShapeManager shapeManager, NamespaceManager namespaceManager) {
        this(contextManager, shapeManager, namespaceManager, null);
    }

    public ShapeLoader(ContextManager contextManager, ShapeManager shapeManager, NamespaceManager namespaceManager, ValueFactory valueFactory) {
        if (valueFactory == null) {
            valueFactory = new KonigValueFactory();
        }
        this.contextManager = contextManager;
        this.shapeManager = shapeManager;
        this.namespaceManager = namespaceManager;
        this.valueFactory = valueFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadAll(File source) throws ShapeLoadException {
        if (source.isDirectory()) {
            File[] kids;
            for (File file : kids = source.listFiles()) {
                this.loadAll(file);
            }
            return;
        } else {
            try {
                FileInputStream input = new FileInputStream(source);
                try {
                    String name = source.getName();
                    if (name.endsWith(".ttl")) {
                        this.loadTurtle(input);
                        return;
                    }
                    if (!name.endsWith(".jsonld")) return;
                    this.loadJsonld(input);
                    return;
                }
                catch (Throwable oops) {
                    throw new ShapeLoadException("Failed to load " + source.getName(), oops);
                }
                finally {
                    this.close(input);
                }
            }
            catch (FileNotFoundException e) {
                throw new ShapeLoadException(e);
            }
        }
    }

    private void close(FileInputStream input) {
        try {
            input.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close file input stream", (Throwable)e);
        }
    }

    public void loadTurtle(InputStream input) throws ShapeLoadException {
        TurtleParser parser = new TurtleParser();
        ShapeRdfHandler shapeHandler = new ShapeRdfHandler(this.shapeManager);
        ListRdfHandler listHandler = new ListRdfHandler((ListHandler)shapeHandler, (RDFHandler)shapeHandler);
        CompositeRdfHandler composite = new CompositeRdfHandler(new RDFHandler[]{listHandler});
        if (this.namespaceManager != null) {
            composite.add((Object)new NamespaceRDFHandler(this.namespaceManager));
        }
        if (this.listener != null) {
            composite.add((Object)this.listener);
        }
        parser.setRDFHandler((RDFHandler)composite);
        try {
            parser.parse(input, "");
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            throw new ShapeLoadException(e);
        }
    }

    public void loadJsonld(InputStream input) throws ShapeLoadException {
        this.load(input, null);
    }

    public void load(Graph graph) throws ShapeLoadException {
        ShapeRdfHandler handler = new ShapeRdfHandler(this.shapeManager);
        try {
            handler.startRDF();
            for (Edge edge : graph) {
                handler.handleStatement((Statement)edge);
            }
            handler.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new ShapeLoadException(e);
        }
    }

    public void load(InputStream input, RDFHandler handler) throws ShapeLoadException {
        ShapeRdfHandler rdfHandler = new ShapeRdfHandler(this.shapeManager);
        CompositeRdfHandler composite = new CompositeRdfHandler(new RDFHandler[]{rdfHandler});
        if (handler != null) {
            composite.add((Object)handler);
        }
        if (this.listener != null) {
            composite.add((Object)this.listener);
        }
        JsonldParser parser = new JsonldParser(this.contextManager, this.namespaceManager, this.valueFactory);
        parser.setRDFHandler((RDFHandler)composite);
        try {
            parser.parse(input, "");
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            throw new ShapeLoadException(e);
        }
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }
}

