/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.io;

import io.konig.core.ListHandler;
import io.konig.core.vocab.KOL;
import io.konig.core.vocab.SH;
import io.konig.shacl.AndConstraint;
import io.konig.shacl.Constraint;
import io.konig.shacl.NodeKind;
import io.konig.shacl.OrConstraint;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeConsumer;
import io.konig.shacl.ShapeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class ShapeRdfHandler
extends RDFHandlerBase
implements ListHandler {
    private ShapeManager shapeManager;
    private Map<String, PropertyConstraint> propertyConstraint = new HashMap<String, PropertyConstraint>();
    private Map<String, Shape> shapeMap = new HashMap<String, Shape>();
    private List<Statement> constraintList = new ArrayList<Statement>();
    private Map<String, ConstraintList> constraintMap = new HashMap<String, ConstraintList>();

    public ShapeRdfHandler(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        PropertyConstraint p;
        Resource subject = st.getSubject();
        URI predicate = st.getPredicate();
        Value object = st.getObject();
        if (predicate.equals((Object)SH.property)) {
            this.shape(subject).add(this.property(object));
        } else if (predicate.equals((Object)SH.scopeClass)) {
            this.shape(subject).setScopeClass((URI)object);
        } else if (predicate.equals((Object)KOL.equivalentRelationalShape) && object instanceof URI) {
            this.shape(subject).setEquivalentRelationalShape((URI)object);
        } else if (predicate.equals((Object)SH.predicate)) {
            this.property((Value)subject).setPredicate((URI)object);
        } else if (predicate.equals((Object)SH.datatype)) {
            this.property((Value)subject).setDatatype((URI)object);
        } else if (predicate.equals((Object)SH.directType)) {
            this.property((Value)subject).setDirectValueType((URI)object);
        } else if (predicate.equals((Object)SH.hasValue)) {
            this.property((Value)subject).addHasValue(object);
        } else if (predicate.equals((Object)SH.minCount)) {
            this.property((Value)subject).setMinCount(this.integer(object));
        } else if (predicate.equals((Object)SH.maxCount)) {
            this.property((Value)subject).setMaxCount(this.integer(object));
        } else if (predicate.equals((Object)SH.minExclusive)) {
            this.property((Value)subject).setMinExclusive(this.real(object));
        } else if (predicate.equals((Object)SH.maxExclusive)) {
            this.property((Value)subject).setMaxExclusive(this.real(object));
        } else if (predicate.equals((Object)SH.minInclusive)) {
            this.property((Value)subject).setMinInclusive(this.real(object));
        } else if (predicate.equals((Object)SH.maxInclusive)) {
            this.property((Value)subject).setMaxInclusive(this.real(object));
        } else if (predicate.equals((Object)SH.minLength)) {
            this.property((Value)subject).setMinLength(this.integer(object));
        } else if (predicate.equals((Object)SH.maxLength)) {
            this.property((Value)subject).setMaxLength(this.integer(object));
        } else if (predicate.equals((Object)SH.nodeKind)) {
            this.property((Value)subject).setNodeKind(this.nodeKind(object));
        } else if (predicate.equals((Object)SH.pattern)) {
            this.property((Value)subject).setPattern(object.stringValue());
        } else if (predicate.equals((Object)SH.valueClass)) {
            this.property((Value)subject).setValueClass((Resource)object);
        } else if (predicate.equals((Object)SH.valueShape)) {
            this.property((Value)subject).setValueShape(this.shape((Resource)object));
        } else if (predicate.equals((Object)SH.constraint)) {
            this.constraintList.add(st);
        } else if (predicate.equals((Object)RDFS.COMMENT) && (p = this.getProperty((Value)subject)) != null) {
            p.setDocumentation(object.stringValue());
        }
    }

    public void endRDF() throws RDFHandlerException {
        for (Statement s : this.constraintList) {
            Resource subject = s.getSubject();
            Value object = s.getObject();
            Shape targetShape = this.shape(subject);
            ConstraintList clist = this.constraintMap.get(object.stringValue());
            if (clist == null) continue;
            URI predicate = clist.predicate;
            Constraint c = predicate.equals((Object)SH.or) ? new OrConstraint() : new AndConstraint();
            targetShape.setConstraint(c);
            ShapeConsumer consumer = c;
            for (Value value : clist.list) {
                if (!(value instanceof Resource)) continue;
                Resource shapeId = (Resource)value;
                Shape child = this.shape(shapeId);
                consumer.add(child);
            }
        }
    }

    private NodeKind nodeKind(Value object) throws RDFHandlerException {
        NodeKind result;
        if (object instanceof URI && (result = NodeKind.fromURI((URI)object)) != null) {
            return result;
        }
        throw new RDFHandlerException("Invalid nodeKind: " + object.stringValue());
    }

    private Double real(Value object) {
        Literal literal = (Literal)object;
        return literal.doubleValue();
    }

    private Integer integer(Value object) {
        Literal literal = (Literal)object;
        return literal.intValue();
    }

    private PropertyConstraint getProperty(Value id) {
        return this.propertyConstraint.get(id.stringValue());
    }

    private PropertyConstraint property(Value id) {
        PropertyConstraint property = this.propertyConstraint.get(id.stringValue());
        if (property == null) {
            property = new PropertyConstraint((Resource)id, null);
            this.propertyConstraint.put(id.stringValue(), property);
        }
        return property;
    }

    private Shape shape(Resource subject) {
        Shape shape = this.shapeMap.get(subject.stringValue());
        if (shape == null) {
            if (subject instanceof URI) {
                shape = this.shapeManager.getShapeById((URI)subject);
                if (shape == null) {
                    shape = new Shape(subject);
                    this.shapeManager.addShape(shape);
                }
            } else {
                shape = new Shape(subject);
            }
            this.shapeMap.put(subject.stringValue(), shape);
        }
        return shape;
    }

    public void handleList(Resource subject, URI predicate, List<Value> list) throws RDFHandlerException {
        if (predicate.equals((Object)SH.in)) {
            PropertyConstraint property = this.property((Value)subject);
            for (Value value : list) {
                property.addAllowedValue(value);
            }
        }
        if (predicate.equals((Object)SH.or) || predicate.equals((Object)SH.and)) {
            this.constraintMap.put(subject.stringValue(), new ConstraintList(predicate, list));
        }
    }

    private static class ConstraintList {
        private URI predicate;
        private List<Value> list;

        public ConstraintList(URI predicate, List<Value> list) {
            this.predicate = predicate;
            this.list = list;
        }
    }
}

