/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.jsonld;

import io.konig.core.Context;
import io.konig.core.Graph;
import io.konig.core.KonigException;
import io.konig.core.NamespaceManager;
import io.konig.core.Term;
import io.konig.core.Traversal;
import io.konig.core.Vertex;
import io.konig.core.impl.BasicContext;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import io.konig.shacl.jsonld.ContextNamer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ContextGenerator.class);
    private ShapeManager shapeManager;
    private NamespaceManager nsManager;
    private ContextNamer namer;
    private Graph owl;
    private boolean ignoreTermNameClass = true;
    private boolean ignoreShapeId = true;

    public ContextGenerator(ShapeManager shapeManager, NamespaceManager nsManager, ContextNamer namer, Graph owl) {
        this.shapeManager = shapeManager;
        this.nsManager = nsManager;
        this.namer = namer;
        this.owl = owl;
    }

    public Context forShape(Shape shape) throws KonigException {
        Worker worker = new Worker();
        Context context = worker.forShape(shape);
        if (logger.isDebugEnabled()) {
            logger.debug("-----------GENERATED CONTEXT------------------------\n" + context.toString());
        }
        return context;
    }

    class Worker {
        private Context context;
        private Map<String, Term> inverse = new HashMap<String, Term>();
        private Set<String> memory = new HashSet<String>();

        public Context forShape(Shape shape) {
            if (shape.getId() instanceof BNode) {
                throw new KonigException("Shape Id must be a URI");
            }
            URI shapeId = (URI)shape.getId();
            URI contextId = ContextGenerator.this.namer.forShape(shapeId);
            this.context = new BasicContext(contextId.stringValue());
            this.addShape(shape);
            this.context.sort();
            shape.setJsonldContext(this.context);
            return this.context;
        }

        private void addShape(Shape shape) {
            Resource shapeId = shape.getId();
            if (this.memory.contains(shapeId.stringValue())) {
                return;
            }
            this.memory.add(shapeId.stringValue());
            if (shapeId instanceof URI && !ContextGenerator.this.ignoreShapeId) {
                this.addIndividual((URI)shapeId);
            }
            this.addClassHierarchy((Resource)shape.getScopeClass());
            this.addProperties(shape);
        }

        private void addProperties(Shape shape) {
            List<PropertyConstraint> list = shape.getProperty();
            for (PropertyConstraint p : list) {
                this.addProperty(p);
            }
        }

        private void addProperty(PropertyConstraint p) {
            URI predicate = p.getPredicate();
            if (this.memory.contains(predicate.stringValue())) {
                return;
            }
            this.memory.add(predicate.stringValue());
            URI datatype = p.getDatatype();
            if (datatype != null) {
                Term datatypeTerm = this.addClass(datatype);
                this.addTerm(predicate, datatypeTerm.getKey(), Term.Kind.PROPERTY);
            } else {
                Resource valueClass = p.getValueClass();
                Shape valueShape = p.getValueShape();
                URI directValueType = p.getDirectValueType();
                NodeKind nodeKind = p.getNodeKind();
                String type = null;
                if (nodeKind != null && (nodeKind == NodeKind.IRI || nodeKind == NodeKind.BlankNode)) {
                    type = "@id";
                }
                Term term = this.addTerm(predicate, type, Term.Kind.PROPERTY);
                p.setTerm(term);
                if (directValueType != null) {
                    this.addClass(directValueType);
                }
                if (valueClass != null) {
                    this.addClassHierarchy(valueClass);
                }
                if (valueShape != null) {
                    this.addShape(valueShape);
                }
            }
        }

        private Term addIndividual(URI uri) {
            return uri == null ? null : this.addTerm(uri, "@id", Term.Kind.INDIVIDUAL);
        }

        private void addClassHierarchy(Resource classId) {
            if (classId instanceof URI) {
                this.addClass((URI)classId);
            }
            if (classId != null && ContextGenerator.this.owl != null) {
                Traversal traversal = ContextGenerator.this.owl.v(classId);
                this.traverseClassHierarchy(traversal);
            }
        }

        private void traverseClassHierarchy(Traversal traversal) {
            Traversal subclasses = traversal.in(RDFS.SUBCLASSOF);
            List vertexList = subclasses.toVertexList();
            if (!vertexList.isEmpty()) {
                for (Vertex v : subclasses.toVertexList()) {
                    Resource id = v.getId();
                    if (!(id instanceof URI)) continue;
                    this.addClass((URI)id);
                }
                this.traverseClassHierarchy(subclasses);
            }
        }

        private Term addClass(URI uri) {
            return uri == null ? null : this.addTerm(uri, "@id", Term.Kind.CLASS);
        }

        private Term addTerm(URI uri, String type, Term.Kind kind) {
            String key = uri.getLocalName();
            String value = uri.stringValue();
            Term term = this.context.getTerm(key);
            if (term == null) {
                Term ns = this.addNamespace(uri);
                if (ns != null) {
                    value = ns.getKey() + ":" + key;
                }
                term = new Term(key, value, null, type);
                term.setKind(kind);
                term.setExpandedId(uri);
                this.context.add(term);
            } else if (!uri.equals((Object)term.getExpandedId())) {
                if (!ContextGenerator.this.ignoreTermNameClass) {
                    throw new KonigException("Term name clash: " + uri.stringValue() + " " + term.getExpandedIdValue());
                }
                logger.warn("Ignoring term name clash: {} {}", (Object)uri.stringValue(), (Object)term.getExpandedId());
                return null;
            }
            return term;
        }

        private Term addNamespace(URI uri) {
            Namespace ns;
            String name = uri.getNamespace();
            Term term = this.inverse.get(name);
            if (term == null && (ns = ContextGenerator.this.nsManager.findByName(name)) != null) {
                term = new Term(ns.getPrefix(), name, Term.Kind.NAMESPACE);
                this.context.add(term);
                this.inverse.put(name, term);
            }
            return term;
        }
    }
}

