/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.jsonld.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import io.konig.core.Context;
import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Term;
import io.konig.core.Vertex;
import io.konig.core.io.impl.JsonUtil;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.jsonld.JsonldShapeWriter;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class JsonldShapeWriterImpl
implements JsonldShapeWriter {
    @Override
    public void toJson(Vertex subject, Shape shape, Context context, JsonldShapeWriter.ContextOption contextOption, JsonGenerator json) throws IOException {
        String contextId;
        if (context == null) {
            context = shape.getJsonldContext();
        }
        Graph graph = subject.getGraph();
        Context inverse = context == null ? null : context.inverse();
        json.writeStartObject();
        if (contextOption == JsonldShapeWriter.ContextOption.URI && context != null && (contextId = context.getContextIRI()) != null) {
            json.writeStringField("@context", contextId);
        }
        String valueKey = "@value";
        String typeKey = "@type";
        String languageKey = "@language";
        if (context != null) {
            valueKey = context.alias(valueKey);
            typeKey = context.alias(typeKey);
            languageKey = context.alias(languageKey);
        }
        Resource id = subject.getId();
        String idValue = null;
        if (id instanceof URI) {
            Term term;
            URI uri = (URI)id;
            idValue = uri.stringValue();
            if (inverse != null && (term = inverse.getTerm(uri.getNamespace())) != null) {
                idValue = term.getId() + ":" + uri.getLocalName();
            }
        }
        if (idValue != null) {
            String idKey = "@id";
            if (context != null) {
                idKey = context.alias(idKey);
            }
            json.writeStringField(idKey, idValue);
        }
        List<PropertyConstraint> list = shape.getProperty();
        for (PropertyConstraint p : list) {
            boolean isArray;
            Set set;
            Term term = p.getTerm();
            URI predicate = p.getPredicate();
            Shape valueShape = p.getValueShape();
            if (term == null && context != null) {
                term = context.inverse().getTerm(predicate.stringValue());
            }
            if ((set = subject.outProperty(predicate)).isEmpty()) continue;
            String key = term == null ? predicate.stringValue() : term.getKey();
            json.writeFieldName(key);
            boolean bl = isArray = set.size() > 1 || term != null && term.getContainer() != null;
            if (isArray) {
                json.writeStartArray();
            }
            for (Edge edge : set) {
                Value object = edge.getObject();
                if (valueShape != null && object instanceof Resource) {
                    Resource resource = (Resource)object;
                    Vertex vertex = graph.vertex(resource);
                    this.toJson(vertex, valueShape, context, JsonldShapeWriter.ContextOption.IGNORE, json);
                    continue;
                }
                if (object instanceof URI) {
                    String namespace;
                    Term nsTerm;
                    URI uri = (URI)object;
                    idValue = uri.stringValue();
                    if (inverse != null && (nsTerm = inverse.getTerm(namespace = uri.getNamespace())) != null) {
                        idValue = nsTerm.getKey() + ":" + uri.getLocalName();
                    }
                    json.writeString(idValue);
                    continue;
                }
                if (object instanceof BNode) {
                    throw new RuntimeException("BNode without a valueShape is not supported");
                }
                if (!(object instanceof Literal)) continue;
                Literal literal = (Literal)object;
                URI datatype = literal.getDatatype();
                String language = literal.getLanguage();
                if (datatype != null) {
                    if (term != null && term.getType() != null) {
                        Object value = JsonUtil.toObject((Literal)literal);
                        if (value instanceof Long) {
                            json.writeNumber(((Long)value).longValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            json.writeNumber(((Double)value).doubleValue());
                            continue;
                        }
                        if (value instanceof Boolean) {
                            json.writeBoolean(((Boolean)value).booleanValue());
                            continue;
                        }
                        json.writeString(literal.stringValue());
                        continue;
                    }
                    json.writeStartObject();
                    json.writeStringField(valueKey, literal.stringValue());
                    json.writeStringField(typeKey, this.compactIRI(datatype, context));
                    json.writeEndObject();
                    continue;
                }
                if (language != null) {
                    json.writeStartObject();
                    json.writeStringField(valueKey, literal.stringValue());
                    json.writeStringField(languageKey, language);
                    json.writeEndObject();
                    continue;
                }
                if (term == null || term.getType() == null) {
                    json.writeStartObject();
                    json.writeStringField(valueKey, literal.stringValue());
                    json.writeEndObject();
                    continue;
                }
                json.writeString(literal.stringValue());
            }
            if (!isArray) continue;
            json.writeEndArray();
        }
        json.writeEndObject();
    }

    String compactIRI(URI iri, Context context) {
        Context inverse = context.inverse();
        Term term = inverse.getTerm(iri.getNamespace());
        return term == null ? iri.stringValue() : term.getKey() + ":" + iri.getLocalName();
    }

    @Override
    public void toJson(Vertex subject, Shape shape, JsonGenerator json) throws IOException {
        this.toJson(subject, shape, shape.getJsonldContext(), JsonldShapeWriter.ContextOption.URI, json);
    }
}

