/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.transform;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.transform.InvalidShapeException;
import java.util.List;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTransform {
    private static final Logger logger = LoggerFactory.getLogger(MergeTransform.class);
    private Vertex source;
    private Vertex target;
    private Shape targetShape;

    public MergeTransform(Vertex source, Vertex target, Shape targetShape) {
        this.source = source;
        this.target = target;
        this.targetShape = targetShape;
    }

    public static void merge(Vertex source, Vertex target, Shape targetShape) throws InvalidShapeException {
        MergeTransform transform = new MergeTransform(source, target, targetShape);
        transform.execute();
    }

    private void execute(Vertex source, Vertex target, Shape targetShape) throws InvalidShapeException {
        Graph sourceGraph = source.getGraph();
        Graph graph = target.getGraph();
        Resource targetSubject = target.getId();
        List<PropertyConstraint> list = targetShape.getProperty();
        for (PropertyConstraint property : list) {
            URI predicate = property.getPredicate();
            Shape valueShape = property.getValueShape();
            Set sourceSet = source.outProperty(predicate);
            Set targetSet = target.outProperty(predicate);
            for (Edge doomed : targetSet) {
                graph.remove(doomed);
            }
            for (Edge edge : sourceSet) {
                Value sourceObject;
                URI sourcePredicate = edge.getPredicate();
                Value targetObject = sourceObject = edge.getObject();
                if (sourceObject instanceof BNode) {
                    targetObject = graph.vertex((Resource)sourceObject).getId();
                }
                graph.edge(targetSubject, sourcePredicate, targetObject);
                if (!(targetObject instanceof Resource) || valueShape == null) continue;
                Vertex sourceVertex = sourceGraph.vertex((Resource)sourceObject);
                Vertex targetVertex = graph.vertex((Resource)targetObject);
                this.execute(sourceVertex, targetVertex, valueShape);
            }
        }
    }

    public void execute() throws InvalidShapeException {
        this.execute(this.source, this.target, this.targetShape);
    }
}

