/*
 * Decompiled with CFR 0.152.
 */
package io.konig.shacl.transform;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;

public class ReplaceTransform {
    private Vertex source;
    private Vertex target;
    private Shape shape;

    public ReplaceTransform(Vertex source, Vertex target, Shape shape) {
        this.source = source;
        this.target = target;
        this.shape = shape;
    }

    public void execute() {
        HashSet<Edge> matched = new HashSet<Edge>();
        this.deleteStatements(matched);
        this.addStatements(matched);
    }

    private void addStatements(Set<Edge> matched) {
        Graph targetGraph = this.target.getGraph();
        ArrayList<Edge> newEdge = new ArrayList<Edge>();
        List<PropertyConstraint> propertyList = this.shape.getProperty();
        for (PropertyConstraint constraint : propertyList) {
            URI predicate = constraint.getPredicate();
            Set sourceProperty = this.source.outProperty(predicate);
            for (Edge e : sourceProperty) {
                if (matched.contains(e)) continue;
                newEdge.add(e);
            }
        }
        for (Edge e : newEdge) {
            targetGraph.edge(e);
        }
    }

    private void deleteStatements(Set<Edge> matched) {
        ArrayList<Edge> zombie = new ArrayList<Edge>();
        List<PropertyConstraint> propertyList = this.shape.getProperty();
        for (PropertyConstraint constraint : propertyList) {
            URI predicate = constraint.getPredicate();
            Set sourceProperty = this.source.outProperty(predicate);
            Set targetProperty = this.target.outProperty(predicate);
            for (Edge targetEdge : targetProperty) {
                if (sourceProperty.contains(targetEdge)) {
                    matched.add(targetEdge);
                    continue;
                }
                zombie.add(targetEdge);
            }
        }
        Graph targetGraph = this.target.getGraph();
        for (Edge z : zombie) {
            targetGraph.remove(z);
        }
    }
}

