/*
 * Decompiled with CFR 0.152.
 */
package io.konig.maven.sql;

import io.konig.core.NamespaceManager;
import io.konig.core.impl.MemoryNamespaceManager;
import io.konig.core.impl.RdfUtil;
import io.konig.maven.sql.Column;
import io.konig.maven.sql.Namespace;
import io.konig.maven.sql.Schema;
import io.konig.maven.sql.Table;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.io.ShapeWriter;
import io.konig.sql.SQLFileLoader;
import io.konig.sql.SQLNamer;
import io.konig.sql.SQLSchema;
import io.konig.sql.SQLSchemaManager;
import io.konig.sql.SQLTableNamerImpl;
import io.konig.sql.SQLTableSchema;
import io.konig.sql.SQLTableShapeGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFHandlerException;

@Mojo(name="generate")
public class KonigSqlShapeMojo
extends AbstractMojo {
    @Parameter
    private String baseIRI;
    @Parameter
    private File sourceDir;
    @Parameter
    private File outDir;
    @Parameter
    private String aliasNamespace;
    @Parameter
    private List<Schema> schemas = new ArrayList<Schema>();
    @Parameter
    private List<Namespace> namespaces = new ArrayList<Namespace>();
    private ShapeWriter shapeWriter;
    private NamespaceManager nsManager;
    private SQLTableNamerImpl sqlNamer;
    private SQLTableShapeGenerator generator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        SQLFileLoader loader = new SQLFileLoader();
        try {
            loader.load(this.sourceDir);
            SQLSchemaManager schemaManager = loader.getSchemaManager();
            this.sqlNamer = new SQLTableNamerImpl(this.baseIRI, this.aliasNamespace);
            this.generator = new SQLTableShapeGenerator((SQLNamer)this.sqlNamer);
            this.shapeWriter = new ShapeWriter();
            this.nsManager = new MemoryNamespaceManager();
            this.nsManager.add("alias", this.aliasNamespace);
            this.nsManager.add("sh", "http://www.w3.org/ns/shacl#");
            this.nsManager.add("xsd", "http://www.w3.org/2001/XMLSchema#");
            this.nsManager.add("konig", "http://www.konig.io/ns/core/");
            this.addSchemaNamespaces(schemaManager);
            this.addCustomNamespaces();
            this.addRdfIdentifiers();
            for (SQLSchema schema : schemaManager.listSchemas()) {
                this.processSchema(schema);
            }
        }
        catch (IOException | RDFHandlerException e) {
            throw new MojoExecutionException("Failed to load SQL files", (Exception)e);
        }
    }

    private void addCustomNamespaces() throws MojoExecutionException {
        for (Namespace ns : this.namespaces) {
            String prefix = ns.getPrefix();
            String iri = ns.getIri();
            if (prefix == null) {
                throw new MojoExecutionException("Namepace must have a 'prefix' property");
            }
            if (iri == null) {
                throw new MojoExecutionException("Namespace must have an 'iri' property");
            }
            this.nsManager.add(prefix, iri);
        }
    }

    private void addRdfIdentifiers() throws MojoExecutionException {
        for (Schema s : this.schemas) {
            String schemaName = s.getName();
            String schemaIRI = s.getIri();
            if (schemaName == null) {
                throw new MojoExecutionException("Schema element is missing a 'name' property");
            }
            if (schemaIRI != null) {
                this.sqlNamer.put(schemaName, this.uri(schemaIRI));
            }
            for (Table t : s.getTables()) {
                String tableName = t.getName();
                if (tableName == null) {
                    throw new MojoExecutionException("Table element is missing a 'name' property");
                }
                String tableFullName = schemaName + "." + tableName;
                String tableIRI = t.getIri();
                if (tableIRI != null) {
                    this.sqlNamer.put(tableFullName, this.uri(tableIRI));
                }
                for (Column c : t.getColumns()) {
                    String columnName = c.getName();
                    if (columnName == null) {
                        throw new MojoExecutionException("Column element is missing a 'name' property");
                    }
                    String columnIRI = c.getIri();
                    if (columnIRI == null) continue;
                    String columnFullName = tableFullName + "." + columnName;
                    this.sqlNamer.put(columnFullName, this.uri(columnIRI));
                }
            }
        }
    }

    private URI uri(String value) {
        return new URIImpl(value);
    }

    private void addSchemaNamespaces(SQLSchemaManager schemaManager) {
        for (SQLSchema schema : schemaManager.listSchemas()) {
            String schemaName = schema.getSchemaName();
            URI schemaId = this.sqlNamer.schemaId(schema);
            this.nsManager.add(schemaName, schemaId.stringValue());
        }
    }

    private void processSchema(SQLSchema schema) throws RDFHandlerException, IOException, MojoExecutionException {
        for (SQLTableSchema table : schema.listTables()) {
            this.processTable(table);
        }
    }

    private void processTable(SQLTableSchema table) throws RDFHandlerException, IOException, MojoExecutionException {
        File file = this.shapeFile(table);
        Shape shape = this.generator.toShape(table);
        this.processElements(shape, table);
        this.shapeWriter.writeTurtle(this.nsManager, shape, file);
    }

    private void processElements(Shape shape, SQLTableSchema table) throws MojoExecutionException {
        Schema schema = this.getSchemaByName(table.getSchema().getSchemaName());
        if (schema != null) {
            String schemaName = schema.getName();
            String tableName = table.getTableName();
            Table t = schema.getTableByName(tableName);
            if (t != null) {
                String targetClass = t.getTargetClass();
                if (targetClass != null) {
                    shape.setTargetClass(this.expand(targetClass));
                }
                for (Column c : t.getColumns()) {
                    String columnName = c.getName();
                    URI predicate = this.sqlNamer.rdfPredicate(schemaName, tableName, columnName);
                    PropertyConstraint p = shape.getPropertyConstraint(predicate);
                    if (p == null) {
                        throw new MojoExecutionException("Column not found: " + schemaName + "." + tableName + "." + columnName);
                    }
                    p.setEquivalentPath(c.getEquivalentPath());
                }
            }
        }
    }

    private URI expand(String value) {
        return RdfUtil.expand((NamespaceManager)this.nsManager, (String)value);
    }

    private Schema getSchemaByName(String name) {
        for (Schema s : this.schemas) {
            if (!name.equals(s.getName())) continue;
            return s;
        }
        return null;
    }

    private File shapeFile(SQLTableSchema table) {
        StringBuilder builder = new StringBuilder();
        builder.append(table.getSchema().getSchemaName());
        builder.append('_');
        builder.append(table.getTableName());
        return new File(this.outDir, builder.toString());
    }
}

