/*
 * Decompiled with CFR 0.152.
 */
package akka.monitor.instrumentation;

import akka.monitor.instrumentation.ActorMonitor;
import akka.monitor.instrumentation.ActorMonitors$;
import akka.monitor.instrumentation.EnvelopeContext;
import akka.monitor.instrumentation.EnvelopeContext$;
import io.kontainers.micrometer.akka.ActorGroupMetrics$;
import io.kontainers.micrometer.akka.ActorMetrics;
import io.kontainers.micrometer.akka.ActorSystemMetrics$;
import io.kontainers.micrometer.akka.Entity;
import io.kontainers.micrometer.akka.RouterMetrics;
import io.kontainers.micrometer.akka.TimerWrapper;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Uu!B\u0014)\u0011\u0003yc!B\u0019)\u0011\u0003\u0011\u0004\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001f\t\u000f\u0019\u000b!\u0019!C\u0001\u000f\"11*\u0001Q\u0001\n!3AaT\u0001\u0001!\"IQk\u0002BC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003g9!\u0011!Q\u0001\nYC\u0001\"Y\u0004\u0003\u0002\u0003\u0006IA\u0019\u0005\u000b\u0003k9!\u0011!Q\u0001\n\u0005]\u0002\u0002C7\b\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011]<!\u0011!Q\u0001\naDa!O\u0004\u0005\u0002\u0005\r\u0003bBA\u0001\u000f\u0011\u0005\u00131\u0001\u0005\b\u0003#:A\u0011AA*\u0011\u001d\tyb\u0002C!\u0003[2a!!\u001d\u0002\u0001\u0005M\u0004\"C+\u0013\u0005\u000b\u0007I\u0011AA\u0019\u0011%\t\u0019D\u0005B\u0001B\u0003%a\u000b\u0003\u0005b%\t\u0005\t\u0015!\u0003c\u0011)\t)H\u0005B\u0001B\u0003%\u0011q\u000f\u0005\t[J\u0011\t\u0011)A\u0005]\"AqO\u0005B\u0001B\u0003%\u0001\u0010\u0003\u0004:%\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0003\u0011B\u0011IA\u0002\u0011\u001d\t\tF\u0005C\u0001\u0003\u0017Cq!a\b\u0013\t\u0003\n\tJB\u0003T\u0003\u0005\u0005A\u000b\u0003\u0005V;\t\u0005\t\u0015!\u0003W\u0011!\tWD!A!\u0002\u0013\u0011\u0007\u0002C7\u001e\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011]l\"\u0011!Q\u0001\naDQ!O\u000f\u0005\u0002mDq!!\u0001\u001e\t\u0003\t\u0019\u0001C\u0004\u0002\fu!\t\"!\u0004\t\u000f\u0005}Q\u0004\"\u0001\u0002\"!9\u0011QF\u000f\u0005\u0002\u0005=\u0012!D!di>\u0014Xj\u001c8ji>\u00148O\u0003\u0002*U\u0005y\u0011N\\:ueVlWM\u001c;bi&|gN\u0003\u0002,Y\u00059Qn\u001c8ji>\u0014(\"A\u0017\u0002\t\u0005\\7.Y\u0002\u0001!\t\u0001\u0014!D\u0001)\u00055\t5\r^8s\u001b>t\u0017\u000e^8sgN\u0011\u0011a\r\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0013A\u00027pO\u001e,'/F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0003tY\u001a$$NC\u0001C\u0003\ry'oZ\u0005\u0003\t~\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0017\u0007>tG/\u001a=u!J|\u0007/Y4bi&|gn\u00148msV\t\u0001JE\u0002Jg13AA\u0013\u0004\u0001\u0011\naAH]3gS:,W.\u001a8u}\u000592i\u001c8uKb$\bK]8qC\u001e\fG/[8o\u001f:d\u0017\u0010\t\t\u0003a5K!A\u0014\u0015\u0003\u0019\u0005\u001bGo\u001c:N_:LGo\u001c:\u0003\u0019Q\u0013\u0018mY6fI\u0006\u001bGo\u001c:\u0014\u0005\u001d\t\u0006C\u0001*\u001e\u001b\u0005\t!!G$s_V\u0004X*\u001a;sS\u000e\u001cHK]1dW&tw-Q2u_J\u001c2!H\u001aM\u0003\u0019)g\u000e^5usB\u0011qkX\u0007\u00021*\u0011Q&\u0017\u0006\u00035n\u000b!\"\\5de>lW\r^3s\u0015\taV,\u0001\u0006l_:$\u0018-\u001b8feNT\u0011AX\u0001\u0003S>L!\u0001\u0019-\u0003\r\u0015sG/\u001b;z\u0003=\t7\r^8s'f\u001cH/Z7OC6,\u0007CA2k\u001d\t!\u0007\u000e\u0005\u0002fk5\taM\u0003\u0002h]\u00051AH]8pizJ!![\u001b\u0002\rA\u0013X\rZ3g\u0013\tYGN\u0001\u0004TiJLgn\u001a\u0006\u0003SV\na\u0002\u001e:bG.LgnZ$s_V\u00048\u000fE\u0002pi\nt!\u0001\u001d:\u000f\u0005\u0015\f\u0018\"\u0001\u001c\n\u0005M,\u0014a\u00029bG.\fw-Z\u0005\u0003kZ\u0014A\u0001T5ti*\u00111/N\u0001\u0012C\u000e$xN]\"fY2\u001c%/Z1uS>t\u0007C\u0001\u001bz\u0013\tQXGA\u0004C_>dW-\u00198\u0015\u000bEcXP`@\t\u000bU\u0013\u0003\u0019\u0001,\t\u000b\u0005\u0014\u0003\u0019\u00012\t\u000b5\u0014\u0003\u0019\u00018\t\u000b]\u0014\u0003\u0019\u0001=\u0002-\r\f\u0007\u000f^;sK\u0016sg/\u001a7pa\u0016\u001cuN\u001c;fqR$\"!!\u0002\u0011\u0007A\n9!C\u0002\u0002\n!\u0012q\"\u00128wK2|\u0007/Z\"p]R,\u0007\u0010^\u0001\u0013e\u0016\u001cwN\u001d3He>,\b/T3ue&\u001c7\u000f\u0006\u0003\u0002\u0010\u0005U\u0001c\u0001\u001b\u0002\u0012%\u0019\u00111C\u001b\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003/!\u0003\u0019AA\r\u00035!\u0018.\\3J]6\u000b\u0017\u000e\u001c2pqB\u0019A'a\u0007\n\u0007\u0005uQG\u0001\u0003M_:<\u0017A\u00049s_\u000e,7o\u001d$bS2,(/\u001a\u000b\u0005\u0003\u001f\t\u0019\u0003C\u0004\u0002&\u0015\u0002\r!a\n\u0002\u000f\u0019\f\u0017\u000e\\;sKB\u0019q.!\u000b\n\u0007\u0005-bOA\u0005UQJ|w/\u00192mK\u000691\r\\3b]V\u0004HCAA\b+\u00051\u0016aB3oi&$\u0018\u0010I\u0001\rC\u000e$xN]'fiJL7m\u001d\t\u0006i\u0005e\u0012QH\u0005\u0004\u0003w)$AB(qi&|g\u000eE\u0002X\u0003\u007fI1!!\u0011Y\u00051\t5\r^8s\u001b\u0016$(/[2t)1\t)%a\u0012\u0002J\u0005-\u0013QJA(!\t\u0011v\u0001C\u0003V\u001d\u0001\u0007a\u000bC\u0003b\u001d\u0001\u0007!\rC\u0004\u000269\u0001\r!a\u000e\t\u000b5t\u0001\u0019\u00018\t\u000b]t\u0001\u0019\u0001=\u0002\u001dA\u0014xnY3tg6+7o]1hKR)1'!\u0016\u0002j!9\u0011q\u000b\tA\u0002\u0005e\u0013a\u00019kaB!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001\u00027b]\u001eT1!a\u0019B\u0003\u001d\t7\u000f]3di*LA!a\u001a\u0002^\t\u0019\u0002K]8dK\u0016$\u0017N\\4K_&t\u0007k\\5oi\"9\u00111\u000e\tA\u0002\u0005\u0015\u0011aD3om\u0016dw\u000e]3D_:$X\r\u001f;\u0015\t\u0005=\u0011q\u000e\u0005\b\u0003K\t\u0002\u0019AA\u0014\u00055!&/Y2lK\u0012\u0014v.\u001e;fKN\u0011!#U\u0001\u000ee>,H/\u001a:NKR\u0014\u0018nY:\u0011\u0007]\u000bI(C\u0002\u0002|a\u0013QBU8vi\u0016\u0014X*\u001a;sS\u000e\u001cH\u0003DA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u0005C\u0001*\u0013\u0011\u0015)\u0016\u00041\u0001W\u0011\u0015\t\u0017\u00041\u0001c\u0011\u001d\t)(\u0007a\u0001\u0003oBQ!\\\rA\u00029DQa^\rA\u0002a$RaMAG\u0003\u001fCq!a\u0016\u001c\u0001\u0004\tI\u0006C\u0004\u0002lm\u0001\r!!\u0002\u0015\t\u0005=\u00111\u0013\u0005\b\u0003Ka\u0002\u0019AA\u0014\u0001")
public final class ActorMonitors {
    public static ActorMonitor ContextPropagationOnly() {
        return ActorMonitors$.MODULE$.ContextPropagationOnly();
    }

    public static Logger logger() {
        return ActorMonitors$.MODULE$.logger();
    }

    public static abstract class GroupMetricsTrackingActor
    implements ActorMonitor {
        private final String actorSystemName;
        private final List<String> trackingGroups;
        private final boolean actorCellCreation;

        @Override
        public EnvelopeContext captureEnvelopeContext() {
            this.trackingGroups.foreach((Function1 & Serializable)group -> {
                GroupMetricsTrackingActor.$anonfun$captureEnvelopeContext$2(group);
                return BoxedUnit.UNIT;
            });
            return EnvelopeContext$.MODULE$.apply();
        }

        public void recordGroupMetrics(long timeInMailbox) {
            this.trackingGroups.foreach((Function1 & Serializable)group -> {
                GroupMetricsTrackingActor.$anonfun$recordGroupMetrics$1(timeInMailbox, group);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public void processFailure(Throwable failure) {
            this.trackingGroups.foreach((Function1 & Serializable)group -> {
                GroupMetricsTrackingActor.$anonfun$processFailure$2(group);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public void cleanup() {
            block0: {
                if (!this.actorCellCreation) break block0;
                ActorSystemMetrics$.MODULE$.actorCount(this.actorSystemName).decrement();
                this.trackingGroups.foreach((Function1 & Serializable)group -> {
                    GroupMetricsTrackingActor.$anonfun$cleanup$1(group);
                    return BoxedUnit.UNIT;
                });
            }
        }

        public static final /* synthetic */ void $anonfun$new$1(String group) {
            ActorGroupMetrics$.MODULE$.actorCount(group).increment();
        }

        public static final /* synthetic */ void $anonfun$captureEnvelopeContext$2(String group) {
            ActorGroupMetrics$.MODULE$.mailboxSize(group).increment();
            ActorGroupMetrics$.MODULE$.messages(group).increment();
        }

        public static final /* synthetic */ void $anonfun$recordGroupMetrics$1(long timeInMailbox$2, String group) {
            ActorGroupMetrics$.MODULE$.timeInMailbox(group).timer().record(timeInMailbox$2, TimeUnit.NANOSECONDS);
            ActorGroupMetrics$.MODULE$.mailboxSize(group).decrement();
        }

        public static final /* synthetic */ void $anonfun$processFailure$2(String group) {
            ActorGroupMetrics$.MODULE$.errors(group).increment();
        }

        public static final /* synthetic */ void $anonfun$cleanup$1(String group) {
            ActorGroupMetrics$.MODULE$.actorCount(group).decrement();
        }

        public GroupMetricsTrackingActor(Entity entity, String actorSystemName, List<String> trackingGroups, boolean actorCellCreation) {
            block0: {
                this.actorSystemName = actorSystemName;
                this.trackingGroups = trackingGroups;
                this.actorCellCreation = actorCellCreation;
                if (!actorCellCreation) break block0;
                ActorSystemMetrics$.MODULE$.actorCount(actorSystemName).increment();
                trackingGroups.foreach((Function1 & Serializable)group -> {
                    GroupMetricsTrackingActor.$anonfun$new$1(group);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public static class TrackedActor
    extends GroupMetricsTrackingActor {
        private final Entity entity;
        private final Option<ActorMetrics> actorMetrics;
        private final List<String> trackingGroups;

        public Entity entity() {
            return this.entity;
        }

        @Override
        public EnvelopeContext captureEnvelopeContext() {
            this.actorMetrics.foreach((Function1 & Serializable)am -> {
                TrackedActor.$anonfun$captureEnvelopeContext$1(am);
                return BoxedUnit.UNIT;
            });
            return super.captureEnvelopeContext();
        }

        @Override
        public Object processMessage(ProceedingJoinPoint pjp, EnvelopeContext envelopeContext) {
            Object object;
            long timeInMailbox = System.nanoTime() - envelopeContext.nanoTime();
            Option actorProcessingTimers = this.actorMetrics.map((Function1 & Serializable)am -> am.processingTime().startTimer());
            List actorGroupProcessingTimers = this.trackingGroups.map((Function1 & Serializable)group -> ActorGroupMetrics$.MODULE$.processingTime((String)group).startTimer());
            try {
                object = pjp.proceed();
            }
            finally {
                actorProcessingTimers.foreach((Function1 & Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
                actorGroupProcessingTimers.foreach((Function1 & Serializable)x$2 -> {
                    x$2.close();
                    return BoxedUnit.UNIT;
                });
                this.actorMetrics.foreach((Function1 & Serializable)am -> {
                    TrackedActor.$anonfun$processMessage$5(timeInMailbox, am);
                    return BoxedUnit.UNIT;
                });
                this.recordGroupMetrics(timeInMailbox);
            }
            return object;
        }

        @Override
        public void processFailure(Throwable failure) {
            this.actorMetrics.foreach((Function1 & Serializable)am -> {
                TrackedActor.$anonfun$processFailure$1(am);
                return BoxedUnit.UNIT;
            });
            super.processFailure(failure);
        }

        public static final /* synthetic */ void $anonfun$captureEnvelopeContext$1(ActorMetrics am) {
            am.mailboxSize().increment();
            am.messages().increment();
        }

        public static final /* synthetic */ void $anonfun$processMessage$5(long timeInMailbox$1, ActorMetrics am) {
            am.timeInMailbox().timer().record(timeInMailbox$1, TimeUnit.NANOSECONDS);
            am.mailboxSize().decrement();
        }

        public static final /* synthetic */ void $anonfun$processFailure$1(ActorMetrics am) {
            am.errors().increment();
        }

        public TrackedActor(Entity entity, String actorSystemName, Option<ActorMetrics> actorMetrics, List<String> trackingGroups, boolean actorCellCreation) {
            block0: {
                this.entity = entity;
                this.actorMetrics = actorMetrics;
                this.trackingGroups = trackingGroups;
                super(entity, actorSystemName, trackingGroups, actorCellCreation);
                if (!ActorMonitors$.MODULE$.logger().isDebugEnabled()) break block0;
                ActorMonitors$.MODULE$.logger().debug(new StringBuilder(31).append("tracking ").append(entity.name()).append(" actor: ").append(actorMetrics.isDefined()).append(" actor-group: ").append(trackingGroups).toString());
            }
        }
    }

    public static class TrackedRoutee
    extends GroupMetricsTrackingActor {
        private final Entity entity;
        private final RouterMetrics routerMetrics;
        private final List<String> trackingGroups;

        public Entity entity() {
            return this.entity;
        }

        @Override
        public EnvelopeContext captureEnvelopeContext() {
            this.routerMetrics.messages().increment();
            return super.captureEnvelopeContext();
        }

        @Override
        public Object processMessage(ProceedingJoinPoint pjp, EnvelopeContext envelopeContext) {
            Object object;
            long timeInMailbox = System.nanoTime() - envelopeContext.nanoTime();
            TimerWrapper.TimeObservation processingTimer = this.routerMetrics.processingTime().startTimer();
            List actorGroupProcessingTimers = this.trackingGroups.map((Function1 & Serializable)group -> ActorGroupMetrics$.MODULE$.processingTime((String)group).startTimer());
            try {
                object = pjp.proceed();
            }
            finally {
                processingTimer.close();
                actorGroupProcessingTimers.foreach((Function1 & Serializable)x$3 -> {
                    x$3.close();
                    return BoxedUnit.UNIT;
                });
                this.routerMetrics.timeInMailbox().timer().record(timeInMailbox, TimeUnit.NANOSECONDS);
                this.recordGroupMetrics(timeInMailbox);
            }
            return object;
        }

        @Override
        public void processFailure(Throwable failure) {
            this.routerMetrics.errors().increment();
            super.processFailure(failure);
        }

        public TrackedRoutee(Entity entity, String actorSystemName, RouterMetrics routerMetrics, List<String> trackingGroups, boolean actorCellCreation) {
            block0: {
                this.entity = entity;
                this.routerMetrics = routerMetrics;
                this.trackingGroups = trackingGroups;
                super(entity, actorSystemName, trackingGroups, actorCellCreation);
                if (!ActorMonitors$.MODULE$.logger().isDebugEnabled()) break block0;
                ActorMonitors$.MODULE$.logger().debug(new StringBuilder(56).append("tracking ").append(entity.name()).append(" router: true actor-group: ").append(trackingGroups).append(" actorCellCreation: ").append(actorCellCreation).toString());
            }
        }
    }
}

