/*
 * Decompiled with CFR 0.152.
 */
package io.kontainers.micrometer.akka;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import io.kontainers.micrometer.akka.MetricsConfig$Syntax$;
import io.kontainers.micrometer.akka.impl.EntityFilter;
import io.kontainers.micrometer.akka.impl.GlobPathFilter;
import io.kontainers.micrometer.akka.impl.PathFilter;
import io.kontainers.micrometer.akka.impl.RegexPathFilter;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class MetricsConfig$ {
    public static final MetricsConfig$ MODULE$;
    private static boolean matchEvents;
    private static boolean histogramBucketsEnabled;
    private static final String BaseConfig;
    private static final String Dispatcher;
    private static final String Router;
    private static final String Actor;
    private static final String ActorGroups;
    private static final Config defaultConfig;
    private static final Config metricFiltersConfig;
    private static final Map<String, EntityFilter> filters;
    private static final Map<? extends String, EntityFilter> groupFilters;
    private static volatile byte bitmap$0;

    static {
        Map<String, EntityFilter> map;
        MODULE$ = new MetricsConfig$();
        BaseConfig = "micrometer.akka";
        Dispatcher = "akka-dispatcher";
        Router = "akka-router";
        Actor = "akka-actor";
        ActorGroups = "akka-actor-groups";
        defaultConfig = ConfigFactory.load((ClassLoader)MODULE$.getClass().getClassLoader(), (ConfigParseOptions)ConfigParseOptions.defaults(), (ConfigResolveOptions)ConfigResolveOptions.defaults().setAllowUnresolved(true));
        metricFiltersConfig = MODULE$.defaultConfig().getConfig(new StringBuilder(15).append(MODULE$.BaseConfig()).append(".metric.filters").toString());
        filters = MODULE$.createFilters(MODULE$.metricFiltersConfig(), (Set<String>)((Set)MetricsConfig$Syntax$.MODULE$.firstLevelKeys$extension(MODULE$.Syntax(MODULE$.metricFiltersConfig())).filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetricsConfig$.$anonfun$filters$1(x$2)))));
        if (MODULE$.metricFiltersConfig().hasPath(MODULE$.ActorGroups())) {
            Config cfg = MODULE$.metricFiltersConfig().getConfig(MODULE$.ActorGroups());
            map = MODULE$.createFilters(cfg, MetricsConfig$Syntax$.MODULE$.firstLevelKeys$extension(MODULE$.Syntax(cfg)));
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        groupFilters = map;
    }

    private String BaseConfig() {
        return BaseConfig;
    }

    public String Dispatcher() {
        return Dispatcher;
    }

    public String Router() {
        return Router;
    }

    public String Actor() {
        return Actor;
    }

    public String ActorGroups() {
        return ActorGroups;
    }

    private Config defaultConfig() {
        return defaultConfig;
    }

    private Config metricFiltersConfig() {
        return metricFiltersConfig;
    }

    private boolean matchEvents$lzycompute() {
        MetricsConfig$ metricsConfig$ = this;
        synchronized (metricsConfig$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                matchEvents = this.defaultConfig().getBoolean(new StringBuilder(13).append(this.BaseConfig()).append(".match.events").toString());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return matchEvents;
    }

    public boolean matchEvents() {
        return (byte)(bitmap$0 & 1) == 0 ? this.matchEvents$lzycompute() : matchEvents;
    }

    private boolean histogramBucketsEnabled$lzycompute() {
        MetricsConfig$ metricsConfig$ = this;
        synchronized (metricsConfig$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                histogramBucketsEnabled = this.defaultConfig().getBoolean(new StringBuilder(26).append(this.BaseConfig()).append(".histogram.buckets.enabled").toString());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return histogramBucketsEnabled;
    }

    public boolean histogramBucketsEnabled() {
        return (byte)(bitmap$0 & 2) == 0 ? this.histogramBucketsEnabled$lzycompute() : histogramBucketsEnabled;
    }

    public Config Syntax(Config config) {
        return config;
    }

    private Map<String, EntityFilter> filters() {
        return filters;
    }

    private Map<? extends String, EntityFilter> groupFilters() {
        return groupFilters;
    }

    private Map<String, EntityFilter> createFilters(Config cfg, Set<String> categories) {
        return ((IterableOnceOps)categories.map((Function1 & Serializable)category -> {
            boolean asRegex = cfg.hasPath(new StringBuilder(8).append((String)category).append(".asRegex").toString()) ? cfg.getBoolean(new StringBuilder(8).append((String)category).append(".asRegex").toString()) : false;
            List includes = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(cfg.getStringList(new StringBuilder(9).append((String)category).append(".includes").toString())).asScala()).map((Function1 & Serializable)inc -> asRegex ? new RegexPathFilter((String)inc) : new GlobPathFilter((String)inc))).toList();
            List excludes = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(cfg.getStringList(new StringBuilder(9).append((String)category).append(".excludes").toString())).asScala()).map((Function1 & Serializable)exc -> asRegex ? new RegexPathFilter((String)exc) : new GlobPathFilter((String)exc))).toList();
            return new Tuple2(category, (Object)new EntityFilter((List<PathFilter>)includes, (List<PathFilter>)excludes));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean shouldTrack(String category, String entityName) {
        boolean bl;
        Option option = this.filters().get((Object)category);
        if (option instanceof Some) {
            Some some = (Some)option;
            EntityFilter filter = (EntityFilter)some.value();
            bl = filter.accept(entityName);
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public List<String> actorShouldBeTrackedUnderGroups(String entityName) {
        Iterable iterable = (Iterable)this.groupFilters().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsConfig$.$anonfun$actorShouldBeTrackedUnderGroups$1(check$ifrefutable$1))).withFilter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsConfig$.$anonfun$actorShouldBeTrackedUnderGroups$2(entityName, x$3))).map((Function1 & Serializable)x$4 -> {
            String groupName;
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String string = groupName = (String)tuple2._1();
            return string;
        });
        return iterable.toList();
    }

    public Set<String> groupNames() {
        return this.groupFilters().keys().toSet();
    }

    public static final /* synthetic */ boolean $anonfun$filters$1(String x$2) {
        String string = x$2;
        String string2 = MODULE$.ActorGroups();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$actorShouldBeTrackedUnderGroups$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$actorShouldBeTrackedUnderGroups$2(String entityName$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        EntityFilter filter = (EntityFilter)tuple2._2();
        boolean bl = filter.accept(entityName$1);
        return bl;
    }

    private MetricsConfig$() {
    }
}

