/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.embedded.kafka;

import io.github.embeddedkafka.EmbeddedKafka;
import io.github.embeddedkafka.EmbeddedKafkaConfig;
import io.kotest.common.SoftDeprecated;
import io.kotest.core.listeners.TestListener;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import io.kotest.extensions.embedded.kafka.EmbeddedKafkaListener;
import java.util.Collection;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import scala.Predef;
import scala.collection.immutable.Map;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J-\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0019\b\u0002\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b\u001fJ5\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010 \u001a\u00020\f2\u0019\b\u0002\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b\u001fJ-\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\"2\u0019\b\u0002\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b\u001fJ-\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001a2\u0019\b\u0002\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b\u001fJ5\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010 \u001a\u00020\f2\u0019\b\u0002\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b\u001fJ-\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\"2\u0019\b\u0002\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00140\u001d\u00a2\u0006\u0002\b\u001fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lio/kotest/extensions/embedded/kafka/EmbeddedKafkaListener;", "Lio/kotest/core/listeners/TestListener;", "port", "", "(I)V", "kafkaPort", "zookeeperPort", "(II)V", "config", "Lio/github/embeddedkafka/EmbeddedKafkaConfig;", "(Lio/github/embeddedkafka/EmbeddedKafkaConfig;)V", "bootstrapServer", "", "getBootstrapServer", "()Ljava/lang/String;", "host", "getHost", "getPort", "()I", "afterSpec", "", "spec", "Lio/kotest/core/spec/Spec;", "(Lio/kotest/core/spec/Spec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "beforeSpec", "bytesBytesConsumer", "Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "Lorg/apache/kafka/common/utils/Bytes;", "configure", "Lkotlin/Function1;", "Ljava/util/Properties;", "Lkotlin/ExtensionFunctionType;", "topic", "bytesBytesProducer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "stringStringConsumer", "stringStringProducer", "kotest-extensions-embedded-kafka"})
public final class EmbeddedKafkaListener
implements TestListener {
    @NotNull
    private final EmbeddedKafkaConfig config;
    private final int port;
    @NotNull
    private final String host;
    @NotNull
    private final String bootstrapServer;

    public EmbeddedKafkaListener(@NotNull EmbeddedKafkaConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.port = this.config.kafkaPort();
        this.host = "127.0.0.1";
        this.bootstrapServer = this.host + ':' + this.port;
    }

    public EmbeddedKafkaListener(int port) {
        EmbeddedKafkaConfig embeddedKafkaConfig = EmbeddedKafkaConfig.apply((int)port, (int)EmbeddedKafkaConfig.defaultZookeeperPort(), (Map)Predef.Map().empty(), (Map)Predef.Map().empty(), (Map)Predef.Map().empty());
        Intrinsics.checkNotNullExpressionValue((Object)embeddedKafkaConfig, (String)"apply(\n         port,\n  \u2026ef.Map().empty(),\n      )");
        this(embeddedKafkaConfig);
    }

    public EmbeddedKafkaListener(int kafkaPort, int zookeeperPort) {
        EmbeddedKafkaConfig embeddedKafkaConfig = EmbeddedKafkaConfig.apply((int)kafkaPort, (int)zookeeperPort, (Map)Predef.Map().empty(), (Map)Predef.Map().empty(), (Map)Predef.Map().empty());
        Intrinsics.checkNotNullExpressionValue((Object)embeddedKafkaConfig, (String)"apply(\n         kafkaPor\u2026ef.Map().empty(),\n      )");
        this(embeddedKafkaConfig);
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final String getBootstrapServer() {
        return this.bootstrapServer;
    }

    @Nullable
    public Object beforeSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
        EmbeddedKafka.start((EmbeddedKafkaConfig)this.config);
        while (!EmbeddedKafka.isRunning()) {
            Thread.sleep(100L);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object afterSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
        EmbeddedKafka.stop();
        while (EmbeddedKafka.isRunning()) {
            Thread.sleep(100L);
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final KafkaConsumer<String, String> stringStringConsumer(@NotNull Function1<? super Properties, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        Properties props = new Properties();
        ((java.util.Map)props).put("bootstrap.servers", this.host + ':' + this.port);
        ((java.util.Map)props).put("group.id", "test_consumer_group_" + System.currentTimeMillis());
        ((java.util.Map)props).put("auto.offset.reset", "earliest");
        configure.invoke((Object)props);
        return new KafkaConsumer(props, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
    }

    public static /* synthetic */ KafkaConsumer stringStringConsumer$default(EmbeddedKafkaListener embeddedKafkaListener, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = stringStringConsumer.1.INSTANCE;
        }
        return embeddedKafkaListener.stringStringConsumer((Function1<? super Properties, Unit>)function1);
    }

    @NotNull
    public final KafkaConsumer<String, String> stringStringConsumer(@NotNull String topic, @NotNull Function1<? super Properties, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        KafkaConsumer<String, String> consumer = this.stringStringConsumer(configure);
        consumer.subscribe((Collection)CollectionsKt.listOf((Object)topic));
        return consumer;
    }

    public static /* synthetic */ KafkaConsumer stringStringConsumer$default(EmbeddedKafkaListener embeddedKafkaListener, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = stringStringConsumer.2.INSTANCE;
        }
        return embeddedKafkaListener.stringStringConsumer(string, (Function1<? super Properties, Unit>)function1);
    }

    @NotNull
    public final KafkaConsumer<Bytes, Bytes> bytesBytesConsumer(@NotNull Function1<? super Properties, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        Properties props = new Properties();
        ((java.util.Map)props).put("bootstrap.servers", this.host + ':' + this.port);
        ((java.util.Map)props).put("group.id", "test_consumer_group_" + System.currentTimeMillis());
        ((java.util.Map)props).put("auto.offset.reset", "earliest");
        configure.invoke((Object)props);
        return new KafkaConsumer(props, (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer());
    }

    public static /* synthetic */ KafkaConsumer bytesBytesConsumer$default(EmbeddedKafkaListener embeddedKafkaListener, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = bytesBytesConsumer.1.INSTANCE;
        }
        return embeddedKafkaListener.bytesBytesConsumer((Function1<? super Properties, Unit>)function1);
    }

    @NotNull
    public final KafkaConsumer<Bytes, Bytes> bytesBytesConsumer(@NotNull String topic, @NotNull Function1<? super Properties, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        KafkaConsumer<Bytes, Bytes> consumer = this.bytesBytesConsumer(configure);
        consumer.subscribe((Collection)CollectionsKt.listOf((Object)topic));
        return consumer;
    }

    public static /* synthetic */ KafkaConsumer bytesBytesConsumer$default(EmbeddedKafkaListener embeddedKafkaListener, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = bytesBytesConsumer.2.INSTANCE;
        }
        return embeddedKafkaListener.bytesBytesConsumer(string, (Function1<? super Properties, Unit>)function1);
    }

    @NotNull
    public final KafkaProducer<Bytes, Bytes> bytesBytesProducer(@NotNull Function1<? super Properties, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        Properties props = new Properties();
        ((java.util.Map)props).put("bootstrap.servers", this.host + ':' + this.port);
        configure.invoke((Object)props);
        return new KafkaProducer(props, (Serializer)new BytesSerializer(), (Serializer)new BytesSerializer());
    }

    public static /* synthetic */ KafkaProducer bytesBytesProducer$default(EmbeddedKafkaListener embeddedKafkaListener, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = bytesBytesProducer.1.INSTANCE;
        }
        return embeddedKafkaListener.bytesBytesProducer((Function1<? super Properties, Unit>)function1);
    }

    @NotNull
    public final KafkaProducer<String, String> stringStringProducer(@NotNull Function1<? super Properties, Unit> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        Properties props = new Properties();
        ((java.util.Map)props).put("bootstrap.servers", this.host + ':' + this.port);
        configure.invoke((Object)props);
        return new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
    }

    public static /* synthetic */ KafkaProducer stringStringProducer$default(EmbeddedKafkaListener embeddedKafkaListener, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = stringStringProducer.1.INSTANCE;
        }
        return embeddedKafkaListener.stringStringProducer((Function1<? super Properties, Unit>)function1);
    }

    @NotNull
    public String getName() {
        return TestListener.DefaultImpls.getName((TestListener)this);
    }

    @Nullable
    public Object afterAny(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterAny((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object afterContainer(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterContainer((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object afterEach(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterEach((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object afterInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterInvocation((TestListener)this, (TestCase)testCase, (int)iteration, $completion);
    }

    @SoftDeprecated(message="Use afterAny")
    @Nullable
    public Object afterTest(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.afterTest((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
    }

    @Nullable
    public Object beforeAny(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeAny((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object beforeContainer(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeContainer((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object beforeEach(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeEach((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object beforeInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeInvocation((TestListener)this, (TestCase)testCase, (int)iteration, $completion);
    }

    @SoftDeprecated(message="Use beforeAny")
    @Nullable
    public Object beforeTest(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.beforeTest((TestListener)this, (TestCase)testCase, $completion);
    }

    @Nullable
    public Object finalizeSpec(@NotNull KClass<? extends Spec> kclass, @NotNull java.util.Map<TestCase, ? extends TestResult> results, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.finalizeSpec((TestListener)this, kclass, results, $completion);
    }

    @Nullable
    public Object prepareSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Continuation<? super Unit> $completion) {
        return TestListener.DefaultImpls.prepareSpec((TestListener)this, kclass, $completion);
    }
}

