/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.spring;

import io.kotest.core.annotation.AutoScan;
import io.kotest.core.extensions.ConstructorExtension;
import io.kotest.core.spec.Spec;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContextManager;

@AutoScan
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/kotest/extensions/spring/SpringAutowireConstructorExtension;", "Lio/kotest/core/extensions/ConstructorExtension;", "()V", "instantiate", "Lio/kotest/core/spec/Spec;", "T", "clazz", "Lkotlin/reflect/KClass;", "kotest-extensions-spring"})
public final class SpringAutowireConstructorExtension
implements ConstructorExtension {
    @NotNull
    public static final SpringAutowireConstructorExtension INSTANCE = new SpringAutowireConstructorExtension();

    private SpringAutowireConstructorExtension() {
    }

    @Nullable
    public <T extends Spec> Spec instantiate(@NotNull KClass<T> clazz) {
        Spec spec;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        KFunction constructor = KClasses.getPrimaryConstructor(clazz);
        if (constructor == null || constructor.getParameters().isEmpty()) {
            spec = null;
        } else {
            TestContextManager manager = new TestContextManager(JvmClassMappingKt.getJavaClass(clazz));
            ApplicationContext context = manager.getTestContext().getApplicationContext();
            Object object = context.getAutowireCapableBeanFactory().autowire(JvmClassMappingKt.getJavaClass(clazz), 3, true);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.kotest.core.spec.Spec");
            spec = (Spec)object;
        }
        return spec;
    }
}

