/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.string;

import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.show.ShowKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherKt;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.string.MatchersKt;
import io.kotest.matchers.string.StringMatchersKt;
import io.kotest.matchers.string.UUIDVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b7\u001a\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002\u001a\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0002\u001a'\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002\u00a2\u0006\u0002\u0010\u001b\u001a\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0002\u001a\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0005\u001a\u001e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"\u001a\u0016\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010%\u001a\u00020&\u001a\u0016\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010(\u001a\u00020\"\u001a\u0016\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010*\u001a\u00020\"\u001a\u0016\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010*\u001a\u00020\"\u001a\u0016\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002\u001a\u0016\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0002\u001a\f\u0010.\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\f\u00100\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u00101\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0004\u001a\f\u00102\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a#\u00103\u001a\u00020\"*\u0004\u0018\u00010\u00022\b\b\u0002\u00104\u001a\u00020\"\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0003\u0010\u0000\u001a\f\u00105\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\f\u00106\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\f\u00107\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u001e\u00108\u001a\u00020/*\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\f\u00109\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u0010:\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010:\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0004\u001a\f\u0010;\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u0010<\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a%\u0010=\u001a\u00020/*\u0004\u0018\u00010\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002\u00a2\u0006\u0002\u0010>\u001a\f\u0010?\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u0010@\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010A\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010B\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010C\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\"H\u0086\u0004\u001a\u001c\u0010D\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"\u001a\u0014\u0010E\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020&\u001a\u0017\u0010F\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010(\u001a\u00020\"H\u0086\u0004\u001a\u0017\u0010G\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\"H\u0086\u0004\u001a\u0017\u0010H\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\"H\u0086\u0004\u001a\u0017\u0010I\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010J\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010K\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010K\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0004\u001a\f\u0010L\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\f\u0010M\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u0010N\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0004\u001a\f\u0010O\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\f\u0010P\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u001e\u0010Q\u001a\u00020/*\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010R\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u0010S\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010S\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0004\u001a\f\u0010T\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u0010U\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a%\u0010V\u001a\u00020/*\u0004\u0018\u00010\u00022\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002\u00a2\u0006\u0002\u0010>\u001a\f\u0010W\u001a\u00020/*\u0004\u0018\u00010\u0002\u001a\u0017\u0010X\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010Y\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010B\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010Z\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\"H\u0086\u0004\u001a\u001c\u0010[\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"\u001a\u0014\u0010\\\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010%\u001a\u00020&\u001a\u0017\u0010]\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010(\u001a\u00020\"H\u0086\u0004\u001a\u0017\u0010^\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\"H\u0086\u0004\u001a\u0017\u0010_\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\"H\u0086\u0004\u001a\u0017\u0010`\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010a\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010b\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010c\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010d\u001a\u00020\u0002H\u0086\u0004\u001a\u0017\u0010e\u001a\u00020/*\u0004\u0018\u00010\u00022\u0006\u0010d\u001a\u00020\u0002H\u0086\u0004\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"falsyValues", "", "", "truthyValues", "beBlank", "Lio/kotest/matchers/Matcher;", "beEmpty", "beEqualIgnoringCase", "other", "beFalsy", "beLowerCase", "beTruthy", "beUUID", "version", "Lio/kotest/matchers/string/UUIDVersion;", "considerNilValid", "", "beUpperCase", "contain", "substr", "regex", "Lkotlin/text/Regex;", "containADigit", "containIgnoringCase", "containInOrder", "substrings", "", "([Ljava/lang/String;)Lio/kotest/matchers/Matcher;", "containOnlyDigits", "containOnlyOnce", "substring", "containOnlyWhitespace", "haveLengthBetween", "min", "", "max", "haveLengthIn", "range", "Lkotlin/ranges/IntRange;", "haveLineCount", "count", "haveMaxLength", "length", "haveMinLength", "haveSameLengthAs", "include", "shouldBeBlank", "", "shouldBeEmpty", "shouldBeEqualIgnoringCase", "shouldBeFalsy", "shouldBeInteger", "radix", "shouldBeLowerCase", "shouldBeSingleLine", "shouldBeTruthy", "shouldBeUUID", "shouldBeUpperCase", "shouldContain", "shouldContainADigit", "shouldContainIgnoringCase", "shouldContainInOrder", "(Ljava/lang/String;[Ljava/lang/String;)V", "shouldContainOnlyDigits", "shouldContainOnlyOnce", "shouldEndWith", "suffix", "shouldHaveLength", "shouldHaveLengthBetween", "shouldHaveLengthIn", "shouldHaveLineCount", "shouldHaveMaxLength", "shouldHaveMinLength", "shouldHaveSameLengthAs", "shouldInclude", "shouldMatch", "shouldNotBeBlank", "shouldNotBeEmpty", "shouldNotBeEqualIgnoringCase", "shouldNotBeLowerCase", "shouldNotBeSingleLine", "shouldNotBeUUID", "shouldNotBeUpperCase", "shouldNotContain", "shouldNotContainADigit", "shouldNotContainIgnoringCase", "shouldNotContainInOrder", "shouldNotContainOnlyDigits", "shouldNotContainOnlyOnce", "shouldNotEndWith", "shouldNotHaveLength", "shouldNotHaveLengthBetween", "shouldNotHaveLengthIn", "shouldNotHaveLineCount", "shouldNotHaveMaxLength", "shouldNotHaveMinLength", "shouldNotHaveSameLengthAs", "shouldNotInclude", "shouldNotMatch", "shouldNotStartWith", "prefix", "shouldStartWith", "kotest-assertions-core"})
public final class MatchersKt {
    private static final List<String> truthyValues = CollectionsKt.listOf((Object[])new String[]{"true", "yes", "y", "1"});
    private static final List<String> falsyValues = CollectionsKt.listOf((Object[])new String[]{"false", "no", "n", "0"});

    public static final void shouldContainOnlyDigits(@Nullable String $this$shouldContainOnlyDigits) {
        ShouldKt.should((Object)$this$shouldContainOnlyDigits, MatchersKt.containOnlyDigits());
    }

    public static final void shouldNotContainOnlyDigits(@Nullable String $this$shouldNotContainOnlyDigits) {
        ShouldKt.shouldNot((Object)$this$shouldNotContainOnlyDigits, MatchersKt.containOnlyDigits());
    }

    @NotNull
    public static final Matcher<String> containOnlyDigits() {
        return MatcherKt.neverNullMatcher((Function1)containOnlyDigits.1.INSTANCE);
    }

    public static final void shouldContainADigit(@Nullable String $this$shouldContainADigit) {
        ShouldKt.should((Object)$this$shouldContainADigit, MatchersKt.containADigit());
    }

    public static final void shouldNotContainADigit(@Nullable String $this$shouldNotContainADigit) {
        ShouldKt.shouldNot((Object)$this$shouldNotContainADigit, MatchersKt.containADigit());
    }

    @NotNull
    public static final Matcher<String> containADigit() {
        return MatcherKt.neverNullMatcher((Function1)containADigit.1.INSTANCE);
    }

    public static final void shouldContainOnlyOnce(@Nullable String $this$shouldContainOnlyOnce, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldContainOnlyOnce, MatchersKt.containOnlyOnce(substr));
    }

    public static final void shouldNotContainOnlyOnce(@Nullable String $this$shouldNotContainOnlyOnce, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotContainOnlyOnce, MatchersKt.containOnlyOnce(substr));
    }

    @NotNull
    public static final Matcher<String> containOnlyOnce(@NotNull String substring) {
        Intrinsics.checkParameterIsNotNull((Object)substring, (String)"substring");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(substring){
            final /* synthetic */ String $substring;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(StringsKt.indexOf$default((CharSequence)value, (String)this.$substring, (int)0, (boolean)false, (int)6, null) >= 0 && StringsKt.indexOf$default((CharSequence)value, (String)this.$substring, (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)value, (String)this.$substring, (int)0, (boolean)false, (int)6, null), ShowKt.show((Object)value).getValue() + " should contain the substring " + ShowKt.show((Object)this.$substring).getValue() + " exactly once", ShowKt.show((Object)value).getValue() + " should not contain the substring " + ShowKt.show((Object)this.$substring).getValue() + " exactly once");
            }
            {
                this.$substring = string;
                super(1);
            }
        }));
    }

    public static final void shouldBeLowerCase(@Nullable String $this$shouldBeLowerCase) {
        ShouldKt.should((Object)$this$shouldBeLowerCase, MatchersKt.beLowerCase());
    }

    public static final void shouldNotBeLowerCase(@Nullable String $this$shouldNotBeLowerCase) {
        ShouldKt.shouldNot((Object)$this$shouldNotBeLowerCase, MatchersKt.beLowerCase());
    }

    @NotNull
    public static final Matcher<String> beLowerCase() {
        return MatcherKt.neverNullMatcher((Function1)beLowerCase.1.INSTANCE);
    }

    public static final void shouldBeUpperCase(@Nullable String $this$shouldBeUpperCase) {
        ShouldKt.should((Object)$this$shouldBeUpperCase, MatchersKt.beUpperCase());
    }

    public static final void shouldNotBeUpperCase(@Nullable String $this$shouldNotBeUpperCase) {
        ShouldKt.shouldNot((Object)$this$shouldNotBeUpperCase, MatchersKt.beUpperCase());
    }

    @NotNull
    public static final Matcher<String> beUpperCase() {
        return MatcherKt.neverNullMatcher((Function1)beUpperCase.1.INSTANCE);
    }

    public static final void shouldBeEmpty(@Nullable String $this$shouldBeEmpty) {
        ShouldKt.should((Object)$this$shouldBeEmpty, MatchersKt.beEmpty());
    }

    public static final void shouldNotBeEmpty(@Nullable String $this$shouldNotBeEmpty) {
        ShouldKt.shouldNot((Object)$this$shouldNotBeEmpty, MatchersKt.beEmpty());
    }

    @NotNull
    public static final Matcher<String> beEmpty() {
        return MatcherKt.neverNullMatcher((Function1)beEmpty.1.INSTANCE);
    }

    public static final void shouldHaveSameLengthAs(@Nullable String $this$shouldHaveSameLengthAs, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldHaveSameLengthAs, MatchersKt.haveSameLengthAs(other));
    }

    public static final void shouldNotHaveSameLengthAs(@Nullable String $this$shouldNotHaveSameLengthAs, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveSameLengthAs, MatchersKt.haveSameLengthAs(other));
    }

    @NotNull
    public static final Matcher<String> haveSameLengthAs(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(other){
            final /* synthetic */ String $other;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == this.$other.length(), ShowKt.show((Object)value).getValue() + " should have the same length as " + ShowKt.show((Object)this.$other).getValue(), ShowKt.show((Object)value).getValue() + " should not have the same length as " + ShowKt.show((Object)this.$other).getValue());
            }
            {
                this.$other = string;
                super(1);
            }
        }));
    }

    public static final void shouldBeSingleLine(@Nullable String $this$shouldBeSingleLine) {
        ShouldKt.should((Object)$this$shouldBeSingleLine, MatchersKt.haveLineCount(1));
    }

    public static final void shouldNotBeSingleLine(@Nullable String $this$shouldNotBeSingleLine) {
        ShouldKt.shouldNot((Object)$this$shouldNotBeSingleLine, MatchersKt.haveLineCount(1));
    }

    public static final void shouldHaveLineCount(@Nullable String $this$shouldHaveLineCount, int count) {
        ShouldKt.should((Object)$this$shouldHaveLineCount, MatchersKt.haveLineCount(count));
    }

    public static final void shouldNotHaveLineCount(@Nullable String $this$shouldNotHaveLineCount, int count) {
        ShouldKt.shouldNot((Object)$this$shouldNotHaveLineCount, MatchersKt.haveLineCount(count));
    }

    @NotNull
    public static final Matcher<String> haveLineCount(int count) {
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(count){
            final /* synthetic */ int $count;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                CharSequence charSequence = value;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    n = 0;
                } else {
                    CharSequence $this$count$iv = value;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    CharSequence charSequence2 = $this$count$iv;
                    for (int i = 0; i < charSequence2.length(); ++i) {
                        char element$iv;
                        char it = element$iv = charSequence2.charAt(i);
                        boolean bl2 = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                    n = count$iv + 1;
                }
                int lines = n;
                return MatcherResult.Companion.invoke(lines == this.$count, (Function0)new Function0<String>(this, value, lines){
                    final /* synthetic */ haveLineCount.1 this$0;
                    final /* synthetic */ String $value;
                    final /* synthetic */ int $lines;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should have " + this.this$0.$count + " lines but had " + this.$lines;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        this.$lines = n;
                        super(0);
                    }
                }, (Function0)new Function0<String>(this, value){
                    final /* synthetic */ haveLineCount.1 this$0;
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should not have " + this.this$0.$count + " lines";
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        super(0);
                    }
                });
            }
            {
                this.$count = n;
                super(1);
            }
        }));
    }

    public static final void shouldBeBlank(@Nullable String $this$shouldBeBlank) {
        ShouldKt.should((Object)$this$shouldBeBlank, MatchersKt.beBlank());
    }

    public static final void shouldNotBeBlank(@Nullable String $this$shouldNotBeBlank) {
        ShouldKt.shouldNot((Object)$this$shouldNotBeBlank, MatchersKt.beBlank());
    }

    @NotNull
    public static final Matcher<String> containOnlyWhitespace() {
        return MatchersKt.beBlank();
    }

    @NotNull
    public static final Matcher<String> beBlank() {
        return MatcherKt.neverNullMatcher((Function1)beBlank.1.INSTANCE);
    }

    public static final void shouldContainIgnoringCase(@Nullable String $this$shouldContainIgnoringCase, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldContainIgnoringCase, MatchersKt.containIgnoringCase(substr));
    }

    public static final void shouldNotContainIgnoringCase(@Nullable String $this$shouldNotContainIgnoringCase, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotContainIgnoringCase, MatchersKt.containIgnoringCase(substr));
    }

    @NotNull
    public static final Matcher<String> containIgnoringCase(@NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(substr){
            final /* synthetic */ String $substr;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                String string = value;
                MatcherResult.Companion companion = MatcherResult.Companion;
                boolean bl = false;
                String string2 = string.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                CharSequence charSequence = string2;
                string = this.$substr;
                charSequence = charSequence;
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                String string5 = string4;
                return companion.invoke(StringsKt.indexOf$default((CharSequence)charSequence, (String)string5, (int)0, (boolean)false, (int)6, null) >= 0, (Function0)new Function0<String>(this, value){
                    final /* synthetic */ containIgnoringCase.1 this$0;
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should contain the substring " + ShowKt.show((Object)this.this$0.$substr).getValue() + " (case insensitive)";
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        super(0);
                    }
                }, (Function0)new Function0<String>(this, value){
                    final /* synthetic */ containIgnoringCase.1 this$0;
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should not contain the substring " + ShowKt.show((Object)this.this$0.$substr).getValue() + " (case insensitive)";
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        super(0);
                    }
                });
            }
            {
                this.$substr = string;
                super(1);
            }
        }));
    }

    public static final void shouldContain(@Nullable String $this$shouldContain, @NotNull Regex regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        ShouldKt.should((Object)$this$shouldContain, MatchersKt.contain(regex));
    }

    public static final void shouldNotContain(@Nullable String $this$shouldNotContain, @NotNull Regex regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        ShouldKt.shouldNot((Object)$this$shouldNotContain, MatchersKt.contain(regex));
    }

    @NotNull
    public static final Matcher<String> contain(@NotNull Regex regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(regex){
            final /* synthetic */ Regex $regex;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                CharSequence charSequence = value;
                Regex regex = this.$regex;
                MatcherResult.Companion companion = MatcherResult.Companion;
                boolean bl = false;
                boolean bl2 = regex.containsMatchIn(charSequence);
                return companion.invoke(bl2, (Function0)new Function0<String>(this, value){
                    final /* synthetic */ contain.1 this$0;
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should contain regex " + this.this$0.$regex;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        super(0);
                    }
                }, (Function0)new Function0<String>(this, value){
                    final /* synthetic */ contain.1 this$0;
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should not contain regex " + this.this$0.$regex;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        super(0);
                    }
                });
            }
            {
                this.$regex = regex;
                super(1);
            }
        }));
    }

    public static final void shouldContainInOrder(@Nullable String $this$shouldContainInOrder, String ... substrings) {
        Intrinsics.checkParameterIsNotNull((Object)substrings, (String)"substrings");
        ShouldKt.should((Object)$this$shouldContainInOrder, MatchersKt.containInOrder(Arrays.copyOf(substrings, substrings.length)));
    }

    public static final void shouldNotContainInOrder(@Nullable String $this$shouldNotContainInOrder, String ... substrings) {
        Intrinsics.checkParameterIsNotNull((Object)substrings, (String)"substrings");
        ShouldKt.shouldNot((Object)$this$shouldNotContainInOrder, MatchersKt.containInOrder(Arrays.copyOf(substrings, substrings.length)));
    }

    @NotNull
    public static final Matcher<String> containInOrder(String ... substrings) {
        Intrinsics.checkParameterIsNotNull((Object)substrings, (String)"substrings");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(substrings){
            final /* synthetic */ String[] $substrings;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                containInOrder.1 $fun$recTest$1 = containInOrder.1.INSTANCE;
                String[] stringArray = this.$substrings;
                String string = value;
                containInOrder.1 var17_5 = $fun$recTest$1;
                MatcherResult.Companion companion = MatcherResult.Companion;
                boolean $i$f$filter = false;
                void var5_8 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                void var8_11 = $this$filterTo$iv$iv;
                int n = ((void)var8_11).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = var8_11[i];
                    boolean bl = false;
                    CharSequence charSequence = (CharSequence)it;
                    boolean bl2 = false;
                    if (!(charSequence.length() > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                return companion.invoke(var17_5.invoke(string, list), (Function0)new Function0<String>(this, value){
                    final /* synthetic */ containInOrder.1 this$0;
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should include substrings " + ShowKt.show((Object)this.this$0.$substrings).getValue() + " in order";
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        super(0);
                    }
                }, (Function0)new Function0<String>(this, value){
                    final /* synthetic */ containInOrder.1 this$0;
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should not include substrings " + ShowKt.show((Object)this.this$0.$substrings).getValue() + " in order";
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = string;
                        super(0);
                    }
                });
            }
            {
                this.$substrings = stringArray;
                super(1);
            }
        }));
    }

    public static final void shouldContain(@Nullable String $this$shouldContain, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldContain, MatchersKt.contain(substr));
    }

    public static final void shouldNotContain(@Nullable String $this$shouldNotContain, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotContain, MatchersKt.contain(substr));
    }

    @NotNull
    public static final Matcher<String> contain(@NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        return MatchersKt.include(substr);
    }

    public static final void shouldInclude(@Nullable String $this$shouldInclude, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldInclude, MatchersKt.include(substr));
    }

    public static final void shouldNotInclude(@Nullable String $this$shouldNotInclude, @NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotInclude, MatchersKt.include(substr));
    }

    @NotNull
    public static final Matcher<String> include(@NotNull String substr) {
        Intrinsics.checkParameterIsNotNull((Object)substr, (String)"substr");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(substr){
            final /* synthetic */ String $substr;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(StringsKt.contains$default((CharSequence)value, (CharSequence)this.$substr, (boolean)false, (int)2, null), ShowKt.show((Object)value).getValue() + " should include substring " + ShowKt.show((Object)this.$substr).getValue(), ShowKt.show((Object)value).getValue() + " should not include substring " + ShowKt.show((Object)this.$substr).getValue());
            }
            {
                this.$substr = string;
                super(1);
            }
        }));
    }

    public static final void shouldHaveMaxLength(@Nullable String $this$shouldHaveMaxLength, int length) {
        ShouldKt.should((Object)$this$shouldHaveMaxLength, MatchersKt.haveMaxLength(length));
    }

    public static final void shouldNotHaveMaxLength(@Nullable String $this$shouldNotHaveMaxLength, int length) {
        ShouldKt.shouldNot((Object)$this$shouldNotHaveMaxLength, MatchersKt.haveMaxLength(length));
    }

    @NotNull
    public static final Matcher<String> haveMaxLength(int length) {
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(length){
            final /* synthetic */ int $length;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() <= this.$length, ShowKt.show((Object)value).getValue() + " should have maximum length of " + this.$length, ShowKt.show((Object)value).getValue() + " should have minimum length of " + (this.$length - 1));
            }
            {
                this.$length = n;
                super(1);
            }
        }));
    }

    public static final void shouldHaveMinLength(@Nullable String $this$shouldHaveMinLength, int length) {
        ShouldKt.should((Object)$this$shouldHaveMinLength, MatchersKt.haveMinLength(length));
    }

    public static final void shouldNotHaveMinLength(@Nullable String $this$shouldNotHaveMinLength, int length) {
        ShouldKt.shouldNot((Object)$this$shouldNotHaveMinLength, MatchersKt.haveMinLength(length));
    }

    @NotNull
    public static final Matcher<String> haveMinLength(int length) {
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(length){
            final /* synthetic */ int $length;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() >= this.$length, ShowKt.show((Object)value).getValue() + " should have minimum length of " + this.$length, ShowKt.show((Object)value).getValue() + " should have maximum length of " + (this.$length - 1));
            }
            {
                this.$length = n;
                super(1);
            }
        }));
    }

    public static final void shouldHaveLengthBetween(@Nullable String $this$shouldHaveLengthBetween, int min, int max) {
        ShouldKt.should((Object)$this$shouldHaveLengthBetween, MatchersKt.haveLengthBetween(min, max));
    }

    public static final void shouldNotHaveLengthBetween(@Nullable String $this$shouldNotHaveLengthBetween, int min, int max) {
        ShouldKt.shouldNot((Object)$this$shouldNotHaveLengthBetween, MatchersKt.haveLengthBetween(min, max));
    }

    @NotNull
    public static final Matcher<String> haveLengthBetween(int min, int max) {
        boolean bl = min <= max;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(min, max){
            final /* synthetic */ int $min;
            final /* synthetic */ int $max;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                int n = value.length();
                return MatcherResult.Companion.invoke(this.$min <= n && this.$max >= n, ShowKt.show((Object)value).getValue() + " should have length in " + this.$min + ".." + this.$max + " but was " + value.length(), ShowKt.show((Object)value).getValue() + " should not have length between " + this.$min + " and " + this.$max);
            }
            {
                this.$min = n;
                this.$max = n2;
                super(1);
            }
        }));
    }

    public static final void shouldHaveLengthIn(@Nullable String $this$shouldHaveLengthIn, @NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        ShouldKt.should((Object)$this$shouldHaveLengthIn, MatchersKt.haveLengthIn(range));
    }

    public static final void shouldNotHaveLengthIn(@Nullable String $this$shouldNotHaveLengthIn, @NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveLengthIn, MatchersKt.haveLengthIn(range));
    }

    @NotNull
    public static final Matcher<String> haveLengthIn(@NotNull IntRange range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(range){
            final /* synthetic */ IntRange $range;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.$range.contains(value.length()), ShowKt.show((Object)value).getValue() + " should have length in " + this.$range + " but was " + value.length(), ShowKt.show((Object)value).getValue() + " should not have length between " + this.$range);
            }
            {
                this.$range = intRange;
                super(1);
            }
        }));
    }

    public static final void shouldHaveLength(@Nullable String $this$shouldHaveLength, int length) {
        ShouldKt.should((Object)$this$shouldHaveLength, StringMatchersKt.haveLength(length));
    }

    public static final void shouldNotHaveLength(@Nullable String $this$shouldNotHaveLength, int length) {
        ShouldKt.shouldNot((Object)$this$shouldNotHaveLength, StringMatchersKt.haveLength(length));
    }

    public static final void shouldMatch(@Nullable String $this$shouldMatch, @NotNull String regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        ShouldKt.should((Object)$this$shouldMatch, StringMatchersKt.match(regex));
    }

    public static final void shouldMatch(@Nullable String $this$shouldMatch, @NotNull Regex regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        ShouldKt.should((Object)$this$shouldMatch, StringMatchersKt.match(regex));
    }

    public static final void shouldNotMatch(@Nullable String $this$shouldNotMatch, @NotNull String regex) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        ShouldKt.shouldNot((Object)$this$shouldNotMatch, StringMatchersKt.match(regex));
    }

    public static final void shouldEndWith(@Nullable String $this$shouldEndWith, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        ShouldKt.should((Object)$this$shouldEndWith, StringMatchersKt.endWith(suffix));
    }

    public static final void shouldNotEndWith(@Nullable String $this$shouldNotEndWith, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        ShouldKt.shouldNot((Object)$this$shouldNotEndWith, StringMatchersKt.endWith(suffix));
    }

    public static final void shouldStartWith(@Nullable String $this$shouldStartWith, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        ShouldKt.should((Object)$this$shouldStartWith, StringMatchersKt.startWith(prefix));
    }

    public static final void shouldNotStartWith(@Nullable String $this$shouldNotStartWith, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWith, StringMatchersKt.startWith(prefix));
    }

    public static final void shouldBeEqualIgnoringCase(@Nullable String $this$shouldBeEqualIgnoringCase, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeEqualIgnoringCase, MatchersKt.beEqualIgnoringCase(other));
    }

    public static final void shouldNotBeEqualIgnoringCase(@Nullable String $this$shouldNotBeEqualIgnoringCase, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeEqualIgnoringCase, MatchersKt.beEqualIgnoringCase(other));
    }

    @NotNull
    public static final Matcher<String> beEqualIgnoringCase(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return MatcherKt.neverNullMatcher((Function1)((Function1)new Function1<String, MatcherResult>(other){
            final /* synthetic */ String $other;

            @NotNull
            public final MatcherResult invoke(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(StringsKt.equals((String)value, (String)this.$other, (boolean)true), ShowKt.show((Object)value).getValue() + " should be equal ignoring case " + ShowKt.show((Object)this.$other).getValue(), ShowKt.show((Object)value).getValue() + " should not be equal ignoring case " + ShowKt.show((Object)this.$other).getValue());
            }
            {
                this.$other = string;
                super(1);
            }
        }));
    }

    public static final void shouldBeTruthy(@Nullable String $this$shouldBeTruthy) {
        ShouldKt.should((Object)$this$shouldBeTruthy, MatchersKt.beTruthy());
    }

    public static final void shouldBeFalsy(@Nullable String $this$shouldBeFalsy) {
        ShouldKt.should((Object)$this$shouldBeFalsy, MatchersKt.beFalsy());
    }

    @NotNull
    public static final Matcher<String> beTruthy() {
        return (Matcher)new Matcher<String>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public MatcherResult test(@Nullable String value) {
                boolean bl;
                MatcherResult.Companion companion;
                block3: {
                    void $this$any$iv;
                    Iterable iterable = MatchersKt.access$getTruthyValues$p();
                    companion = MatcherResult.Companion;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it, (String)value, (boolean)true)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                return companion.invoke(bl3, (Function0)new Function0<String>(value){
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should be equal (ignoring case) to one of: " + MatchersKt.access$getTruthyValues$p();
                    }
                    {
                        this.$value = string;
                        super(0);
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should not be equal (ignoring case) to one of: " + MatchersKt.access$getTruthyValues$p();
                    }
                    {
                        this.$value = string;
                        super(0);
                    }
                });
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, String> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, String> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<String> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    @NotNull
    public static final Matcher<String> beFalsy() {
        return (Matcher)new Matcher<String>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public MatcherResult test(@Nullable String value) {
                boolean bl;
                MatcherResult.Companion companion;
                block3: {
                    void $this$any$iv;
                    Iterable iterable = MatchersKt.access$getFalsyValues$p();
                    companion = MatcherResult.Companion;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals((String)it, (String)value, (boolean)true)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                boolean bl3 = bl;
                return companion.invoke(bl3, (Function0)new Function0<String>(value){
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should be equal (ignoring case) to one of: " + MatchersKt.access$getFalsyValues$p();
                    }
                    {
                        this.$value = string;
                        super(0);
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ String $value;

                    @NotNull
                    public final String invoke() {
                        return ShowKt.show((Object)this.$value).getValue() + " should not be equal (ignoring case) to one of: " + MatchersKt.access$getFalsyValues$p();
                    }
                    {
                        this.$value = string;
                        super(0);
                    }
                });
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, String> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, String> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<String> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeUUID(@NotNull String $this$shouldBeUUID, @NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeUUID, (String)"$this$shouldBeUUID");
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        ShouldKt.should((Object)$this$shouldBeUUID, MatchersKt.beUUID(version, considerNilValid));
    }

    public static /* synthetic */ void shouldBeUUID$default(String string, UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        MatchersKt.shouldBeUUID(string, uUIDVersion, bl);
    }

    public static final void shouldNotBeUUID(@NotNull String $this$shouldNotBeUUID, @NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeUUID, (String)"$this$shouldNotBeUUID");
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        ShouldKt.shouldNot((Object)$this$shouldNotBeUUID, MatchersKt.beUUID(version, considerNilValid));
    }

    public static /* synthetic */ void shouldNotBeUUID$default(String string, UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        MatchersKt.shouldNotBeUUID(string, uUIDVersion, bl);
    }

    @NotNull
    public static final Matcher<String> beUUID(@NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
        return (Matcher)new Matcher<String>(considerNilValid, version){
            final /* synthetic */ boolean $considerNilValid;
            final /* synthetic */ UUIDVersion $version;

            @NotNull
            public MatcherResult test(@NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                CharSequence charSequence = value;
                Regex regex = this.$version.getUuidRegex();
                MatcherResult.Companion companion = MatcherResult.Companion;
                boolean bl = false;
                boolean bl2 = regex.matches(charSequence);
                return companion.invoke(bl2 || this.$considerNilValid && this.isNilUUID(value), "String " + value + " is not an UUID (" + (Object)((Object)this.$version) + "), but should be", "String " + value + " is an UUID (" + (Object)((Object)this.$version) + "), but shouldn't be");
            }

            private final boolean isNilUUID(@NotNull String $this$isNilUUID) {
                return Intrinsics.areEqual((Object)$this$isNilUUID, (Object)"00000000-0000-0000-0000-000000000000");
            }
            {
                this.$considerNilValid = $captured_local_variable$0;
                this.$version = $captured_local_variable$1;
            }

            @NotNull
            public Matcher<String> and(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, String> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, String> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<String> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<String> or(@NotNull Matcher<String> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static /* synthetic */ Matcher beUUID$default(UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return MatchersKt.beUUID(uUIDVersion, bl);
    }

    public static final int shouldBeInteger(@Nullable String $this$shouldBeInteger, int radix) {
        boolean bl = false;
        String string = $this$shouldBeInteger;
        if (string == null) {
            throw (Throwable)((Object)FailuresKt.failure((String)"String is null, but it should be integer."));
        }
        Integer integer = StringsKt.toIntOrNull((String)$this$shouldBeInteger, (int)radix);
        if (integer == null) {
            throw (Throwable)((Object)FailuresKt.failure((String)("String '" + $this$shouldBeInteger + "' is not integer, but it should be.")));
        }
        return integer;
    }

    public static /* synthetic */ int shouldBeInteger$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return MatchersKt.shouldBeInteger(string, n);
    }

    public static final /* synthetic */ List access$getTruthyValues$p() {
        return truthyValues;
    }

    public static final /* synthetic */ List access$getFalsyValues$p() {
        return falsyValues;
    }
}

