/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.doubles;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\nR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kotest/matchers/doubles/ToleranceMatcher;", "Lio/kotest/matchers/Matcher;", "", "expected", "tolerance", "(Ljava/lang/Double;D)V", "Ljava/lang/Double;", "test", "Lio/kotest/matchers/MatcherResult;", "value", "(Ljava/lang/Double;)Lio/kotest/matchers/MatcherResult;", "kotest-assertions-core"})
public final class ToleranceMatcher
implements Matcher<Double> {
    private final Double expected;
    private final double tolerance;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MatcherResult test(@Nullable Double value) {
        MatcherResult matcherResult;
        if (value == null || this.expected == null) {
            matcherResult = MatcherResult.Companion.invoke(Intrinsics.areEqual((Double)value, (Double)this.expected), value + " should be equal to " + this.expected, value + " should not be equal to " + this.expected);
            return matcherResult;
        }
        double d = this.expected;
        boolean bl = false;
        if (Double.isNaN(d)) {
            d = value;
            bl = false;
            if (Double.isNaN(d)) {
                String string = "[WARN] By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
                boolean bl2 = false;
                System.out.println((Object)string);
                matcherResult = MatcherResult.Companion.invoke(false, "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776", "By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
                return matcherResult;
            }
        }
        if (this.tolerance == 0.0) {
            String string = "[WARN] When comparing doubles consider using tolerance, eg: a shouldBe (b plusOrMinus c)";
            boolean bl3 = false;
            System.out.println((Object)string);
        }
        double d2 = value - this.expected;
        boolean bl4 = false;
        double diff2 = Math.abs(d2);
        boolean passed = diff2 <= this.tolerance;
        double low = this.expected - this.tolerance;
        double high = this.expected + this.tolerance;
        double d3 = this.tolerance;
        String msg = d3 == 0.0 ? value + " should be equal to " + this.expected : value + " should be equal to " + this.expected + " within tolerance of " + this.tolerance + " (lowest acceptable value is " + low + "; highest acceptable value is " + high + ')';
        matcherResult = MatcherResult.Companion.invoke(passed, msg, value + " should not be equal to " + this.expected);
        return matcherResult;
    }

    public ToleranceMatcher(@Nullable Double expected, double tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @NotNull
    public Matcher<Double> and(@NotNull Matcher<Double> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.and((Matcher)this, other);
    }

    @NotNull
    public <U> Matcher<U> compose(@NotNull Function1<? super U, Double> fn) {
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        return Matcher.DefaultImpls.compose((Matcher)this, fn);
    }

    @NotNull
    public <U> Matcher<U> contramap(@NotNull Function1<? super U, Double> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return Matcher.DefaultImpls.contramap((Matcher)this, f);
    }

    @NotNull
    public Matcher<Double> invert() {
        return Matcher.DefaultImpls.invert((Matcher)this);
    }

    @NotNull
    public Matcher<Double> or(@NotNull Matcher<Double> other) {
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return Matcher.DefaultImpls.or((Matcher)this, other);
    }
}

