/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.file;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.file.MatchersKt;
import io.kotest.matchers.paths.PathsKt;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b/\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002\u001a\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002\u001a\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a%\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0019\"\u00020\u0011\u00a2\u0006\u0002\u0010\u001a\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\"\u001a\u00020\u0002\u001a\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010#\u001a\u00020$\u001a\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010%\u001a\u00020\u0011\u001a\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'*\u00020\u0002H\u0002\u001a\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020'*\u00020\u0002H\u0002\u001a\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00020'*\u00020\u00022\u0006\u0010)\u001a\u00020*H\u0002\u001a\n\u0010+\u001a\u00020,*\u00020\u0002\u001a\n\u0010-\u001a\u00020,*\u00020\u0002\u001a\n\u0010.\u001a\u00020,*\u00020\u0002\u001a\n\u0010/\u001a\u00020,*\u00020\u0002\u001a\n\u00100\u001a\u00020,*\u00020\u0002\u001a\n\u00101\u001a\u00020,*\u00020\u0002\u001a\n\u00102\u001a\u00020,*\u00020\u0002\u001a\u0015\u00103\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u00103\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020$H\u0086\u0004\u001a\n\u00104\u001a\u00020,*\u00020\u0002\u001a\n\u00105\u001a\u00020,*\u00020\u0002\u001a\n\u00106\u001a\u00020,*\u00020\u0002\u001a\u0015\u00107\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u00107\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020$H\u0086\u0004\u001a\n\u00108\u001a\u00020,*\u00020\u0002\u001a\n\u00109\u001a\u00020,*\u00020\u0002\u001a\u0015\u0010:\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010;\u001a\u00020,*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\n\u0010<\u001a\u00020,*\u00020\u0002\u001a#\u0010=\u001a\u00020,*\u00020\u00022\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0019\"\u00020\u0011\u00a2\u0006\u0002\u0010>\u001a\u0015\u0010?\u001a\u00020,*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010@\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010A\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010B\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\n\u0010C\u001a\u00020,*\u00020\u0002\u001a\n\u0010D\u001a\u00020,*\u00020\u0002\u001a\n\u0010E\u001a\u00020,*\u00020\u0002\u001a\n\u0010F\u001a\u00020,*\u00020\u0002\u001a\n\u0010G\u001a\u00020,*\u00020\u0002\u001a\n\u0010H\u001a\u00020,*\u00020\u0002\u001a\n\u0010I\u001a\u00020,*\u00020\u0002\u001a\u0015\u0010J\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010J\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020$H\u0086\u0004\u001a\n\u0010K\u001a\u00020,*\u00020\u0002\u001a\n\u0010L\u001a\u00020,*\u00020\u0002\u001a\n\u0010M\u001a\u00020,*\u00020\u0002\u001a\u0015\u0010N\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010N\u001a\u00020,*\u00020\u00022\u0006\u0010\t\u001a\u00020$H\u0086\u0004\u001a\n\u0010O\u001a\u00020,*\u00020\u0002\u001a\n\u0010P\u001a\u00020,*\u00020\u0002\u001a\u0015\u0010Q\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010R\u001a\u00020,*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\n\u0010S\u001a\u00020,*\u00020\u0002\u001a#\u0010T\u001a\u00020,*\u00020\u00022\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0019\"\u00020\u0011\u00a2\u0006\u0002\u0010>\u001a\u0015\u0010U\u001a\u00020,*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010V\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010W\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010X\u001a\u00020,*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020,*\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020,*\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020,*\u00020\u00022\u0006\u0010%\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010Y\u001a\u00020,*\u00020$2\u0006\u0010#\u001a\u00020$H\u0086\u0004\u001a\u0015\u0010Z\u001a\u00020,*\u00020\u00022\u0006\u0010\"\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010Z\u001a\u00020,*\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0086\u0004\u001a\u0015\u0010Z\u001a\u00020,*\u00020\u00022\u0006\u0010%\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010Z\u001a\u00020,*\u00020$2\u0006\u0010#\u001a\u00020$H\u0086\u0004\u00a8\u0006["}, d2={"aDirectory", "Lio/kotest/matchers/Matcher;", "Ljava/io/File;", "aFile", "beAbsolute", "beCanonicalPath", "beExecutable", "beHidden", "beLarger", "other", "beNonEmptyDirectory", "beReadable", "beRelative", "beSmaller", "beWriteable", "containFile", "name", "", "containNFiles", "n", "", "emptyFile", "exist", "haveExtension", "exts", "", "([Ljava/lang/String;)Lio/kotest/matchers/Matcher;", "haveFileSize", "size", "", "haveName", "haveParent", "havePath", "startWithPath", "file", "path", "Ljava/nio/file/Path;", "prefix", "safeList", "", "safeListFiles", "filter", "Ljava/io/FileFilter;", "shouldBeADirectory", "", "shouldBeAFile", "shouldBeAbsolute", "shouldBeCanonical", "shouldBeEmpty", "shouldBeExecutable", "shouldBeHidden", "shouldBeLarger", "shouldBeNonEmptyDirectory", "shouldBeReadable", "shouldBeRelative", "shouldBeSmaller", "shouldBeSymbolicLink", "shouldBeWriteable", "shouldContainFile", "shouldContainNFiles", "shouldExist", "shouldHaveExtension", "(Ljava/io/File;[Ljava/lang/String;)V", "shouldHaveFileSize", "shouldHaveName", "shouldHaveParent", "shouldHavePath", "shouldNotBeADirectory", "shouldNotBeAFile", "shouldNotBeAbsolute", "shouldNotBeCanonical", "shouldNotBeEmpty", "shouldNotBeExecutable", "shouldNotBeHidden", "shouldNotBeLarger", "shouldNotBeNonEmptyDirectory", "shouldNotBeReadable", "shouldNotBeRelative", "shouldNotBeSmaller", "shouldNotBeSymbolicLink", "shouldNotBeWriteable", "shouldNotContainFile", "shouldNotContainNFiles", "shouldNotExist", "shouldNotHaveExtension", "shouldNotHaveFileSize", "shouldNotHaveName", "shouldNotHaveParent", "shouldNotHavePath", "shouldNotStartWithPath", "shouldStartWithPath", "kotest-assertions-core"})
public final class MatchersKt {
    private static final List<String> safeList(@NotNull File $this$safeList) {
        Object object = $this$safeList.list();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<File> safeListFiles(@NotNull File $this$safeListFiles) {
        Object object = $this$safeListFiles.listFiles();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<File> safeListFiles(@NotNull File $this$safeListFiles, FileFilter filter) {
        Object object = $this$safeListFiles.listFiles(filter);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final void shouldBeNonEmptyDirectory(@NotNull File $this$shouldBeNonEmptyDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeNonEmptyDirectory, (String)"$this$shouldBeNonEmptyDirectory");
        ShouldKt.should((Object)$this$shouldBeNonEmptyDirectory, MatchersKt.beNonEmptyDirectory());
    }

    public static final void shouldNotBeNonEmptyDirectory(@NotNull File $this$shouldNotBeNonEmptyDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeNonEmptyDirectory, (String)"$this$shouldNotBeNonEmptyDirectory");
        ShouldKt.shouldNot((Object)$this$shouldNotBeNonEmptyDirectory, MatchersKt.beNonEmptyDirectory());
    }

    @NotNull
    public static final Matcher<File> beNonEmptyDirectory() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory() && MatchersKt.access$safeList(value).isEmpty(), value + " should be a non empty directory", value + " should not be a non empty directory");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldContainNFiles(@NotNull File $this$shouldContainNFiles, int n) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldContainNFiles, (String)"$this$shouldContainNFiles");
        ShouldKt.shouldBe((Object)$this$shouldContainNFiles, MatchersKt.containNFiles(n));
    }

    public static final void shouldNotContainNFiles(@NotNull File $this$shouldNotContainNFiles, int n) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotContainNFiles, (String)"$this$shouldNotContainNFiles");
        ShouldKt.shouldNotBe((Object)$this$shouldNotContainNFiles, MatchersKt.containNFiles(n));
    }

    @NotNull
    public static final Matcher<File> containNFiles(int n) {
        return (Matcher)new Matcher<File>(n){
            final /* synthetic */ int $n;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory() && MatchersKt.access$safeList(value).size() == this.$n, value + " should be a directory and contain " + this.$n + " files", value + " should not be a directory containing " + this.$n + " files");
            }
            {
                this.$n = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeEmpty(@NotNull File $this$shouldBeEmpty) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeEmpty, (String)"$this$shouldBeEmpty");
        ShouldKt.shouldBe((Object)$this$shouldBeEmpty, MatchersKt.emptyFile());
    }

    public static final void shouldNotBeEmpty(@NotNull File $this$shouldNotBeEmpty) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeEmpty, (String)"$this$shouldNotBeEmpty");
        ShouldKt.shouldNotBe((Object)$this$shouldNotBeEmpty, MatchersKt.emptyFile());
    }

    @NotNull
    public static final Matcher<File> emptyFile() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == 0L, "File " + value + " should be empty", "File " + value + " should not be empty");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldExist(@NotNull File $this$shouldExist) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldExist, (String)"$this$shouldExist");
        ShouldKt.should((Object)$this$shouldExist, MatchersKt.exist());
    }

    public static final void shouldNotExist(@NotNull File $this$shouldNotExist) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotExist, (String)"$this$shouldNotExist");
        ShouldKt.shouldNot((Object)$this$shouldNotExist, MatchersKt.exist());
    }

    @NotNull
    public static final Matcher<File> exist() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.exists(), "File " + value + " should exist", "File " + value + " should not exist");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldHaveExtension(@NotNull File $this$shouldHaveExtension, String ... exts) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldHaveExtension, (String)"$this$shouldHaveExtension");
        Intrinsics.checkParameterIsNotNull((Object)exts, (String)"exts");
        ShouldKt.should((Object)$this$shouldHaveExtension, MatchersKt.haveExtension(Arrays.copyOf(exts, exts.length)));
    }

    public static final void shouldNotHaveExtension(@NotNull File $this$shouldNotHaveExtension, String ... exts) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotHaveExtension, (String)"$this$shouldNotHaveExtension");
        Intrinsics.checkParameterIsNotNull((Object)exts, (String)"exts");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveExtension, MatchersKt.haveExtension(Arrays.copyOf(exts, exts.length)));
    }

    @NotNull
    public static final Matcher<File> haveExtension(String ... exts) {
        Intrinsics.checkParameterIsNotNull((Object)exts, (String)"exts");
        return (Matcher)new Matcher<File>(exts){
            final /* synthetic */ String[] $exts;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public MatcherResult test(@NotNull File value) {
                boolean bl;
                MatcherResult.Companion companion;
                block1: {
                    void $this$any$iv;
                    Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                    String[] stringArray = this.$exts;
                    companion = MatcherResult.Companion;
                    boolean $i$f$any = false;
                    void var4_5 = $this$any$iv;
                    int n = ((void)var4_5).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv;
                        void it = element$iv = var4_5[i];
                        boolean bl2 = false;
                        String string = value.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.name");
                        if (!StringsKt.endsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                boolean bl3 = bl;
                return companion.invoke(bl3, "File " + value + " should end with one of " + ArraysKt.joinToString$default((Object[])this.$exts, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), "File " + value + " should not end with one of " + ArraysKt.joinToString$default((Object[])this.$exts, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            {
                this.$exts = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldHavePath(@NotNull File $this$shouldHavePath, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldHavePath, (String)"$this$shouldHavePath");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHavePath, MatchersKt.havePath(name));
    }

    public static final void shouldNotHavePath(@NotNull File $this$shouldNotHavePath, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotHavePath, (String)"$this$shouldNotHavePath");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotHavePath, MatchersKt.havePath(name));
    }

    @NotNull
    public static final Matcher<File> havePath(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.getPath(), (Object)this.$name), "File " + value + " should have path " + this.$name, "File " + value + " should not have path " + this.$name);
            }
            {
                this.$name = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldHaveName(@NotNull File $this$shouldHaveName, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldHaveName, (String)"$this$shouldHaveName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHaveName, MatchersKt.haveName(name));
    }

    public static final void shouldNotHaveName(@NotNull File $this$shouldNotHaveName, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotHaveName, (String)"$this$shouldNotHaveName");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveName, MatchersKt.haveName(name));
    }

    @NotNull
    public static final Matcher<File> haveName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.getName(), (Object)this.$name), "File " + value + " should have name " + this.$name, "File " + value + " should not have name " + this.$name);
            }
            {
                this.$name = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldContainFile(@NotNull File $this$shouldContainFile, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldContainFile, (String)"$this$shouldContainFile");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldContainFile, MatchersKt.containFile(name));
    }

    public static final void shouldNotContainFile(@NotNull File $this$shouldNotContainFile, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotContainFile, (String)"$this$shouldNotContainFile");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotContainFile, MatchersKt.containFile(name));
    }

    @NotNull
    public static final Matcher<File> containFile(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                List contents2 = MatchersKt.access$safeList(value);
                boolean passed = value.isDirectory() && contents2.contains(this.$name);
                return MatcherResult.Companion.invoke(passed, "Directory " + value + " should contain a file with filename " + this.$name + " (detected " + contents2.size() + " other files)", "Directory " + value + " should not contain a file with filename " + this.$name);
            }
            {
                this.$name = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeSymbolicLink(@NotNull File $this$shouldBeSymbolicLink) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeSymbolicLink, (String)"$this$shouldBeSymbolicLink");
        Path path = $this$shouldBeSymbolicLink.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"this.toPath()");
        ShouldKt.should((Object)path, PathsKt.beSymbolicLink());
    }

    public static final void shouldNotBeSymbolicLink(@NotNull File $this$shouldNotBeSymbolicLink) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeSymbolicLink, (String)"$this$shouldNotBeSymbolicLink");
        Path path = $this$shouldNotBeSymbolicLink.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"this.toPath()");
        ShouldKt.shouldNot((Object)path, PathsKt.beSymbolicLink());
    }

    public static final void shouldHaveParent(@NotNull File $this$shouldHaveParent, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldHaveParent, (String)"$this$shouldHaveParent");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHaveParent, MatchersKt.haveParent(name));
    }

    public static final void shouldNotHaveParent(@NotNull File $this$shouldNotHaveParent, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotHaveParent, (String)"$this$shouldNotHaveParent");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveParent, MatchersKt.haveParent(name));
    }

    @NotNull
    public static final Matcher<File> haveParent(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;

            private final boolean isParentEqualExpected(File parent) {
                return parent != null && (Intrinsics.areEqual((Object)parent.getName(), (Object)this.$name) || this.isParentEqualExpected(parent.getParentFile()));
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.isParentEqualExpected(value.getParentFile()), (Function0)new Function0<String>(this, value){
                    final /* synthetic */ haveParent.1 this$0;
                    final /* synthetic */ File $value;

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should have parent " + this.this$0.$name;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = file;
                        super(0);
                    }
                }, (Function0)new Function0<String>(this, value){
                    final /* synthetic */ haveParent.1 this$0;
                    final /* synthetic */ File $value;

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not have parent " + this.this$0.$name;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = file;
                        super(0);
                    }
                });
            }
            {
                this.$name = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeADirectory(@NotNull File $this$shouldBeADirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeADirectory, (String)"$this$shouldBeADirectory");
        ShouldKt.should((Object)$this$shouldBeADirectory, MatchersKt.aDirectory());
    }

    public static final void shouldNotBeADirectory(@NotNull File $this$shouldNotBeADirectory) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeADirectory, (String)"$this$shouldNotBeADirectory");
        ShouldKt.shouldNot((Object)$this$shouldNotBeADirectory, MatchersKt.aDirectory());
    }

    @NotNull
    public static final Matcher<File> aDirectory() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory(), "File " + value + " should be a directory", "File " + value + " should not be a directory");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeAFile(@NotNull File $this$shouldBeAFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeAFile, (String)"$this$shouldBeAFile");
        ShouldKt.should((Object)$this$shouldBeAFile, MatchersKt.aFile());
    }

    public static final void shouldNotBeAFile(@NotNull File $this$shouldNotBeAFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeAFile, (String)"$this$shouldNotBeAFile");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAFile, MatchersKt.aFile());
    }

    @NotNull
    public static final Matcher<File> aFile() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isFile(), "File " + value + " should be a file", "File " + value + " should not be a file");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull Path other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeSmaller, (String)"$this$shouldBeSmaller");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"other.toFile()");
        ShouldKt.should((Object)$this$shouldBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeSmaller, (String)"$this$shouldBeSmaller");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeSmaller, MatchersKt.beSmaller(other));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull Path other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeSmaller, (String)"$this$shouldNotBeSmaller");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"other.toFile()");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeSmaller, (String)"$this$shouldNotBeSmaller");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, MatchersKt.beSmaller(other));
    }

    @NotNull
    public static final Matcher<File> beSmaller(@NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() < this.$other.length(), "File " + value + " (" + sizea + " bytes) should be smaller than " + this.$other + " (" + sizeb + " bytes)", "File " + value + " (" + sizea + " bytes) should not be smaller than " + this.$other + " (" + sizeb + " bytes)");
            }
            {
                this.$other = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull Path other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeLarger, (String)"$this$shouldBeLarger");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"other.toFile()");
        ShouldKt.should((Object)$this$shouldBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeLarger, (String)"$this$shouldBeLarger");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeLarger, MatchersKt.beLarger(other));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull Path other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeLarger, (String)"$this$shouldNotBeLarger");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"other.toFile()");
        ShouldKt.shouldNot((Object)$this$shouldNotBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeLarger, (String)"$this$shouldNotBeLarger");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeLarger, MatchersKt.beLarger(other));
    }

    @NotNull
    public static final Matcher<File> beLarger(@NotNull File other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() > this.$other.length(), "File " + value + " (" + sizea + " bytes) should be larger than " + this.$other + " (" + sizeb + " bytes)", "File " + value + " (" + sizea + " bytes) should not be larger than " + this.$other + " (" + sizeb + " bytes)");
            }
            {
                this.$other = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeCanonical(@NotNull File $this$shouldBeCanonical) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeCanonical, (String)"$this$shouldBeCanonical");
        ShouldKt.should((Object)$this$shouldBeCanonical, MatchersKt.beCanonicalPath());
    }

    public static final void shouldNotBeCanonical(@NotNull File $this$shouldNotBeCanonical) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeCanonical, (String)"$this$shouldNotBeCanonical");
        ShouldKt.shouldNot((Object)$this$shouldNotBeCanonical, MatchersKt.beCanonicalPath());
    }

    @NotNull
    public static final Matcher<File> beCanonicalPath() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.getCanonicalPath(), (Object)value.getPath()), "File " + value + " should be canonical", "File " + value + " should not be canonical");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeAbsolute(@NotNull File $this$shouldBeAbsolute) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeAbsolute, (String)"$this$shouldBeAbsolute");
        ShouldKt.should((Object)$this$shouldBeAbsolute, MatchersKt.beAbsolute());
    }

    public static final void shouldNotBeAbsolute(@NotNull File $this$shouldNotBeAbsolute) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeAbsolute, (String)"$this$shouldNotBeAbsolute");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAbsolute, MatchersKt.beAbsolute());
    }

    @NotNull
    public static final Matcher<File> beAbsolute() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isAbsolute(), "File " + value + " should be absolute", "File " + value + " should not be absolute");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeRelative(@NotNull File $this$shouldBeRelative) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeRelative, (String)"$this$shouldBeRelative");
        ShouldKt.should((Object)$this$shouldBeRelative, MatchersKt.beRelative());
    }

    public static final void shouldNotBeRelative(@NotNull File $this$shouldNotBeRelative) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeRelative, (String)"$this$shouldNotBeRelative");
        ShouldKt.shouldNot((Object)$this$shouldNotBeRelative, MatchersKt.beRelative());
    }

    @NotNull
    public static final Matcher<File> beRelative() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(!value.isAbsolute(), "File " + value + " should be relative", "File " + value + " should not be relative");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldHaveFileSize(@NotNull File $this$shouldHaveFileSize, long size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldHaveFileSize, (String)"$this$shouldHaveFileSize");
        ShouldKt.should((Object)$this$shouldHaveFileSize, MatchersKt.haveFileSize(size));
    }

    public static final void shouldNotHaveFileSize(@NotNull File $this$shouldNotHaveFileSize, long size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotHaveFileSize, (String)"$this$shouldNotHaveFileSize");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveFileSize, MatchersKt.haveFileSize(size));
    }

    @NotNull
    public static final Matcher<File> haveFileSize(long size) {
        return (Matcher)new Matcher<File>(size){
            final /* synthetic */ long $size;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == this.$size, "File " + value + " should have size " + this.$size, "File " + value + " should not have size " + this.$size);
            }
            {
                this.$size = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeWriteable(@NotNull File $this$shouldBeWriteable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeWriteable, (String)"$this$shouldBeWriteable");
        ShouldKt.should((Object)$this$shouldBeWriteable, MatchersKt.beWriteable());
    }

    public static final void shouldNotBeWriteable(@NotNull File $this$shouldNotBeWriteable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeWriteable, (String)"$this$shouldNotBeWriteable");
        ShouldKt.shouldNot((Object)$this$shouldNotBeWriteable, MatchersKt.beWriteable());
    }

    @NotNull
    public static final Matcher<File> beWriteable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canWrite(), "File " + value + " should be writeable", "File " + value + " should not be writeable");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeExecutable(@NotNull File $this$shouldBeExecutable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeExecutable, (String)"$this$shouldBeExecutable");
        ShouldKt.should((Object)$this$shouldBeExecutable, MatchersKt.beExecutable());
    }

    public static final void shouldNotBeExecutable(@NotNull File $this$shouldNotBeExecutable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeExecutable, (String)"$this$shouldNotBeExecutable");
        ShouldKt.shouldNot((Object)$this$shouldNotBeExecutable, MatchersKt.beExecutable());
    }

    @NotNull
    public static final Matcher<File> beExecutable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canExecute(), "File " + value + " should be executable", "File " + value + " should not be executable");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeHidden(@NotNull File $this$shouldBeHidden) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeHidden, (String)"$this$shouldBeHidden");
        ShouldKt.should((Object)$this$shouldBeHidden, MatchersKt.beHidden());
    }

    public static final void shouldNotBeHidden(@NotNull File $this$shouldNotBeHidden) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeHidden, (String)"$this$shouldNotBeHidden");
        ShouldKt.shouldNot((Object)$this$shouldNotBeHidden, MatchersKt.beHidden());
    }

    @NotNull
    public static final Matcher<File> beHidden() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isHidden(), "File " + value + " should be hidden", "File " + value + " should not be hidden");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldBeReadable(@NotNull File $this$shouldBeReadable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldBeReadable, (String)"$this$shouldBeReadable");
        ShouldKt.should((Object)$this$shouldBeReadable, MatchersKt.beReadable());
    }

    public static final void shouldNotBeReadable(@NotNull File $this$shouldNotBeReadable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotBeReadable, (String)"$this$shouldNotBeReadable");
        ShouldKt.shouldNot((Object)$this$shouldNotBeReadable, MatchersKt.beReadable());
    }

    @NotNull
    public static final Matcher<File> beReadable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canRead(), "File " + value + " should be readable", "File " + value + " should not be readable");
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldStartWithPath, (String)"$this$shouldStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotStartWithPath, (String)"$this$shouldNotStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldStartWithPath, (String)"$this$shouldStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotStartWithPath, (String)"$this$shouldNotStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldStartWithPath, (String)"$this$shouldStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotStartWithPath, (String)"$this$shouldNotStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldStartWithPath, (String)"$this$shouldStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = $this$shouldStartWithPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"this.toFile()");
        ShouldKt.should((Object)file, MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldNotStartWithPath, (String)"$this$shouldNotStartWithPath");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = $this$shouldNotStartWithPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"this.toFile()");
        ShouldKt.shouldNot((Object)file, MatchersKt.startWithPath(path));
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path.toFile()");
        return MatchersKt.startWithPath(file);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.toString()");
        return MatchersKt.startWithPath(string);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return (Matcher)new Matcher<File>(prefix){
            final /* synthetic */ String $prefix;

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                String string = value.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.toString()");
                return MatcherResult.Companion.invoke(StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null), "File " + value + " should start with " + this.$prefix, "File " + value + " should not start with " + this.$prefix);
            }
            {
                this.$prefix = $captured_local_variable$0;
            }

            @NotNull
            public Matcher<File> and(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.and((Matcher)this, other);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public Matcher<File> or(@NotNull Matcher<File> other) {
                Intrinsics.checkParameterIsNotNull(other, (String)"other");
                return Matcher.DefaultImpls.or((Matcher)this, other);
            }
        };
    }

    public static final /* synthetic */ List access$safeList(File $this$access_u24safeList) {
        return MatchersKt.safeList($this$access_u24safeList);
    }
}

