/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.floats;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002H\u0086\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/kotest/matchers/floats/FloatToleranceMatcher;", "Lio/kotest/matchers/Matcher;", "", "expected", "tolerance", "(FF)V", "plusOrMinus", "test", "Lio/kotest/matchers/MatcherResult;", "value", "kotest-assertions-core"})
public final class FloatToleranceMatcher
implements Matcher<Float> {
    private final float expected;
    private final float tolerance;

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public MatcherResult test(float value) {
        MatcherResult matcherResult;
        float f = this.expected;
        boolean bl = false;
        if (Float.isNaN(f)) {
            f = value;
            bl = false;
            if (Float.isNaN(f)) {
                String string = "[WARN] By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776";
                bl = false;
                System.out.println((Object)string);
                matcherResult = MatcherResult.Companion.invoke(false, "By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776", "By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
                return matcherResult;
            }
        }
        if (this.tolerance == 0.0f) {
            String string = "[WARN] When comparing Float consider using tolerance, eg: a shouldBe b plusOrMinus c";
            bl = false;
            System.out.println((Object)string);
        }
        float f2 = value - this.expected;
        boolean bl2 = false;
        float diff2 = Math.abs(f2);
        matcherResult = MatcherResult.Companion.invoke(diff2 <= this.tolerance, value + " should be equal to " + this.expected, value + " should not be equal to " + this.expected);
        return matcherResult;
    }

    @NotNull
    public final FloatToleranceMatcher plusOrMinus(float tolerance) {
        return new FloatToleranceMatcher(this.expected, tolerance);
    }

    public FloatToleranceMatcher(float expected, float tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @NotNull
    public <U> Matcher<U> compose(@NotNull Function1<? super U, Float> fn) {
        Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
        return Matcher.DefaultImpls.compose((Matcher)this, fn);
    }

    @NotNull
    public <U> Matcher<U> contramap(@NotNull Function1<? super U, Float> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return Matcher.DefaultImpls.contramap((Matcher)this, f);
    }

    @NotNull
    public Matcher<Float> invert() {
        return Matcher.DefaultImpls.invert((Matcher)this);
    }
}

