/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.future;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.future.MatchersKt;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u001a\u0018\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0003\u001a\u001a\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0003\u001a\u0018\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u0003\u001a\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002\u001a\u0016\u0010\u0010\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002\u001a\u0019\u0010\u0011\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0004\u001a\u0016\u0010\u0012\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0002\u001a\u0019\u0010\u0015\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0004\u00a8\u0006\u0016"}, d2={"cancelled", "Lio/kotest/matchers/Matcher;", "Ljava/util/concurrent/CompletableFuture;", "T", "completeExceptionallyWith", "throwable", "", "completed", "completedExceptionally", "errorMessageForTestFailure", "", "actualException", "expectedException", "shouldBeCancelled", "", "shouldBeCompleted", "shouldBeCompletedExceptionally", "shouldCompleteExceptionallyWith", "shouldNotBeCancelled", "shouldNotBeCompleted", "shouldNotBeCompletedExceptionally", "shouldNotCompleteExceptionallyWith", "kotest-assertions-core"})
public final class MatchersKt {
    public static final <T> void shouldBeCompletedExceptionally(@NotNull CompletableFuture<T> $this$shouldBeCompletedExceptionally) {
        Intrinsics.checkNotNullParameter($this$shouldBeCompletedExceptionally, (String)"$this$shouldBeCompletedExceptionally");
        ShouldKt.shouldBe($this$shouldBeCompletedExceptionally, MatchersKt.completedExceptionally());
    }

    public static final <T> void shouldNotBeCompletedExceptionally(@NotNull CompletableFuture<T> $this$shouldNotBeCompletedExceptionally) {
        Intrinsics.checkNotNullParameter($this$shouldNotBeCompletedExceptionally, (String)"$this$shouldNotBeCompletedExceptionally");
        ShouldKt.shouldNotBe($this$shouldNotBeCompletedExceptionally, MatchersKt.completedExceptionally());
    }

    @NotNull
    public static final <T> Matcher<CompletableFuture<T>> completedExceptionally() {
        return new Matcher<CompletableFuture<T>>(){

            @NotNull
            public MatcherResult test(@NotNull CompletableFuture<T> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return MatcherResult.Companion.invoke(value.isCompletedExceptionally(), "Future should be completed exceptionally", "Future should not be completed exceptionally");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends CompletableFuture<T>> fn) {
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends CompletableFuture<T>> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<CompletableFuture<T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final <T> void shouldBeCompleted(@NotNull CompletableFuture<T> $this$shouldBeCompleted) {
        Intrinsics.checkNotNullParameter($this$shouldBeCompleted, (String)"$this$shouldBeCompleted");
        ShouldKt.shouldBe($this$shouldBeCompleted, MatchersKt.completed());
    }

    public static final <T> void shouldNotBeCompleted(@NotNull CompletableFuture<T> $this$shouldNotBeCompleted) {
        Intrinsics.checkNotNullParameter($this$shouldNotBeCompleted, (String)"$this$shouldNotBeCompleted");
        ShouldKt.shouldNotBe($this$shouldNotBeCompleted, MatchersKt.completed());
    }

    @NotNull
    public static final <T> Matcher<CompletableFuture<T>> completed() {
        return new Matcher<CompletableFuture<T>>(){

            @NotNull
            public MatcherResult test(@NotNull CompletableFuture<T> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDone(), "Future should be completed", "Future should not be completed");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends CompletableFuture<T>> fn) {
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends CompletableFuture<T>> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<CompletableFuture<T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final <T> void shouldBeCancelled(@NotNull CompletableFuture<T> $this$shouldBeCancelled) {
        Intrinsics.checkNotNullParameter($this$shouldBeCancelled, (String)"$this$shouldBeCancelled");
        ShouldKt.shouldBe($this$shouldBeCancelled, MatchersKt.cancelled());
    }

    public static final <T> void shouldNotBeCancelled(@NotNull CompletableFuture<T> $this$shouldNotBeCancelled) {
        Intrinsics.checkNotNullParameter($this$shouldNotBeCancelled, (String)"$this$shouldNotBeCancelled");
        ShouldKt.shouldNotBe($this$shouldNotBeCancelled, MatchersKt.cancelled());
    }

    @NotNull
    public static final <T> Matcher<CompletableFuture<T>> cancelled() {
        return new Matcher<CompletableFuture<T>>(){

            @NotNull
            public MatcherResult test(@NotNull CompletableFuture<T> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return MatcherResult.Companion.invoke(value.isCancelled(), "Future should be completed", "Future should not be completed");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends CompletableFuture<T>> fn) {
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends CompletableFuture<T>> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<CompletableFuture<T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldCompleteExceptionallyWith(@NotNull CompletableFuture<?> $this$shouldCompleteExceptionallyWith, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter($this$shouldCompleteExceptionallyWith, (String)"$this$shouldCompleteExceptionallyWith");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        ShouldKt.should($this$shouldCompleteExceptionallyWith, MatchersKt.completeExceptionallyWith(throwable));
    }

    public static final void shouldNotCompleteExceptionallyWith(@NotNull CompletableFuture<?> $this$shouldNotCompleteExceptionallyWith, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter($this$shouldNotCompleteExceptionallyWith, (String)"$this$shouldNotCompleteExceptionallyWith");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        ShouldKt.shouldNot($this$shouldNotCompleteExceptionallyWith, MatchersKt.completeExceptionallyWith(throwable));
    }

    @NotNull
    public static final Matcher<CompletableFuture<?>> completeExceptionallyWith(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return new Matcher<CompletableFuture<?>>(throwable){
            final /* synthetic */ Throwable $throwable;

            @NotNull
            public MatcherResult test(@NotNull CompletableFuture<?> value) {
                Object object;
                Intrinsics.checkNotNullParameter(value, (String)"value");
                CompletableFuture<?> completableFuture = value;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    CompletableFuture<?> $this$runCatching = completableFuture;
                    boolean bl2 = false;
                    ? obj = $this$runCatching.get();
                    boolean bl3 = false;
                    object = Result.constructor-impl(obj);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Throwable exception = Result.exceptionOrNull-impl((Object)object);
                return MatcherResult.Companion.invoke(exception != null && Intrinsics.areEqual((Object)exception.getCause(), (Object)this.$throwable), (Function0)new Function0<String>(this, exception){
                    final /* synthetic */ completeExceptionallyWith.1 this$0;
                    final /* synthetic */ Throwable $exception;

                    @NotNull
                    public final String invoke() {
                        Throwable throwable = this.$exception;
                        return MatchersKt.errorMessageForTestFailure(throwable != null ? throwable.getCause() : null, this.this$0.$throwable);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$exception = throwable;
                        super(0);
                    }
                }, (Function0)new Function0<String>(exception){
                    final /* synthetic */ Throwable $exception;

                    @NotNull
                    public final String invoke() {
                        Throwable throwable = this.$exception;
                        return "Expected future not to fail with " + (throwable != null ? throwable.getCause() : null) + ", but it did fail with it.";
                    }
                    {
                        this.$exception = throwable;
                        super(0);
                    }
                });
            }
            {
                this.$throwable = $captured_local_variable$0;
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends CompletableFuture<?>> fn) {
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends CompletableFuture<?>> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<CompletableFuture<?>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    @NotNull
    public static final String errorMessageForTestFailure(@Nullable Throwable actualException, @NotNull Throwable expectedException) {
        Intrinsics.checkNotNullParameter((Object)expectedException, (String)"expectedException");
        if (actualException == null) {
            return "Expected future to fail with " + expectedException + ", but it did not failed with any exception";
        }
        return "Expected future to fail with " + expectedException + ", but it failed with " + actualException;
    }
}

