/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.bigdecimal;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.comparables.ComparableMatchersKt;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u001b\u0010\t\u001a\u00020\u0006*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\n\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010\f\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u0006*\u00020\u0002\u001a\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010\u0012\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u001b\u0010\u0016\u001a\u00020\u0006*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0019\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0011H\u0086\u0004\u00a8\u0006\u001a"}, d2={"beInClosedRange", "Lio/kotest/matchers/Matcher;", "Ljava/math/BigDecimal;", "range", "Lkotlin/ranges/ClosedRange;", "shouldBeGreaterThan", "", "other", "shouldBeGreaterThanOrEquals", "shouldBeInRange", "shouldBeLessThan", "shouldBeLessThanOrEquals", "shouldBeNegative", "shouldBePositive", "shouldBeZero", "shouldHavePrecision", "precision", "", "shouldHaveScale", "scale", "shouldNotBeGreaterThan", "shouldNotBeGreaterThanOrEquals", "shouldNotBeInRange", "shouldNotBeLessThan", "shouldNotBeLessThanOrEquals", "shouldNotHaveScale", "kotest-assertions-core"})
public final class MatchersKt {
    public static final void shouldBeZero(@NotNull BigDecimal $this$shouldBeZero) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeZero, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldBeZero, (Object)BigDecimal.ZERO);
    }

    public static final void shouldBePositive(@NotNull BigDecimal $this$shouldBePositive) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBePositive, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldBePositive, ComparableMatchersKt.gte((Comparable)BigDecimal.ZERO));
    }

    public static final void shouldBeNegative(@NotNull BigDecimal $this$shouldBeNegative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeNegative, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldBeNegative, ComparableMatchersKt.lt((Comparable)BigDecimal.ZERO));
    }

    public static final void shouldHavePrecision(@NotNull BigDecimal $this$shouldHavePrecision, int precision) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHavePrecision, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldHavePrecision.precision(), (Object)precision);
    }

    public static final void shouldHaveScale(@NotNull BigDecimal $this$shouldHaveScale, int scale) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveScale, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldHaveScale.scale(), (Object)scale);
    }

    public static final void shouldNotHaveScale(@NotNull BigDecimal $this$shouldNotHaveScale, int scale) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveScale, (String)"<this>");
        ShouldKt.shouldNotBe((Object)$this$shouldNotHaveScale.scale(), (Object)scale);
    }

    public static final void shouldBeLessThan(@NotNull BigDecimal $this$shouldBeLessThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLessThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldBe((Object)$this$shouldBeLessThan, ComparableMatchersKt.lt((Comparable)other));
    }

    public static final void shouldBeLessThanOrEquals(@NotNull BigDecimal $this$shouldBeLessThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLessThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldBe((Object)$this$shouldBeLessThanOrEquals, ComparableMatchersKt.lte((Comparable)other));
    }

    public static final void shouldNotBeLessThan(@NotNull BigDecimal $this$shouldNotBeLessThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLessThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNotBe((Object)$this$shouldNotBeLessThan, ComparableMatchersKt.lt((Comparable)other));
    }

    public static final void shouldNotBeLessThanOrEquals(@NotNull BigDecimal $this$shouldNotBeLessThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLessThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNotBe((Object)$this$shouldNotBeLessThanOrEquals, ComparableMatchersKt.lte((Comparable)other));
    }

    public static final void shouldBeGreaterThan(@NotNull BigDecimal $this$shouldBeGreaterThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeGreaterThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldBe((Object)$this$shouldBeGreaterThan, ComparableMatchersKt.gt((Comparable)other));
    }

    public static final void shouldBeGreaterThanOrEquals(@NotNull BigDecimal $this$shouldBeGreaterThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeGreaterThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldBe((Object)$this$shouldBeGreaterThanOrEquals, ComparableMatchersKt.gte((Comparable)other));
    }

    public static final void shouldNotBeGreaterThan(@NotNull BigDecimal $this$shouldNotBeGreaterThan, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeGreaterThan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNotBe((Object)$this$shouldNotBeGreaterThan, ComparableMatchersKt.gt((Comparable)other));
    }

    public static final void shouldNotBeGreaterThanOrEquals(@NotNull BigDecimal $this$shouldNotBeGreaterThanOrEquals, @NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeGreaterThanOrEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNotBe((Object)$this$shouldNotBeGreaterThanOrEquals, ComparableMatchersKt.gte((Comparable)other));
    }

    public static final void shouldBeInRange(@NotNull BigDecimal $this$shouldBeInRange, @NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        ShouldKt.should((Object)$this$shouldBeInRange, MatchersKt.beInClosedRange(range));
    }

    public static final void shouldNotBeInRange(@NotNull BigDecimal $this$shouldNotBeInRange, @NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeInRange, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        ShouldKt.shouldNot((Object)$this$shouldNotBeInRange, MatchersKt.beInClosedRange(range));
    }

    @NotNull
    public static final Matcher<BigDecimal> beInClosedRange(@NotNull ClosedRange<BigDecimal> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return (Matcher)new Matcher<BigDecimal>(range){
            final /* synthetic */ ClosedRange<BigDecimal> $range;
            {
                this.$range = $range;
            }

            @NotNull
            public MatcherResult test(@NotNull BigDecimal value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.$range.contains((Comparable)value), "Value " + value + " should be in range from " + this.$range.getStart() + " to " + this.$range.getEndInclusive() + " (Inclusive)", "Value " + value + " should not be in range from " + this.$range.getStart() + " to " + this.$range.getEndInclusive() + " (Inclusive)");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends BigDecimal> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends BigDecimal> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<BigDecimal> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }
}

