/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.file;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.paths.PathsKt;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b*\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0002\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0011\u001a\u0012\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!*\u00020\u0002H\u0002\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!*\u00020\u0002H\u0002\u001a\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!*\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0002\u001a\n\u0010%\u001a\u00020&*\u00020\u0002\u001a\n\u0010'\u001a\u00020&*\u00020\u0002\u001a\n\u0010(\u001a\u00020&*\u00020\u0002\u001a\n\u0010)\u001a\u00020&*\u00020\u0002\u001a\n\u0010*\u001a\u00020&*\u00020\u0002\u001a\n\u0010+\u001a\u00020&*\u00020\u0002\u001a\n\u0010,\u001a\u00020&*\u00020\u0002\u001a\n\u0010-\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010.\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010.\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\f\u0010/\u001a\u00020&*\u00020\u0002H\u0007\u001a\n\u00100\u001a\u00020&*\u00020\u0002\u001a\n\u00101\u001a\u00020&*\u00020\u0002\u001a\u0015\u00102\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u00102\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\n\u00103\u001a\u00020&*\u00020\u0002\u001a\n\u00104\u001a\u00020&*\u00020\u0002\u001a\u0015\u00105\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u00106\u001a\u00020&*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\n\u00107\u001a\u00020&*\u00020\u0002\u001a\u0015\u00108\u001a\u00020&*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0015\u00109\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\n\u0010:\u001a\u00020&*\u00020\u0002\u001a\n\u0010;\u001a\u00020&*\u00020\u0002\u001a\n\u0010<\u001a\u00020&*\u00020\u0002\u001a\n\u0010=\u001a\u00020&*\u00020\u0002\u001a\n\u0010>\u001a\u00020&*\u00020\u0002\u001a\n\u0010?\u001a\u00020&*\u00020\u0002\u001a\n\u0010@\u001a\u00020&*\u00020\u0002\u001a\n\u0010A\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010B\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010B\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\f\u0010C\u001a\u00020&*\u00020\u0002H\u0007\u001a\n\u0010D\u001a\u00020&*\u00020\u0002\u001a\n\u0010E\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010F\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010F\u001a\u00020&*\u00020\u00022\u0006\u0010\n\u001a\u00020\u001eH\u0086\u0004\u001a\n\u0010G\u001a\u00020&*\u00020\u0002\u001a\n\u0010H\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010I\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010J\u001a\u00020&*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0086\u0004\u001a\n\u0010K\u001a\u00020&*\u00020\u0002\u001a\u0015\u0010L\u001a\u00020&*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0015\u0010M\u001a\u00020&*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010N\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010N\u001a\u00020&*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u001a\u0015\u0010N\u001a\u00020&*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010N\u001a\u00020&*\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u001a\u0015\u0010O\u001a\u00020&*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010O\u001a\u00020&*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u001a\u0015\u0010O\u001a\u00020&*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010O\u001a\u00020&*\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0004\u00a8\u0006P"}, d2={"aDirectory", "Lio/kotest/matchers/Matcher;", "Ljava/io/File;", "aFile", "beAbsolute", "beCanonicalPath", "beEmptyDirectory", "beExecutable", "beHidden", "beLarger", "other", "beReadable", "beRelative", "beSmaller", "beWriteable", "containFile", "name", "", "containNFiles", "n", "", "emptyFile", "exist", "haveFileSize", "size", "", "haveParent", "startWithPath", "file", "path", "Ljava/nio/file/Path;", "prefix", "safeList", "", "safeListFiles", "filter", "Ljava/io/FileFilter;", "shouldBeADirectory", "", "shouldBeAFile", "shouldBeAbsolute", "shouldBeCanonical", "shouldBeEmpty", "shouldBeEmptyDirectory", "shouldBeExecutable", "shouldBeHidden", "shouldBeLarger", "shouldBeNonEmptyDirectory", "shouldBeReadable", "shouldBeRelative", "shouldBeSmaller", "shouldBeSymbolicLink", "shouldBeWriteable", "shouldContainFile", "shouldContainNFiles", "shouldExist", "shouldHaveFileSize", "shouldHaveParent", "shouldNotBeADirectory", "shouldNotBeAFile", "shouldNotBeAbsolute", "shouldNotBeCanonical", "shouldNotBeEmpty", "shouldNotBeEmptyDirectory", "shouldNotBeExecutable", "shouldNotBeHidden", "shouldNotBeLarger", "shouldNotBeNonEmptyDirectory", "shouldNotBeReadable", "shouldNotBeRelative", "shouldNotBeSmaller", "shouldNotBeSymbolicLink", "shouldNotBeWriteable", "shouldNotContainFile", "shouldNotContainNFiles", "shouldNotExist", "shouldNotHaveFileSize", "shouldNotHaveParent", "shouldNotStartWithPath", "shouldStartWithPath", "kotest-assertions-core"})
public final class MatchersKt {
    private static final List<String> safeList(File $this$safeList) {
        Object[] objectArray = $this$safeList.list();
        List list = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
        return list == null ? CollectionsKt.emptyList() : list;
    }

    private static final List<File> safeListFiles(File $this$safeListFiles) {
        Object[] objectArray = $this$safeListFiles.listFiles();
        List list = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
        return list == null ? CollectionsKt.emptyList() : list;
    }

    private static final List<File> safeListFiles(File $this$safeListFiles, FileFilter filter) {
        Object[] objectArray = $this$safeListFiles.listFiles(filter);
        List list = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @Deprecated(message="checks if a directory is empty", replaceWith=@ReplaceWith(expression="shouldBeEmptyDirectory()", imports={}))
    public static final void shouldBeNonEmptyDirectory(@NotNull File $this$shouldBeNonEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeNonEmptyDirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldBeNonEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    @Deprecated(message="checks if a directory is not empty", replaceWith=@ReplaceWith(expression="shouldNotBeEmptyDirectory()", imports={}))
    public static final void shouldNotBeNonEmptyDirectory(@NotNull File $this$shouldNotBeNonEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeNonEmptyDirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldNotBeNonEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    public static final void shouldBeEmptyDirectory(@NotNull File $this$shouldBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmptyDirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    public static final void shouldNotBeEmptyDirectory(@NotNull File $this$shouldNotBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmptyDirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    @NotNull
    public static final Matcher<File> beEmptyDirectory() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory() && MatchersKt.access$safeList(value).isEmpty(), value + " should be a non empty directory", value + " should not be a non empty directory");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldContainNFiles(@NotNull File $this$shouldContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainNFiles, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldContainNFiles, MatchersKt.containNFiles(n));
    }

    public static final void shouldNotContainNFiles(@NotNull File $this$shouldNotContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainNFiles, (String)"<this>");
        ShouldKt.shouldNotBe((Object)$this$shouldNotContainNFiles, MatchersKt.containNFiles(n));
    }

    @NotNull
    public static final Matcher<File> containNFiles(int n) {
        return (Matcher)new Matcher<File>(n){
            final /* synthetic */ int $n;
            {
                this.$n = $n;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory() && MatchersKt.access$safeList(value).size() == this.$n, value + " should be a directory and contain " + this.$n + " files", value + " should not be a directory containing " + this.$n + " files");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeEmpty(@NotNull File $this$shouldBeEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmpty, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldBeEmpty, MatchersKt.emptyFile());
    }

    public static final void shouldNotBeEmpty(@NotNull File $this$shouldNotBeEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmpty, (String)"<this>");
        ShouldKt.shouldNotBe((Object)$this$shouldNotBeEmpty, MatchersKt.emptyFile());
    }

    @NotNull
    public static final Matcher<File> emptyFile() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == 0L, "File " + value + " should be empty", "File " + value + " should not be empty");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldExist(@NotNull File $this$shouldExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldExist, (String)"<this>");
        ShouldKt.should((Object)$this$shouldExist, MatchersKt.exist());
    }

    public static final void shouldNotExist(@NotNull File $this$shouldNotExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotExist, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotExist, MatchersKt.exist());
    }

    @NotNull
    public static final Matcher<File> exist() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.exists(), "File " + value + " should exist", "File " + value + " should not exist");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldContainFile(@NotNull File $this$shouldContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldContainFile, MatchersKt.containFile(name));
    }

    public static final void shouldNotContainFile(@NotNull File $this$shouldNotContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotContainFile, MatchersKt.containFile(name));
    }

    @NotNull
    public static final Matcher<File> containFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                List contents = MatchersKt.access$safeList(value);
                boolean passed = value.isDirectory() && contents.contains(this.$name);
                return MatcherResult.Companion.invoke(passed, "Directory " + value + " should contain a file with filename " + this.$name + " (detected " + contents.size() + " other files)", "Directory " + value + " should not contain a file with filename " + this.$name);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeSymbolicLink(@NotNull File $this$shouldBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSymbolicLink, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeSymbolicLink.toPath(), PathsKt.beSymbolicLink());
    }

    public static final void shouldNotBeSymbolicLink(@NotNull File $this$shouldNotBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSymbolicLink, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSymbolicLink.toPath(), PathsKt.beSymbolicLink());
    }

    public static final void shouldHaveParent(@NotNull File $this$shouldHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHaveParent, MatchersKt.haveParent(name));
    }

    public static final void shouldNotHaveParent(@NotNull File $this$shouldNotHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveParent, MatchersKt.haveParent(name));
    }

    @NotNull
    public static final Matcher<File> haveParent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            private final boolean isParentEqualExpected(File parent) {
                return parent != null && (Intrinsics.areEqual((Object)parent.getName(), (Object)this.$name) || this.isParentEqualExpected(parent.getParentFile()));
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.isParentEqualExpected(value.getParentFile()), (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should have parent " + this.$name;
                    }
                }, (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ File $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not have parent " + this.$name;
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeADirectory(@NotNull File $this$shouldBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeADirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeADirectory, MatchersKt.aDirectory());
    }

    public static final void shouldNotBeADirectory(@NotNull File $this$shouldNotBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeADirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeADirectory, MatchersKt.aDirectory());
    }

    @NotNull
    public static final Matcher<File> aDirectory() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory(), "File " + value + " should be a directory", "File " + value + " should not be a directory");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeAFile(@NotNull File $this$shouldBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAFile, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeAFile, MatchersKt.aFile());
    }

    public static final void shouldNotBeAFile(@NotNull File $this$shouldNotBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAFile, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAFile, MatchersKt.aFile());
    }

    @NotNull
    public static final Matcher<File> aFile() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isFile(), "File " + value + " should be a file", "File " + value + " should not be a file");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"other.toFile()");
        ShouldKt.should((Object)$this$shouldBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeSmaller, MatchersKt.beSmaller(other));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"other.toFile()");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, MatchersKt.beSmaller(other));
    }

    @NotNull
    public static final Matcher<File> beSmaller(@NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;
            {
                this.$other = $other;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() < this.$other.length(), "File " + value + " (" + sizea + " bytes) should be smaller than " + this.$other + " (" + sizeb + " bytes)", "File " + value + " (" + sizea + " bytes) should not be smaller than " + this.$other + " (" + sizeb + " bytes)");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"other.toFile()");
        ShouldKt.should((Object)$this$shouldBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeLarger, MatchersKt.beLarger(other));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"other.toFile()");
        ShouldKt.shouldNot((Object)$this$shouldNotBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeLarger, MatchersKt.beLarger(other));
    }

    @NotNull
    public static final Matcher<File> beLarger(@NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;
            {
                this.$other = $other;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() > this.$other.length(), "File " + value + " (" + sizea + " bytes) should be larger than " + this.$other + " (" + sizeb + " bytes)", "File " + value + " (" + sizea + " bytes) should not be larger than " + this.$other + " (" + sizeb + " bytes)");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeCanonical(@NotNull File $this$shouldBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeCanonical, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeCanonical, MatchersKt.beCanonicalPath());
    }

    public static final void shouldNotBeCanonical(@NotNull File $this$shouldNotBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeCanonical, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeCanonical, MatchersKt.beCanonicalPath());
    }

    @NotNull
    public static final Matcher<File> beCanonicalPath() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.getCanonicalPath(), (Object)value.getPath()), "File " + value + " should be canonical", "File " + value + " should not be canonical");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeAbsolute(@NotNull File $this$shouldBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAbsolute, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeAbsolute, MatchersKt.beAbsolute());
    }

    public static final void shouldNotBeAbsolute(@NotNull File $this$shouldNotBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAbsolute, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAbsolute, MatchersKt.beAbsolute());
    }

    @NotNull
    public static final Matcher<File> beAbsolute() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isAbsolute(), "File " + value + " should be absolute", "File " + value + " should not be absolute");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeRelative(@NotNull File $this$shouldBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeRelative, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeRelative, MatchersKt.beRelative());
    }

    public static final void shouldNotBeRelative(@NotNull File $this$shouldNotBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeRelative, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeRelative, MatchersKt.beRelative());
    }

    @NotNull
    public static final Matcher<File> beRelative() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(!value.isAbsolute(), "File " + value + " should be relative", "File " + value + " should not be relative");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldHaveFileSize(@NotNull File $this$shouldHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveFileSize, (String)"<this>");
        ShouldKt.should((Object)$this$shouldHaveFileSize, MatchersKt.haveFileSize(size));
    }

    public static final void shouldNotHaveFileSize(@NotNull File $this$shouldNotHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveFileSize, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveFileSize, MatchersKt.haveFileSize(size));
    }

    @NotNull
    public static final Matcher<File> haveFileSize(long size) {
        return (Matcher)new Matcher<File>(size){
            final /* synthetic */ long $size;
            {
                this.$size = $size;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == this.$size, "File " + value + " should have size " + this.$size, "File " + value + " should not have size " + this.$size);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeWriteable(@NotNull File $this$shouldBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeWriteable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeWriteable, MatchersKt.beWriteable());
    }

    public static final void shouldNotBeWriteable(@NotNull File $this$shouldNotBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeWriteable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeWriteable, MatchersKt.beWriteable());
    }

    @NotNull
    public static final Matcher<File> beWriteable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canWrite(), "File " + value + " should be writeable", "File " + value + " should not be writeable");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeExecutable(@NotNull File $this$shouldBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeExecutable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeExecutable, MatchersKt.beExecutable());
    }

    public static final void shouldNotBeExecutable(@NotNull File $this$shouldNotBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeExecutable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeExecutable, MatchersKt.beExecutable());
    }

    @NotNull
    public static final Matcher<File> beExecutable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canExecute(), "File " + value + " should be executable", "File " + value + " should not be executable");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeHidden(@NotNull File $this$shouldBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeHidden, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeHidden, MatchersKt.beHidden());
    }

    public static final void shouldNotBeHidden(@NotNull File $this$shouldNotBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeHidden, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeHidden, MatchersKt.beHidden());
    }

    @NotNull
    public static final Matcher<File> beHidden() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isHidden(), "File " + value + " should be hidden", "File " + value + " should not be hidden");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldBeReadable(@NotNull File $this$shouldBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeReadable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeReadable, MatchersKt.beReadable());
    }

    public static final void shouldNotBeReadable(@NotNull File $this$shouldNotBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeReadable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeReadable, MatchersKt.beReadable());
    }

    @NotNull
    public static final Matcher<File> beReadable() {
        return (Matcher)new Matcher<File>(){

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canRead(), "File " + value + " should be readable", "File " + value + " should not be readable");
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.should((Object)$this$shouldStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should((Object)$this$shouldStartWithPath.toFile(), MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath.toFile(), MatchersKt.startWithPath(path));
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        return MatchersKt.startWithPath(file);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.toString()");
        return MatchersKt.startWithPath(string);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return (Matcher)new Matcher<File>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
            }

            @NotNull
            public MatcherResult test(@NotNull File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.toString()");
                return MatcherResult.Companion.invoke(StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null), "File " + value + " should start with " + this.$prefix, "File " + value + " should not start with " + this.$prefix);
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends File> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends File> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<File> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final /* synthetic */ List access$safeList(File $receiver) {
        return MatchersKt.safeList($receiver);
    }
}

