/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.doubles;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.doubles.Percentage;
import io.kotest.matchers.doubles.ToleranceKt;
import io.kotest.matchers.doubles.ToleranceMatcher;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u001a\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0086\u0004\u001a\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0011"}, d2={"percent", "Lio/kotest/matchers/doubles/Percentage;", "", "getPercent", "(D)Lio/kotest/matchers/doubles/Percentage;", "", "(Ljava/lang/Number;)Lio/kotest/matchers/doubles/Percentage;", "beWithinPercentageOf", "Lio/kotest/matchers/Matcher;", "other", "percentage", "plusOrMinus", "Lio/kotest/matchers/doubles/ToleranceMatcher;", "tolerance", "shouldBeWithinPercentageOf", "", "shouldNotBeWithinPercentageOf", "kotest-assertions-core"})
public final class ToleranceKt {
    @NotNull
    public static final ToleranceMatcher plusOrMinus(double $this$plusOrMinus, double tolerance) {
        double d;
        if (!(tolerance >= 0.0 && !Double.isInfinite(d = tolerance) && !Double.isNaN(d))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new ToleranceMatcher($this$plusOrMinus, tolerance);
    }

    @NotNull
    public static final Percentage getPercent(@NotNull Number $this$percent) {
        Intrinsics.checkNotNullParameter((Object)$this$percent, (String)"<this>");
        return ToleranceKt.getPercent($this$percent.doubleValue());
    }

    @NotNull
    public static final Percentage getPercent(double $this$percent) {
        double d;
        if (!($this$percent >= 0.0 && !Double.isInfinite(d = $this$percent) && !Double.isNaN(d))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new Percentage($this$percent);
    }

    @NotNull
    public static final ToleranceMatcher plusOrMinus(double $this$plusOrMinus, @NotNull Percentage tolerance) {
        Intrinsics.checkNotNullParameter((Object)tolerance, (String)"tolerance");
        double realValue = $this$plusOrMinus * tolerance.getValue() / (double)100;
        return new ToleranceMatcher($this$plusOrMinus, realValue);
    }

    public static final void shouldBeWithinPercentageOf(double $this$shouldBeWithinPercentageOf, double other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.should((Object)$this$shouldBeWithinPercentageOf, ToleranceKt.beWithinPercentageOf(other, percentage));
    }

    public static final void shouldNotBeWithinPercentageOf(double $this$shouldNotBeWithinPercentageOf, double other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.shouldNot((Object)$this$shouldNotBeWithinPercentageOf, ToleranceKt.beWithinPercentageOf(other, percentage));
    }

    @NotNull
    public static final Matcher<Double> beWithinPercentageOf(double other, double percentage) {
        return (Matcher)new Matcher<Double>(other, percentage){
            private final double tolerance;
            @NotNull
            private final ClosedFloatingPointRange<Double> range;
            final /* synthetic */ double $other;
            final /* synthetic */ double $percentage;
            {
                this.$other = $other;
                this.$percentage = $percentage;
                this.tolerance = this.$other * (this.$percentage / (double)100);
                this.range = RangesKt.rangeTo((double)(this.$other - this.tolerance), (double)(this.$other + this.tolerance));
            }

            @NotNull
            public MatcherResult test(double value) {
                return MatcherResult.Companion.invoke(this.range.contains((Comparable)Double.valueOf(value)), (Function0)new Function0<String>(value, this){
                    final /* synthetic */ double $value;
                    final /* synthetic */ beWithinPercentageOf.1 this$0;
                    {
                        this.$value = $value;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$value + " should be in " + beWithinPercentageOf.1.access$getRange$p(this.this$0);
                    }
                }, (Function0)new Function0<String>(value, this){
                    final /* synthetic */ double $value;
                    final /* synthetic */ beWithinPercentageOf.1 this$0;
                    {
                        this.$value = $value;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$value + " should not be in " + beWithinPercentageOf.1.access$getRange$p(this.this$0);
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, Double> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, Double> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Double> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            public static final /* synthetic */ ClosedFloatingPointRange access$getRange$p(beWithinPercentageOf.1 $this) {
                return $this.range;
            }
        };
    }
}

