/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.paths;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.file.MatchersKt;
import io.kotest.matchers.paths.PathsKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u001b\u001a\f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002\u001a\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\u0002\u001a\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015\u001a\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0002\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u0011\u001a\n\u0010 \u001a\u00020!*\u00020\u0002\u001a\n\u0010\"\u001a\u00020!*\u00020\u0002\u001a\n\u0010#\u001a\u00020!*\u00020\u0002\u001a\n\u0010$\u001a\u00020!*\u00020\u0002\u001a\n\u0010%\u001a\u00020!*\u00020\u0002\u001a\n\u0010&\u001a\u00020!*\u00020\u0002\u001a\n\u0010'\u001a\u00020!*\u00020\u0002\u001a\u0015\u0010(\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010(\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\f\u0010)\u001a\u00020!*\u00020\u0002H\u0007\u001a\n\u0010*\u001a\u00020!*\u00020\u0002\u001a\n\u0010+\u001a\u00020!*\u00020\u0002\u001a\u0015\u0010,\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010,\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010-\u001a\u00020!*\u00020\u0002\u001a\n\u0010.\u001a\u00020!*\u00020\u0002\u001a\u0015\u0010/\u001a\u00020!*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u00100\u001a\u00020!*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a#\u00101\u001a\u00020!*\u00020\u00022\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001103\"\u00020\u0011\u00a2\u0006\u0002\u00104\u001a\u0015\u00105\u001a\u00020!*\u00020\u00022\u0006\u00106\u001a\u000207H\u0086\u0004\u001a\n\u00108\u001a\u00020!*\u00020\u0002\u001a\u0015\u00109\u001a\u00020!*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0015\u0010:\u001a\u00020!*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\n\u0010;\u001a\u00020!*\u00020\u0002\u001a\n\u0010<\u001a\u00020!*\u00020\u0002\u001a\n\u0010=\u001a\u00020!*\u00020\u0002\u001a\n\u0010>\u001a\u00020!*\u00020\u0002\u001a\n\u0010?\u001a\u00020!*\u00020\u0002\u001a\n\u0010@\u001a\u00020!*\u00020\u0002\u001a\n\u0010A\u001a\u00020!*\u00020\u0002\u001a\u0015\u0010B\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010B\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\f\u0010C\u001a\u00020!*\u00020\u0002H\u0007\u001a\n\u0010D\u001a\u00020!*\u00020\u0002\u001a\n\u0010E\u001a\u00020!*\u00020\u0002\u001a\u0015\u0010F\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010F\u001a\u00020!*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010G\u001a\u00020!*\u00020\u0002\u001a\n\u0010H\u001a\u00020!*\u00020\u0002\u001a\u0015\u0010I\u001a\u00020!*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010J\u001a\u00020!*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a#\u0010K\u001a\u00020!*\u00020\u00022\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001103\"\u00020\u0011\u00a2\u0006\u0002\u00104\u001a\u0015\u0010L\u001a\u00020!*\u00020\u00022\u0006\u00106\u001a\u000207H\u0086\u0004\u001a\n\u0010M\u001a\u00020!*\u00020\u0002\u001a\u0015\u0010N\u001a\u00020!*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0015\u0010O\u001a\u00020!*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010P\u001a\u00020!*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010P\u001a\u00020!*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010P\u001a\u00020!*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0011H\u0086\u0004\u001a\u0015\u0010Q\u001a\u00020!*\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0004\u001a\u0015\u0010Q\u001a\u00020!*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010Q\u001a\u00020!*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0011H\u0086\u0004\u00a8\u0006R"}, d2={"aDirectory", "Lio/kotest/matchers/Matcher;", "Ljava/nio/file/Path;", "aFile", "beAbsolute", "beCanonicalPath", "beExecutable", "beHidden", "beLarger", "other", "beReadable", "beRelative", "beSmaller", "beSymbolicLink", "beWriteable", "containFile", "name", "", "containFileDeep", "containFiles", "names", "", "exist", "haveFileSize", "size", "", "haveParent", "startWithPath", "file", "Ljava/io/File;", "path", "prefix", "shouldBeADirectory", "", "shouldBeAFile", "shouldBeAbsolute", "shouldBeCanonical", "shouldBeEmptyDirectory", "shouldBeExecutable", "shouldBeHidden", "shouldBeLarger", "shouldBeNonEmptyDirectory", "shouldBeReadable", "shouldBeRelative", "shouldBeSmaller", "shouldBeSymbolicLink", "shouldBeWriteable", "shouldContainFile", "shouldContainFileDeep", "shouldContainFiles", "files", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)V", "shouldContainNFiles", "n", "", "shouldExist", "shouldHaveFileSize", "shouldHaveParent", "shouldNotBeADirectory", "shouldNotBeAFile", "shouldNotBeAbsolute", "shouldNotBeCanonical", "shouldNotBeEmptyDirectory", "shouldNotBeExecutable", "shouldNotBeHidden", "shouldNotBeLarger", "shouldNotBeNonEmptyDirectory", "shouldNotBeReadable", "shouldNotBeRelative", "shouldNotBeSmaller", "shouldNotBeSymbolicLink", "shouldNotBeWriteable", "shouldNotContainFile", "shouldNotContainFileDeep", "shouldNotContainFiles", "shouldNotContainNFiles", "shouldNotExist", "shouldNotHaveFileSize", "shouldNotHaveParent", "shouldNotStartWithPath", "shouldStartWithPath", "kotest-assertions-core"})
public final class PathsKt {
    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.should((Object)$this$shouldStartWithPath, PathsKt.startWithPath(file));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, PathsKt.startWithPath(file));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.should((Object)$this$shouldStartWithPath, PathsKt.startWithPath(prefix));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, PathsKt.startWithPath(prefix));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should((Object)$this$shouldStartWithPath, PathsKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot((Object)$this$shouldNotStartWithPath, PathsKt.startWithPath(path));
    }

    @NotNull
    public static final Matcher<Path> startWithPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return PathsKt.startWithPath(((Object)path).toString());
    }

    @NotNull
    public static final Matcher<Path> startWithPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
        return PathsKt.startWithPath(path);
    }

    @NotNull
    public static final Matcher<Path> startWithPath(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return (Matcher)new Matcher<Path>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
            }

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(StringsKt.startsWith$default((String)((Object)value).toString(), (String)this.$prefix, (boolean)false, (int)2, null), (Function0)new Function0<String>(value, this.$prefix){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ String $prefix;
                    {
                        this.$value = $value;
                        this.$prefix = $prefix;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should start with " + this.$prefix;
                    }
                }, (Function0)new Function0<String>(value, this.$prefix){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ String $prefix;
                    {
                        this.$value = $value;
                        this.$prefix = $prefix;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not start with " + this.$prefix;
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldExist(@NotNull Path $this$shouldExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldExist, (String)"<this>");
        ShouldKt.should((Object)$this$shouldExist, PathsKt.exist());
    }

    public static final void shouldNotExist(@NotNull Path $this$shouldNotExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotExist, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotExist, PathsKt.exist());
    }

    @NotNull
    public static final Matcher<Path> exist() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.exists(value, new LinkOption[0]), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should exist";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not exist";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldHaveFileSize(@NotNull Path $this$shouldHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveFileSize, (String)"<this>");
        ShouldKt.should((Object)$this$shouldHaveFileSize, PathsKt.haveFileSize(size));
    }

    public static final void shouldNotHaveFileSize(@NotNull Path $this$shouldNotHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveFileSize, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveFileSize, PathsKt.haveFileSize(size));
    }

    @NotNull
    public static final Matcher<Path> haveFileSize(long size) {
        return (Matcher)new Matcher<Path>(size){
            final /* synthetic */ long $size;
            {
                this.$size = $size;
            }

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.size(value) == this.$size, (Function0)new Function0<String>(value, this.$size){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ long $size;
                    {
                        this.$value = $value;
                        this.$size = $size;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should have size " + this.$size;
                    }
                }, (Function0)new Function0<String>(value, this.$size){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ long $size;
                    {
                        this.$value = $value;
                        this.$size = $size;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not have size " + this.$size;
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeADirectory(@NotNull Path $this$shouldBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeADirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeADirectory, PathsKt.aDirectory());
    }

    public static final void shouldNotBeADirectory(@NotNull Path $this$shouldNotBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeADirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeADirectory, PathsKt.aDirectory());
    }

    @NotNull
    public static final Matcher<Path> aDirectory() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isDirectory(value, new LinkOption[0]), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be a directory";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be a directory";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeAFile(@NotNull Path $this$shouldBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAFile, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeAFile, PathsKt.aFile());
    }

    public static final void shouldNotBeAFile(@NotNull Path $this$shouldNotBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAFile, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAFile, PathsKt.aFile());
    }

    @NotNull
    public static final Matcher<Path> aFile() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(!Files.isDirectory(value, new LinkOption[0]), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be a directory";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be a directory";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeAbsolute(@NotNull Path $this$shouldBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAbsolute, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeAbsolute, PathsKt.beAbsolute());
    }

    public static final void shouldNotBeAbsolute(@NotNull Path $this$shouldNotBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAbsolute, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeAbsolute, PathsKt.beAbsolute());
    }

    @NotNull
    public static final Matcher<Path> beAbsolute() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isAbsolute(), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should be absolute";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not be absolute";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeRelative(@NotNull Path $this$shouldBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeRelative, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeRelative, PathsKt.beRelative());
    }

    public static final void shouldNotBeRelative(@NotNull Path $this$shouldNotBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeRelative, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeRelative, PathsKt.beRelative());
    }

    @NotNull
    public static final Matcher<Path> beRelative() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(!value.isAbsolute(), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should be relative";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not be relative";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeReadable(@NotNull Path $this$shouldBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeReadable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeReadable, PathsKt.beReadable());
    }

    public static final void shouldNotBeReadable(@NotNull Path $this$shouldNotBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeReadable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeReadable, PathsKt.beReadable());
    }

    @NotNull
    public static final Matcher<Path> beReadable() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isReadable(value), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should be readable";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not be readable";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeWriteable(@NotNull Path $this$shouldBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeWriteable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeWriteable, PathsKt.beWriteable());
    }

    public static final void shouldNotBeWriteable(@NotNull Path $this$shouldNotBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeWriteable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeWriteable, PathsKt.beWriteable());
    }

    @NotNull
    public static final Matcher<Path> beWriteable() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isWritable(value), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should be writeable";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not be writeable";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeExecutable(@NotNull Path $this$shouldBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeExecutable, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeExecutable, PathsKt.beExecutable());
    }

    public static final void shouldNotBeExecutable(@NotNull Path $this$shouldNotBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeExecutable, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeExecutable, PathsKt.beExecutable());
    }

    @NotNull
    public static final Matcher<Path> beExecutable() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isExecutable(value), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should be executable";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not be executable";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldContainNFiles(@NotNull Path $this$shouldContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainNFiles, (String)"<this>");
        ShouldKt.shouldBe((Object)$this$shouldContainNFiles.toFile(), MatchersKt.containNFiles(n));
    }

    public static final void shouldNotContainNFiles(@NotNull Path $this$shouldNotContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainNFiles, (String)"<this>");
        ShouldKt.shouldNotBe((Object)$this$shouldNotContainNFiles.toFile(), MatchersKt.containNFiles(n));
    }

    @Deprecated(message="checks if a directory is empty. Deprecated since 4.3.", replaceWith=@ReplaceWith(expression="shouldBeEmptyDirectory()", imports={}))
    public static final void shouldBeNonEmptyDirectory(@NotNull Path $this$shouldBeNonEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeNonEmptyDirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldBeNonEmptyDirectory.toFile(), MatchersKt.beEmptyDirectory());
    }

    @Deprecated(message="checks if a directory is not empty. Deprecated since 4.3.", replaceWith=@ReplaceWith(expression="shouldBeNonEmptyDirectory()", imports={}))
    public static final void shouldNotBeNonEmptyDirectory(@NotNull Path $this$shouldNotBeNonEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeNonEmptyDirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldNotBeNonEmptyDirectory.toFile(), MatchersKt.beEmptyDirectory());
    }

    public static final void shouldBeEmptyDirectory(@NotNull Path $this$shouldBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmptyDirectory, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeEmptyDirectory.toFile(), MatchersKt.beEmptyDirectory());
    }

    public static final void shouldNotBeEmptyDirectory(@NotNull Path $this$shouldNotBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmptyDirectory, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeEmptyDirectory.toFile(), MatchersKt.beEmptyDirectory());
    }

    public static final void shouldBeHidden(@NotNull Path $this$shouldBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeHidden, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeHidden, PathsKt.beHidden());
    }

    public static final void shouldNotBeHidden(@NotNull Path $this$shouldNotBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeHidden, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeHidden, PathsKt.beHidden());
    }

    @NotNull
    public static final Matcher<Path> beHidden() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isHidden(value), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should be hidden";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not be hidden";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeCanonical(@NotNull Path $this$shouldBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeCanonical, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeCanonical, PathsKt.beCanonicalPath());
    }

    public static final void shouldNotBeCanonical(@NotNull Path $this$shouldNotBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeCanonical, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeCanonical, PathsKt.beCanonicalPath());
    }

    @NotNull
    public static final Matcher<Path> beCanonicalPath() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.toFile().getCanonicalPath(), (Object)value.toFile().getPath()), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should be canonical";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "File " + this.$value + " should not be canonical";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldContainFile(@NotNull Path $this$shouldContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldContainFile, PathsKt.containFile(name));
    }

    public static final void shouldNotContainFile(@NotNull Path $this$shouldNotContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotContainFile, PathsKt.containFile(name));
    }

    @NotNull
    public static final Matcher<Path> containFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<Path>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Stream<String> stream = Files.list(value).map(containFile.1::test$lambda-0);
                Intrinsics.checkNotNullExpressionValue(stream, (String)"list(value).map { it.fileName.toString() }");
                List contents = StreamsKt.toList(stream);
                boolean passed = Files.isDirectory(value, new LinkOption[0]) && contents.contains(this.$name);
                return MatcherResult.Companion.invoke(passed, (Function0)new Function0<String>(value, this.$name, (List<String>)contents){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ String $name;
                    final /* synthetic */ List<String> $contents;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        this.$contents = $contents;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Directory " + this.$value + " should contain a file with filename " + this.$name + " (detected " + this.$contents.size() + " other files)";
                    }
                }, (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Directory " + this.$value + " should not contain a file with filename " + this.$name;
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda-0(Path it) {
                return ((Object)it.getFileName()).toString();
            }
        };
    }

    public static final void shouldBeLarger(@NotNull Path $this$shouldBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = $this$shouldBeLarger.toFile();
        File file2 = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"other.toFile()");
        ShouldKt.should((Object)file, MatchersKt.beLarger(file2));
    }

    public static final void shouldBeLarger(@NotNull Path $this$shouldBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeLarger.toFile(), MatchersKt.beLarger(other));
    }

    public static final void shouldNotBeLarger(@NotNull Path $this$shouldNotBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = $this$shouldNotBeLarger.toFile();
        File file2 = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"other.toFile()");
        ShouldKt.shouldNot((Object)file, MatchersKt.beLarger(file2));
    }

    public static final void shouldNotBeLarger(@NotNull Path $this$shouldNotBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeLarger.toFile(), MatchersKt.beLarger(other));
    }

    @NotNull
    public static final Matcher<Path> beLarger(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<Path>(other){
            final /* synthetic */ Path $other;
            {
                this.$other = $other;
            }

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = Files.size(value);
                long sizeb = Files.size(this.$other);
                return MatcherResult.Companion.invoke(sizea > sizeb, (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ Path $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " (" + this.$sizea + " bytes) should be larger than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                }, (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ Path $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " (" + this.$sizea + " bytes) should not be larger than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldBeSmaller(@NotNull Path $this$shouldBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeSmaller, PathsKt.beSmaller(other));
    }

    public static final void shouldBeSmaller(@NotNull Path $this$shouldBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = other.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"other.toPath()");
        ShouldKt.should((Object)$this$shouldBeSmaller, PathsKt.beSmaller(path));
    }

    public static final void shouldNotBeSmaller(@NotNull Path $this$shouldNotBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, PathsKt.beSmaller(other));
    }

    public static final void shouldNotBeSmaller(@NotNull Path $this$shouldNotBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Path path = other.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"other.toPath()");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSmaller, PathsKt.beSmaller(path));
    }

    @NotNull
    public static final Matcher<Path> beSmaller(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<Path>(other){
            final /* synthetic */ Path $other;
            {
                this.$other = $other;
            }

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = Files.size(value);
                long sizeb = Files.size(this.$other);
                return MatcherResult.Companion.invoke(sizea < sizeb, (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ Path $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " (" + this.$sizea + " bytes) should be smaller than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                }, (Function0)new Function0<String>(value, sizea, this.$other, sizeb){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ long $sizea;
                    final /* synthetic */ Path $other;
                    final /* synthetic */ long $sizeb;
                    {
                        this.$value = $value;
                        this.$sizea = $sizea;
                        this.$other = $other;
                        this.$sizeb = $sizeb;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " (" + this.$sizea + " bytes) should not be smaller than " + this.$other + " (" + this.$sizeb + " bytes)";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldContainFileDeep(@NotNull Path $this$shouldContainFileDeep, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFileDeep, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldContainFileDeep, PathsKt.containFileDeep(name));
    }

    public static final void shouldNotContainFileDeep(@NotNull Path $this$shouldNotContainFileDeep, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFileDeep, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotContainFileDeep, PathsKt.containFileDeep(name));
    }

    @NotNull
    public static final Matcher<Path> containFileDeep(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<Path>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean fileExists(Path dir) {
                Path p0;
                void $this$mapTo$iv$iv;
                Pair pair = Files.list(dir);
                Intrinsics.checkNotNullExpressionValue(pair, (String)"list(dir)");
                List contents = StreamsKt.toList(pair);
                Iterable $this$partition$iv = contents;
                boolean $i$f$partition = false;
                ArrayList<T> first$iv = new ArrayList<T>();
                ArrayList<T> second$iv = new ArrayList<T>();
                for (T element$iv : $this$partition$iv) {
                    Path it = (Path)element$iv;
                    boolean bl = false;
                    if (Files.isDirectory(it, new LinkOption[0])) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                pair = new Pair(first$iv, second$iv);
                List dirs = (List)pair.component1();
                List files = (List)pair.component2();
                Iterable $this$map$iv = files;
                boolean $i$f$map = false;
                Iterator<T> iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)it.getFileName()).toString());
                }
                if (((List)destination$iv$iv).contains(this.$name)) return true;
                Iterable $this$any$iv = dirs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                iterator = $this$any$iv.iterator();
                do {
                    T element$iv;
                    if (!iterator.hasNext()) return false;
                    element$iv = iterator.next();
                    p0 = (Path)element$iv;
                    boolean bl = false;
                } while (!this.fileExists(p0));
                return true;
            }

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.fileExists(value), (Function0)new Function0<String>(this.$name, value){
                    final /* synthetic */ String $name;
                    final /* synthetic */ Path $value;
                    {
                        this.$name = $name;
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$name + " should exist in " + this.$value;
                    }
                }, (Function0)new Function0<String>(this.$name, value){
                    final /* synthetic */ String $name;
                    final /* synthetic */ Path $value;
                    {
                        this.$name = $name;
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$name + " should not exist in " + this.$value;
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldContainFiles(@NotNull Path $this$shouldContainFiles, String ... files) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        ShouldKt.should((Object)$this$shouldContainFiles, PathsKt.containFiles(ArraysKt.asList((Object[])files)));
    }

    public static final void shouldNotContainFiles(@NotNull Path $this$shouldNotContainFiles, String ... files) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        ShouldKt.shouldNot((Object)$this$shouldNotContainFiles, PathsKt.containFiles(ArraysKt.asList((Object[])files)));
    }

    @NotNull
    public static final Matcher<Path> containFiles(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return (Matcher)new Matcher<Path>(names){
            final /* synthetic */ List<String> $names;
            {
                this.$names = $names;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public MatcherResult test(@NotNull Path value) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Stream<Path> stream = Files.list(value);
                Intrinsics.checkNotNullExpressionValue(stream, (String)"list(value)");
                Iterable $this$map$iv = StreamsKt.toList(stream);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)it.getFileName()).toString());
                }
                List files = (List)destination$iv$iv;
                Set existingFiles = CollectionsKt.intersect((Iterable)this.$names, (Iterable)files);
                Set nonExistingFiles = CollectionsKt.subtract((Iterable)this.$names, (Iterable)existingFiles);
                return MatcherResult.Companion.invoke(nonExistingFiles.isEmpty(), (Function0)new Function0<String>(this, value, (Set<String>)nonExistingFiles){
                    final /* synthetic */ containFiles.1 this$0;
                    final /* synthetic */ Path $value;
                    final /* synthetic */ Set<String> $nonExistingFiles;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        this.$nonExistingFiles = $nonExistingFiles;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return containFiles.1.access$buildMessage(this.this$0, this.$value, this.$nonExistingFiles, false);
                    }
                }, (Function0)new Function0<String>(this, value, (Set<String>)existingFiles){
                    final /* synthetic */ containFiles.1 this$0;
                    final /* synthetic */ Path $value;
                    final /* synthetic */ Set<String> $existingFiles;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        this.$existingFiles = $existingFiles;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return containFiles.1.access$buildMessage(this.this$0, this.$value, this.$existingFiles, true);
                    }
                });
            }

            private final String buildMessage(Path path, Set<String> fileList, boolean isNegative) {
                String fileString = fileList.size() > 1 ? "Files" : "File";
                String negativeWord = isNegative ? " not" : "";
                String filesString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)fileList), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                return fileString + ' ' + filesString + " should" + negativeWord + " exist in " + path;
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            public static final /* synthetic */ String access$buildMessage(containFiles.1 $this, Path path, Set fileList, boolean isNegative) {
                return $this.buildMessage(path, fileList, isNegative);
            }
        };
    }

    public static final void shouldBeSymbolicLink(@NotNull Path $this$shouldBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSymbolicLink, (String)"<this>");
        ShouldKt.should((Object)$this$shouldBeSymbolicLink, PathsKt.beSymbolicLink());
    }

    public static final void shouldNotBeSymbolicLink(@NotNull Path $this$shouldNotBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSymbolicLink, (String)"<this>");
        ShouldKt.shouldNot((Object)$this$shouldNotBeSymbolicLink, PathsKt.beSymbolicLink());
    }

    @NotNull
    public static final Matcher<Path> beSymbolicLink() {
        return (Matcher)new Matcher<Path>(){

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Files.isSymbolicLink(value), (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should be a symbolic link";
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ Path $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not be a symbolic link";
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    public static final void shouldHaveParent(@NotNull Path $this$shouldHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should((Object)$this$shouldHaveParent, PathsKt.haveParent(name));
    }

    public static final void shouldNotHaveParent(@NotNull Path $this$shouldNotHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot((Object)$this$shouldNotHaveParent, PathsKt.haveParent(name));
    }

    @NotNull
    public static final Matcher<Path> haveParent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<Path>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            private final boolean isParentEqualExpected(Path parent) {
                if (parent == null) {
                    return false;
                }
                Path path = parent.getFileName();
                return Intrinsics.areEqual((Object)(path == null ? null : ((Object)path).toString()), (Object)this.$name) || this.isParentEqualExpected(parent.getParent());
            }

            @NotNull
            public MatcherResult test(@NotNull Path value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.isParentEqualExpected(value.getParent()), (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should have parent " + this.$name;
                    }
                }, (Function0)new Function0<String>(value, this.$name){
                    final /* synthetic */ Path $value;
                    final /* synthetic */ String $name;
                    {
                        this.$value = $value;
                        this.$name = $name;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Path " + this.$value + " should not have parent " + this.$name;
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Path> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Path> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Path> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }
}

