/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.collections;

import io.kotest.assertions.ErrorCollectionMode;
import io.kotest.assertions.ErrorCollector;
import io.kotest.assertions.jvmerrorcollector;
import io.kotest.assertions.print.PrintKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherKt;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.collections.CollectionMatchersKt;
import io.kotest.matchers.collections.SizeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\u001a\"\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004\u001aK\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00060\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u0007\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\n0\t0\b\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000b\u001a4\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00060\u0001\"\u0004\b\u0000\u0010\u00032\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\n0\t0\u0002\u001a \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00060\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u001aK\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00060\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u0011\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t0\b\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t\u00a2\u0006\u0002\u0010\u000b\u001a4\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00060\u0001\"\u0004\b\u0000\u0010\u00032\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t0\u0002\u001aK\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00060\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u0011\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t0\b\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t\u00a2\u0006\u0002\u0010\u000b\u001a<\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00060\u0001\"\u0004\b\u0000\u0010\u00032\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t0\u00022\u0006\u0010\u0015\u001a\u00020\n\u001aK\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00060\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u0011\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t0\b\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00120\t\u00a2\u0006\u0002\u0010\u000b\u001a,\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00060\u0001\"\u0004\b\u0000\u0010\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\n0\t\u001a%\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00060\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\u0019\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u001a\u001a\"\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u0004\u00a8\u0006\u001c"}, d2={"beSorted", "Lio/kotest/matchers/Matcher;", "", "T", "", "existInOrder", "", "ps", "", "Lkotlin/Function1;", "", "([Lkotlin/jvm/functions/Function1;)Lio/kotest/matchers/Matcher;", "predicates", "haveSize", "size", "", "matchEach", "fns", "", "assertions", "matchInOrder", "allowGaps", "matchInOrderSubset", "singleElement", "p", "t", "(Ljava/lang/Object;)Lio/kotest/matchers/Matcher;", "sorted", "kotest-assertions-core"})
public final class CollectionMatchersKt {
    @NotNull
    public static final <T> Matcher<Collection<? extends T>> existInOrder(Function1<? super T, Boolean> ... ps) {
        Intrinsics.checkNotNullParameter(ps, (String)"ps");
        return CollectionMatchersKt.existInOrder(ArraysKt.asList((Object[])ps));
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> existInOrder(@NotNull List<? extends Function1<? super T, Boolean>> predicates2) {
        Intrinsics.checkNotNullParameter(predicates2, (String)"predicates");
        return MatcherKt.neverNullMatcher((Function1)new Function1<Collection<? extends T>, MatcherResult>(predicates2){
            final /* synthetic */ List<Function1<T, Boolean>> $predicates;
            {
                this.$predicates = $predicates;
                super(1);
            }

            @NotNull
            public final MatcherResult invoke(@NotNull Collection<? extends T> actual) {
                Intrinsics.checkNotNullParameter(actual, (String)"actual");
                if (!(!((Collection)this.$predicates).isEmpty())) {
                    boolean $i$a$-require-CollectionMatchersKt$existInOrder$1$22 = false;
                    String $i$a$-require-CollectionMatchersKt$existInOrder$1$22 = "predicates must not be empty";
                    throw new IllegalArgumentException($i$a$-require-CollectionMatchersKt$existInOrder$1$22.toString());
                }
                int subsequenceIndex = 0;
                Iterator<T> actualIterator = actual.iterator();
                while (actualIterator.hasNext() && subsequenceIndex < this.$predicates.size()) {
                    if (!((Boolean)this.$predicates.get(subsequenceIndex).invoke(actualIterator.next())).booleanValue()) continue;
                    ++subsequenceIndex;
                }
                return MatcherResult.Companion.invoke(subsequenceIndex == this.$predicates.size(), (Function0)new Function0<String>(actual, this.$predicates){
                    final /* synthetic */ Collection<T> $actual;
                    final /* synthetic */ List<Function1<T, Boolean>> $predicates;
                    {
                        this.$actual = $actual;
                        this.$predicates = $predicates;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return PrintKt.print(this.$actual).getValue() + " did not match the predicates " + PrintKt.print(this.$predicates).getValue() + " in order";
                    }
                }, (Function0)new Function0<String>(actual, this.$predicates){
                    final /* synthetic */ Collection<T> $actual;
                    final /* synthetic */ List<Function1<T, Boolean>> $predicates;
                    {
                        this.$actual = $actual;
                        this.$predicates = $predicates;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return PrintKt.print(this.$actual).getValue() + " should not match the predicates " + PrintKt.print(this.$predicates).getValue() + " in order";
                    }
                });
            }
        });
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> haveSize(int size) {
        return SizeKt.haveSizeMatcher(size);
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> singleElement(T t2) {
        return new Matcher<Collection<? extends T>>(t2){
            final /* synthetic */ T $t;
            {
                this.$t = $t;
            }

            @NotNull
            public MatcherResult test(@NotNull Collection<? extends T> value) {
                Intrinsics.checkNotNullParameter(value, (String)"value");
                return MatcherResult.Companion.invoke(value.size() == 1 && Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)value), this.$t), (Function0)new Function0<String>(this.$t, value){
                    final /* synthetic */ T $t;
                    final /* synthetic */ Collection<T> $value;
                    {
                        this.$t = $t;
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Collection should be a single element of " + this.$t + " but has " + this.$value.size() + " elements: " + PrintKt.print(this.$value).getValue();
                    }
                }, (Function0)new Function0<String>(this.$t){
                    final /* synthetic */ T $t;
                    {
                        this.$t = $t;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return Intrinsics.stringPlus((String)"Collection should not be a single element of ", this.$t);
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Collection<? extends T>> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Collection<? extends T>> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Collection<? extends T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> singleElement(@NotNull Function1<? super T, Boolean> p) {
        Intrinsics.checkNotNullParameter(p, (String)"p");
        return new Matcher<Collection<? extends T>>(p){
            final /* synthetic */ Function1<T, Boolean> $p;
            {
                this.$p = $p;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public MatcherResult test(@NotNull Collection<? extends T> value) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(value, (String)"value");
                Iterable iterable = value;
                Function1<T, Boolean> predicate$iv = this.$p;
                boolean $i$f$filter = false;
                void var6_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredValue = (List)destination$iv$iv;
                return MatcherResult.Companion.invoke(filteredValue.size() == 1, (Function0)new Function0<String>(filteredValue, value){
                    final /* synthetic */ List<T> $filteredValue;
                    final /* synthetic */ Collection<T> $value;
                    {
                        this.$filteredValue = $filteredValue;
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Collection should have a single element by a given predicate but has " + this.$filteredValue.size() + " elements: " + PrintKt.print(this.$value).getValue();
                    }
                }, (Function0)singleElement.test.2.INSTANCE);
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends Collection<? extends T>> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends Collection<? extends T>> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<Collection<? extends T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<? extends T>> beSorted() {
        return CollectionMatchersKt.sorted();
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<? extends T>> sorted() {
        return new Matcher<List<? extends T>>(){

            @NotNull
            public MatcherResult test(@NotNull List<? extends T> value) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    Iterable $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)value);
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        IndexedValue $dstr$i$it = (IndexedValue)element$iv;
                        boolean bl = false;
                        int i = $dstr$i$it.component1();
                        Comparable it = (Comparable)$dstr$i$it.component2();
                        if (!(i != CollectionsKt.getLastIndex(value) && it.compareTo(value.get(i + 1)) > 0)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                IndexedValue failure2 = v0;
                String elementMessage = failure2 == null ? "" : ". Element " + failure2.getValue() + " at index " + failure2.getIndex() + " was greater than element " + value.get(failure2.getIndex() + 1);
                return MatcherResult.Companion.invoke(failure2 == null, (Function0)new Function0<String>(value, elementMessage){
                    final /* synthetic */ List<T> $value;
                    final /* synthetic */ String $elementMessage;
                    {
                        this.$value = $value;
                        this.$elementMessage = $elementMessage;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "List " + PrintKt.print(this.$value).getValue() + " should be sorted" + this.$elementMessage;
                    }
                }, (Function0)new Function0<String>(value){
                    final /* synthetic */ List<T> $value;
                    {
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "List " + PrintKt.print(this.$value).getValue() + " should not be sorted";
                    }
                });
            }

            @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, ? extends List<? extends T>> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, ? extends List<? extends T>> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<List<? extends T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            @NotNull
            public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchEach(Function1<? super T, Unit> ... fns) {
        Intrinsics.checkNotNullParameter(fns, (String)"fns");
        return CollectionMatchersKt.matchEach(ArraysKt.asList((Object[])fns));
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchInOrder(Function1<? super T, Unit> ... fns) {
        Intrinsics.checkNotNullParameter(fns, (String)"fns");
        return CollectionMatchersKt.matchInOrder(ArraysKt.asList((Object[])fns), false);
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchInOrderSubset(Function1<? super T, Unit> ... fns) {
        Intrinsics.checkNotNullParameter(fns, (String)"fns");
        return CollectionMatchersKt.matchInOrder(ArraysKt.asList((Object[])fns), true);
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchInOrder(@NotNull List<? extends Function1<? super T, Unit>> assertions, boolean allowGaps) {
        Intrinsics.checkNotNullParameter(assertions, (String)"assertions");
        return MatcherKt.neverNullMatcher((Function1)new Function1<Collection<? extends T>, MatcherResult>(assertions, allowGaps){
            final /* synthetic */ List<Function1<T, Unit>> $assertions;
            final /* synthetic */ boolean $allowGaps;
            {
                this.$assertions = $assertions;
                this.$allowGaps = $allowGaps;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final MatcherResult invoke(@NotNull Collection<? extends T> actual) {
                MatcherResult matcherResult;
                Intrinsics.checkNotNullParameter(actual, (String)"actual");
                ErrorCollectionMode originalMode = jvmerrorcollector.getErrorCollector().getCollectionMode();
                try {
                    List actualAsList = CollectionsKt.toList((Iterable)actual);
                    boolean allPassed = false;
                    Ref.ObjectRef bestResult = new Ref.ObjectRef();
                    int n = 0;
                    int n2 = actual.size() - this.$assertions.size();
                    if (n <= n2) {
                        int startIndex;
                        block5: do {
                            startIndex = n++;
                            int elementsPassed = 0;
                            int elementsTested = 0;
                            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J(\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"io/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetProblem", "", "atIndex", "", "problem", "", "(ILjava/lang/String;)V", "getAtIndex", "()I", "getProblem", "()Ljava/lang/String;", "component1", "component2", "copy", "(ILjava/lang/String;)Lio/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetProblem;", "equals", "", "other", "hashCode", "toString", "kotest-assertions-core"})
                            public final class MatchInOrderSubsetProblem {
                                private final int atIndex;
                                @NotNull
                                private final String problem;

                                public MatchInOrderSubsetProblem(int atIndex, @NotNull String problem) {
                                    Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                                    this.atIndex = atIndex;
                                    this.problem = problem;
                                }

                                public final int getAtIndex() {
                                    return this.atIndex;
                                }

                                @NotNull
                                public final String getProblem() {
                                    return this.problem;
                                }

                                public final int component1() {
                                    return this.atIndex;
                                }

                                @NotNull
                                public final String component2() {
                                    return this.problem;
                                }

                                @NotNull
                                public final MatchInOrderSubsetProblem copy(int atIndex, @NotNull String problem) {
                                    Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                                    return new MatchInOrderSubsetProblem(atIndex, problem);
                                }

                                public static /* synthetic */ MatchInOrderSubsetProblem copy$default(MatchInOrderSubsetProblem matchInOrderSubsetProblem, int n, String string, int n2, Object object) {
                                    if ((n2 & 1) != 0) {
                                        n = matchInOrderSubsetProblem.atIndex;
                                    }
                                    if ((n2 & 2) != 0) {
                                        string = matchInOrderSubsetProblem.problem;
                                    }
                                    return matchInOrderSubsetProblem.copy(n, string);
                                }

                                @NotNull
                                public String toString() {
                                    return "MatchInOrderSubsetProblem(atIndex=" + this.atIndex + ", problem=" + this.problem + ')';
                                }

                                public int hashCode() {
                                    int result = Integer.hashCode(this.atIndex);
                                    result = result * 31 + this.problem.hashCode();
                                    return result;
                                }

                                public boolean equals(@Nullable Object other) {
                                    if (this == other) {
                                        return true;
                                    }
                                    if (!(other instanceof MatchInOrderSubsetProblem)) {
                                        return false;
                                    }
                                    MatchInOrderSubsetProblem matchInOrderSubsetProblem = (MatchInOrderSubsetProblem)other;
                                    if (this.atIndex != matchInOrderSubsetProblem.atIndex) {
                                        return false;
                                    }
                                    return Intrinsics.areEqual((Object)this.problem, (Object)matchInOrderSubsetProblem.problem);
                                }
                            }
                            ArrayList<MatchInOrderSubsetProblem> currentProblems = new ArrayList<MatchInOrderSubsetProblem>();
                            while (startIndex + elementsTested < actual.size()) {
                                int n3;
                                Object object;
                                @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0007\b\u008a\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006H\u00c6\u0003J>\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"io/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetResult", "", "startIndex", "", "elementsPassed", "problems", "", "io/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetProblem", "(IILjava/util/List;)V", "getElementsPassed", "()I", "getProblems", "()Ljava/util/List;", "getStartIndex", "component1", "component2", "component3", "copy", "(IILjava/util/List;)Lio/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetResult;", "equals", "", "other", "hashCode", "toString", "", "kotest-assertions-core"})
                                public final class MatchInOrderSubsetResult {
                                    private final int startIndex;
                                    private final int elementsPassed;
                                    @NotNull
                                    private final List<MatchInOrderSubsetProblem> problems;

                                    public MatchInOrderSubsetResult(int startIndex, int elementsPassed, @NotNull List<MatchInOrderSubsetProblem> problems) {
                                        Intrinsics.checkNotNullParameter(problems, (String)"problems");
                                        this.startIndex = startIndex;
                                        this.elementsPassed = elementsPassed;
                                        this.problems = problems;
                                    }

                                    public final int getStartIndex() {
                                        return this.startIndex;
                                    }

                                    public final int getElementsPassed() {
                                        return this.elementsPassed;
                                    }

                                    @NotNull
                                    public final List<MatchInOrderSubsetProblem> getProblems() {
                                        return this.problems;
                                    }

                                    public final int component1() {
                                        return this.startIndex;
                                    }

                                    public final int component2() {
                                        return this.elementsPassed;
                                    }

                                    @NotNull
                                    public final List<MatchInOrderSubsetProblem> component3() {
                                        return this.problems;
                                    }

                                    @NotNull
                                    public final MatchInOrderSubsetResult copy(int startIndex, int elementsPassed, @NotNull List<MatchInOrderSubsetProblem> problems) {
                                        Intrinsics.checkNotNullParameter(problems, (String)"problems");
                                        return new MatchInOrderSubsetResult(startIndex, elementsPassed, problems);
                                    }

                                    public static /* synthetic */ MatchInOrderSubsetResult copy$default(MatchInOrderSubsetResult matchInOrderSubsetResult, int n, int n2, List list, int n3, Object object) {
                                        if ((n3 & 1) != 0) {
                                            n = matchInOrderSubsetResult.startIndex;
                                        }
                                        if ((n3 & 2) != 0) {
                                            n2 = matchInOrderSubsetResult.elementsPassed;
                                        }
                                        if ((n3 & 4) != 0) {
                                            list = matchInOrderSubsetResult.problems;
                                        }
                                        return matchInOrderSubsetResult.copy(n, n2, list);
                                    }

                                    @NotNull
                                    public String toString() {
                                        return "MatchInOrderSubsetResult(startIndex=" + this.startIndex + ", elementsPassed=" + this.elementsPassed + ", problems=" + this.problems + ')';
                                    }

                                    public int hashCode() {
                                        int result = Integer.hashCode(this.startIndex);
                                        result = result * 31 + Integer.hashCode(this.elementsPassed);
                                        result = result * 31 + ((Object)this.problems).hashCode();
                                        return result;
                                    }

                                    public boolean equals(@Nullable Object other) {
                                        if (this == other) {
                                            return true;
                                        }
                                        if (!(other instanceof MatchInOrderSubsetResult)) {
                                            return false;
                                        }
                                        MatchInOrderSubsetResult matchInOrderSubsetResult = (MatchInOrderSubsetResult)other;
                                        if (this.startIndex != matchInOrderSubsetResult.startIndex) {
                                            return false;
                                        }
                                        if (this.elementsPassed != matchInOrderSubsetResult.elementsPassed) {
                                            return false;
                                        }
                                        return Intrinsics.areEqual(this.problems, matchInOrderSubsetResult.problems);
                                    }
                                }
                                if (bestResult.element == null || elementsPassed > ((MatchInOrderSubsetResult)bestResult.element).getElementsPassed()) {
                                    bestResult.element = new MatchInOrderSubsetResult(startIndex, elementsPassed, (List<MatchInOrderSubsetProblem>)currentProblems);
                                }
                                if (!this.$allowGaps && elementsTested > elementsPassed) continue block5;
                                List<Function1<T, Unit>> list = this.$assertions;
                                try {
                                    boolean bl = false;
                                    list.get(elementsPassed).invoke(actualAsList.get(startIndex + elementsTested));
                                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable throwable) {
                                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                                Object elementResult = object;
                                if (Result.isSuccess-impl((Object)elementResult)) {
                                    n3 = elementsPassed;
                                    elementsPassed = n3 + 1;
                                    currentProblems.clear();
                                    if (elementsPassed == this.$assertions.size()) {
                                        allPassed = true;
                                        continue block5;
                                    }
                                } else {
                                    Throwable throwable = Result.exceptionOrNull-impl((Object)elementResult);
                                    Intrinsics.checkNotNull((Object)throwable);
                                    String string = throwable.getMessage();
                                    Intrinsics.checkNotNull((Object)string);
                                    currentProblems.add(new MatchInOrderSubsetProblem(startIndex + elementsTested, string));
                                }
                                n3 = elementsTested;
                                elementsTested = n3 + 1;
                            }
                        } while (!allPassed && startIndex != n2);
                    }
                    matcherResult = MatcherResult.Companion.invoke(allPassed, (Function0)new Function0<String>(this.$allowGaps, (Ref.ObjectRef<MatchInOrderSubsetResult>)bestResult){
                        final /* synthetic */ boolean $allowGaps;
                        final /* synthetic */ Ref.ObjectRef<MatchInOrderSubsetResult> $bestResult;
                        {
                            this.$allowGaps = $allowGaps;
                            this.$bestResult = $bestResult;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string;
                            MatchInOrderSubsetResult matchInOrderSubsetResult = (MatchInOrderSubsetResult)this.$bestResult.element;
                            MatchInOrderSubsetResult matchInOrderSubsetResult2 = (MatchInOrderSubsetResult)this.$bestResult.element;
                            StringBuilder stringBuilder = new StringBuilder().append("\n            |Expected a sequence of elements to pass the assertions, ").append(this.$allowGaps ? "possibly with gaps between " : "").append("but failed to match all assertions\n            |\n            |Best result when comparing from index [").append(matchInOrderSubsetResult == null ? null : Integer.valueOf(matchInOrderSubsetResult.getStartIndex())).append("], where ").append(matchInOrderSubsetResult2 == null ? null : Integer.valueOf(matchInOrderSubsetResult2.getElementsPassed())).append(" elements passed, but the following elements failed:\n            |\n            ");
                            MatchInOrderSubsetResult matchInOrderSubsetResult3 = (MatchInOrderSubsetResult)this.$bestResult.element;
                            if (matchInOrderSubsetResult3 == null) {
                                string = null;
                            } else {
                                List<MatchInOrderSubsetProblem> list = matchInOrderSubsetResult3.getProblems();
                                string = list == null ? null : CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, (Function1)matchInOrder.1.INSTANCE, (int)30, null);
                            }
                            return StringsKt.trimMargin$default((String)stringBuilder.append((Object)string).append("\n            ").toString(), null, (int)1, null);
                        }
                    }, (Function0)matchInOrder.2.INSTANCE);
                }
                finally {
                    jvmerrorcollector.getErrorCollector().setCollectionMode(originalMode);
                }
                return matcherResult;
            }
        });
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchEach(@NotNull List<? extends Function1<? super T, Unit>> assertions) {
        Intrinsics.checkNotNullParameter(assertions, (String)"assertions");
        return MatcherKt.neverNullMatcher((Function1)new Function1<Collection<? extends T>, MatcherResult>(assertions){
            final /* synthetic */ List<Function1<T, Unit>> $assertions;
            {
                this.$assertions = $assertions;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final MatcherResult invoke(@NotNull Collection<? extends T> actual) {
                @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J*\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"io/kotest/matchers/collections/CollectionMatchersKt$matchEach$1$MatchEachProblem", "", "atIndex", "", "problem", "", "(ILjava/lang/String;)V", "getAtIndex", "()I", "getProblem", "()Ljava/lang/String;", "component1", "component2", "copy", "(ILjava/lang/String;)Lio/kotest/matchers/collections/CollectionMatchersKt$matchEach$1$MatchEachProblem;", "equals", "", "other", "hashCode", "toString", "kotest-assertions-core"})
                public final class MatchEachProblem {
                    private final int atIndex;
                    @Nullable
                    private final String problem;

                    public MatchEachProblem(int atIndex, @Nullable String problem) {
                        this.atIndex = atIndex;
                        this.problem = problem;
                    }

                    public final int getAtIndex() {
                        return this.atIndex;
                    }

                    @Nullable
                    public final String getProblem() {
                        return this.problem;
                    }

                    public final int component1() {
                        return this.atIndex;
                    }

                    @Nullable
                    public final String component2() {
                        return this.problem;
                    }

                    @NotNull
                    public final MatchEachProblem copy(int atIndex, @Nullable String problem) {
                        return new MatchEachProblem(atIndex, problem);
                    }

                    public static /* synthetic */ MatchEachProblem copy$default(MatchEachProblem matchEachProblem, int n, String string, int n2, Object object) {
                        if ((n2 & 1) != 0) {
                            n = matchEachProblem.atIndex;
                        }
                        if ((n2 & 2) != 0) {
                            string = matchEachProblem.problem;
                        }
                        return matchEachProblem.copy(n, string);
                    }

                    @NotNull
                    public String toString() {
                        return "MatchEachProblem(atIndex=" + this.atIndex + ", problem=" + this.problem + ')';
                    }

                    public int hashCode() {
                        int result = Integer.hashCode(this.atIndex);
                        result = result * 31 + (this.problem == null ? 0 : this.problem.hashCode());
                        return result;
                    }

                    public boolean equals(@Nullable Object other) {
                        if (this == other) {
                            return true;
                        }
                        if (!(other instanceof MatchEachProblem)) {
                            return false;
                        }
                        MatchEachProblem matchEachProblem = (MatchEachProblem)other;
                        if (this.atIndex != matchEachProblem.atIndex) {
                            return false;
                        }
                        return Intrinsics.areEqual((Object)this.problem, (Object)matchEachProblem.problem);
                    }
                }
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list;
                void mode$iv;
                Iterable $this$runWithMode$iv;
                Intrinsics.checkNotNullParameter(actual, (String)"actual");
                ErrorCollector errorCollector = jvmerrorcollector.getErrorCollector();
                ErrorCollectionMode errorCollectionMode = ErrorCollectionMode.Hard;
                List<Function1<T, Unit>> list2 = this.$assertions;
                boolean $i$f$runWithMode = false;
                ErrorCollectionMode original$iv = $this$runWithMode$iv.getCollectionMode();
                boolean bl = false;
                $this$runWithMode$iv.setCollectionMode((ErrorCollectionMode)mode$iv);
                try {
                    void $this$mapIndexedNotNullTo$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$mapIndexedNotNull$iv = actual;
                    boolean $i$f$mapIndexedNotNull = false;
                    Iterable iterable = $this$mapIndexedNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapIndexedNotNullTo = false;
                    void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv$iv$iv = 0;
                    for (T item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                        MatchEachProblem matchEachProblem;
                        void element$iv$iv;
                        int n = index$iv$iv$iv;
                        index$iv$iv$iv = n + 1;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        T t2 = item$iv$iv$iv;
                        int index$iv$iv = n;
                        boolean bl3 = false;
                        void var24_28 = element$iv$iv;
                        int index = index$iv$iv;
                        boolean bl4 = false;
                        if (!(0 <= index ? index < list2.size() : false)) {
                            matchEachProblem = new MatchEachProblem(index, "Element has no corresponding assertion. Only " + list2.size() + " assertions provided");
                        } else {
                            Object object;
                            try {
                                void element;
                                boolean bl5 = false;
                                list2.get(index).invoke((Object)element);
                                object = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable bl5) {
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
                            }
                            if (Result.exceptionOrNull-impl((Object)object) == null) {
                                matchEachProblem = null;
                            } else {
                                Throwable exception;
                                boolean bl6 = false;
                                matchEachProblem = new MatchEachProblem(index, exception.getMessage());
                            }
                        }
                        if (matchEachProblem == null) continue;
                        MatchEachProblem it$iv$iv = matchEachProblem;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
                finally {
                    $this$runWithMode$iv.setCollectionMode(original$iv);
                }
                $this$runWithMode$iv = (Iterable)new IntRange(actual.size(), this.$assertions.size() - 1);
                Collection collection = list;
                boolean $i$f$map = false;
                list2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int $this$mapIndexedNotNull$iv = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection2 = destination$iv$iv;
                    boolean bl8 = false;
                    collection2.add(new MatchEachProblem((int)it, Intrinsics.stringPlus((String)"No actual element for assertion at index ", (Object)((int)it))));
                }
                List problems = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
                return MatcherResult.Companion.invoke(problems.isEmpty(), (Function0)new Function0<String>((List<MatchEachProblem>)problems){
                    final /* synthetic */ List<MatchEachProblem> $problems;
                    {
                        this.$problems = $problems;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Expected each element to pass its assertion, but found issues at indexes: [" + CollectionsKt.joinToString$default((Iterable)this.$problems, null, null, null, (int)0, null, (Function1)matchEach.1.INSTANCE, (int)31, null) + "]\n\n" + CollectionsKt.joinToString$default((Iterable)this.$problems, (CharSequence)"\n", null, null, (int)0, null, (Function1)matchEach.2.INSTANCE, (int)30, null);
                    }
                }, (Function0)matchEach.2.INSTANCE);
            }
        });
    }
}

