/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.doubles;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.doubles.ToleranceMatcher;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\nR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kotest/matchers/doubles/ToleranceMatcher;", "Lio/kotest/matchers/Matcher;", "", "expected", "tolerance", "(Ljava/lang/Double;D)V", "Ljava/lang/Double;", "test", "Lio/kotest/matchers/MatcherResult;", "value", "(Ljava/lang/Double;)Lio/kotest/matchers/MatcherResult;", "kotest-assertions-core"})
public final class ToleranceMatcher
implements Matcher<Double> {
    @Nullable
    private final Double expected;
    private final double tolerance;

    public ToleranceMatcher(@Nullable Double expected, double tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @NotNull
    public MatcherResult test(@Nullable Double value) {
        MatcherResult matcherResult;
        if (value == null || this.expected == null || Double.isInfinite(this.expected)) {
            matcherResult = MatcherResult.Companion.invoke(Intrinsics.areEqual((Double)value, (Double)this.expected), (Function0)new Function0<String>(value, this){
                final /* synthetic */ Double $value;
                final /* synthetic */ ToleranceMatcher this$0;
                {
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$value + " should be equal to " + ToleranceMatcher.access$getExpected$p(this.this$0);
                }
            }, (Function0)new Function0<String>(value, this){
                final /* synthetic */ Double $value;
                final /* synthetic */ ToleranceMatcher this$0;
                {
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$value + " should not be equal to " + ToleranceMatcher.access$getExpected$p(this.this$0);
                }
            });
        } else if (Double.isNaN(this.expected) && Double.isNaN(value)) {
            System.out.println((Object)"[WARN] By design, Double.Nan != Double.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
            matcherResult = MatcherResult.Companion.invoke(false, (Function0)test.3.INSTANCE, (Function0)test.4.INSTANCE);
        } else {
            double diff;
            if (this.tolerance == 0.0) {
                System.out.println((Object)"[WARN] When comparing doubles consider using tolerance, eg: a shouldBe (b plusOrMinus c)");
            }
            boolean passed = (diff = Math.abs(value - this.expected)) <= this.tolerance;
            double low = this.expected - this.tolerance;
            double high = this.expected + this.tolerance;
            String msg = this.tolerance == 0.0 ? value + " should be equal to " + this.expected : value + " should be equal to " + this.expected + " within tolerance of " + this.tolerance + " (lowest acceptable value is " + low + "; highest acceptable value is " + high + ")";
            matcherResult = MatcherResult.Companion.invoke(passed, (Function0)new Function0<String>(msg){
                final /* synthetic */ String $msg;
                {
                    this.$msg = $msg;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$msg;
                }
            }, (Function0)new Function0<String>(value, this){
                final /* synthetic */ Double $value;
                final /* synthetic */ ToleranceMatcher this$0;
                {
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$value + " should not be equal to " + ToleranceMatcher.access$getExpected$p(this.this$0);
                }
            });
        }
        return matcherResult;
    }

    @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
    @NotNull
    public <U> Matcher<U> compose(@NotNull Function1<? super U, Double> fn) {
        return Matcher.DefaultImpls.compose((Matcher)this, fn);
    }

    @NotNull
    public <U> Matcher<U> contramap(@NotNull Function1<? super U, Double> f) {
        return Matcher.DefaultImpls.contramap((Matcher)this, f);
    }

    @NotNull
    public Matcher<Double> invert() {
        return Matcher.DefaultImpls.invert((Matcher)this);
    }

    @NotNull
    public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
        return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
    }

    public static final /* synthetic */ Double access$getExpected$p(ToleranceMatcher $this) {
        return $this.expected;
    }
}

