/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.concurrent;

import io.kotest.assertions.FailuresKt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a/\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a*\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a8\u0006\u000b"}, d2={"shouldCompleteWithin", "A", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "thunk", "Lkotlin/Function0;", "(JLjava/util/concurrent/TimeUnit;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shouldTimeout", "", "kotest-assertions-core"})
public final class ConcurrentKt {
    public static final <A> A shouldCompleteWithin(long timeout, @NotNull TimeUnit unit, @NotNull Function0<? extends A> thunk) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(thunk, (String)"thunk");
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        Thread t2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(thunk, ref, latch){
            final /* synthetic */ Function0<A> $thunk;
            final /* synthetic */ AtomicReference<A> $ref;
            final /* synthetic */ CountDownLatch $latch;
            {
                this.$thunk = $thunk;
                this.$ref = $ref;
                this.$latch = $latch;
                super(0);
            }

            public final void invoke() {
                Object a = this.$thunk.invoke();
                this.$ref.set(a);
                this.$latch.countDown();
            }
        }), (int)31, null);
        if (!latch.await(timeout, unit)) {
            t2.interrupt();
            throw FailuresKt.failure((String)("Test should have completed within " + timeout + '/' + (Object)((Object)unit)));
        }
        return ref.get();
    }

    public static final <A> void shouldTimeout(long timeout, @NotNull TimeUnit unit, @NotNull Function0<? extends A> thunk) {
        boolean timedOut;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(thunk, (String)"thunk");
        CountDownLatch latch = new CountDownLatch(1);
        Thread t2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(thunk, latch){
            final /* synthetic */ Function0<A> $thunk;
            final /* synthetic */ CountDownLatch $latch;
            {
                this.$thunk = $thunk;
                this.$latch = $latch;
                super(0);
            }

            public final void invoke() {
                this.$thunk.invoke();
                this.$latch.countDown();
            }
        }), (int)31, null);
        boolean bl = timedOut = !latch.await(timeout, unit);
        if (!timedOut) {
            throw FailuresKt.failure((String)("Expected test to timeout for " + timeout + '/' + (Object)((Object)unit)));
        }
        t2.interrupt();
    }
}

