/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.equality;

import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.eq.EqKt;
import io.kotest.assertions.print.PrintKt;
import io.kotest.matchers.equality.CompareResult;
import io.kotest.matchers.equality.FieldEqualityConfig;
import io.kotest.matchers.equality.FieldsKt;
import io.kotest.mpp.ReflectionKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KClassesJvm;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a0\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a.\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\f2\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a8\u0010\r\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a)\u0010\u000f\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0005\u001a\u0002H\u00102\u0006\u0010\u0007\u001a\u0002H\u00102\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011\u001a8\u0010\u0012\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a:\u0010\u0015\u001a\u00020\u00162\b\u0010\u0005\u001a\u0004\u0018\u00010\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00142\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0006H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019\u00b2\u0006\n\u0010\u001a\u001a\u00020\u0016X\u008a\u0084\u0002"}, d2={"builtins", "", "", "compareCollections", "Lio/kotest/matchers/equality/CompareResult;", "actual", "", "expected", "field", "config", "Lio/kotest/matchers/equality/FieldEqualityConfig;", "compareFields", "", "compareMaps", "", "compareUsingFields", "T", "(Ljava/lang/Object;Ljava/lang/Object;Lio/kotest/matchers/equality/FieldEqualityConfig;)Lio/kotest/matchers/equality/CompareResult;", "compareValue", "type", "Lkotlin/reflect/KClass;", "useEq", "", "typeName", "useEqs", "kotest-assertions-core", "typeIsJavaOrKotlinBuiltIn"})
@SourceDebugExtension(value={"SMAP\ncompare.kt\nKotlin\n*S Kotlin\n*F\n+ 1 compare.kt\nio/kotest/matchers/equality/CompareKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1789#2,3:177\n1549#2:180\n1620#2,3:181\n2661#2,7:184\n1549#2:191\n1620#2,3:192\n2661#2,7:195\n*S KotlinDebug\n*F\n+ 1 compare.kt\nio/kotest/matchers/equality/CompareKt\n*L\n32#1:177,3\n90#1:180\n90#1:181,3\n107#1:184,7\n123#1:191\n123#1:192,3\n127#1:195,7\n*E\n"})
public final class CompareKt {
    @NotNull
    private static final Set<String> builtins;

    @NotNull
    public static final <T> CompareResult compareUsingFields(T actual, T expected, @NotNull FieldEqualityConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        if (actual == null) {
            throw FailuresKt.failure((String)("Expected " + PrintKt.print(expected).getValue() + " but actual was null"));
        }
        if (expected == null) {
            throw FailuresKt.failure((String)("Expected null but actual was " + PrintKt.print(actual).getValue()));
        }
        return CompareKt.compareFields(actual, expected, null, config2);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompareResult compareFields(Object actual, Object expected, String field, FieldEqualityConfig config2) {
        void $this$fold$iv;
        List<KProperty1<Object, ?>> props2;
        List<KProperty1<Object, ?>> props1 = FieldsKt.fields(actual, FieldsKt.predicates(config2));
        if (!Intrinsics.areEqual(props1, props2 = FieldsKt.fields(expected, FieldsKt.predicates(config2)))) {
            StringBuilder stringBuilder = new StringBuilder().append("Comparing type ");
            Object object = actual;
            Intrinsics.checkNotNull((Object)object);
            StringBuilder stringBuilder2 = stringBuilder.append(KClassesJvm.getJvmName((KClass)Reflection.getOrCreateKotlinClass(object.getClass()))).append(" to ");
            Object object2 = expected;
            Intrinsics.checkNotNull((Object)object2);
            throw FailuresKt.failure((String)stringBuilder2.append(KClassesJvm.getJvmName((KClass)Reflection.getOrCreateKotlinClass(object2.getClass()))).append(" with mismatched properties").toString());
        }
        Iterable iterable = props1;
        CompareResult initial$iv = new CompareResult(CollectionsKt.emptyList(), MapsKt.emptyMap());
        boolean $i$f$fold = false;
        CompareResult accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void prop;
            KProperty1 kProperty1 = (KProperty1)element$iv;
            CompareResult acc = accumulator$iv;
            boolean bl = false;
            System.out.println((Object)("Prop: " + StringsKt.replace$default((String)prop.getReturnType().toString(), (String)"?", (String)"", (boolean)false, (int)4, null)));
            Object[] objectArray = new Object[]{actual};
            Object actualValue = prop.getGetter().call(objectArray);
            Object[] objectArray2 = new Object[]{expected};
            Object expectedValue = prop.getGetter().call(objectArray2);
            String name = field == null ? prop.getName() : field + '.' + prop.getName();
            KClassifier kClassifier = prop.getReturnType().getClassifier();
            Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
            KClass returnType = (KClass)kClassifier;
            accumulator$iv = acc.reduce(CompareKt.compareValue(actualValue, expectedValue, returnType, name, config2));
        }
        return accumulator$iv;
    }

    private static final CompareResult compareValue(Object actual, Object expected, KClass<?> type, String field, FieldEqualityConfig config2) {
        CompareResult compareResult;
        System.out.println((Object)("Compare value " + type + " from " + actual + ' ' + expected));
        if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Collection.class))) {
            Intrinsics.checkNotNull((Object)actual, (String)"null cannot be cast to non-null type kotlin.collections.Collection<*>");
            Collection actualCollection = (Collection)actual;
            Intrinsics.checkNotNull((Object)expected, (String)"null cannot be cast to non-null type kotlin.collections.Collection<*>");
            Collection expectedCollection = (Collection)expected;
            compareResult = CompareKt.compareCollections(actualCollection, expectedCollection, field, config2);
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Map.class))) {
            Intrinsics.checkNotNull((Object)actual, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map actualMap = (Map)actual;
            Intrinsics.checkNotNull((Object)expected, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map expectedMap = (Map)expected;
            compareResult = CompareKt.compareMaps(actualMap, expectedMap, field, config2);
        } else {
            Throwable throwable;
            compareResult = CompareKt.useEq(actual, expected, type, config2.getUseDefaultShouldBeForFields()) ? ((throwable = EqKt.eq((Object)actual, (Object)expected)) == null ? CompareResult.Companion.match(field) : CompareResult.Companion.single(field, throwable)) : CompareKt.compareFields(actual, expected, field, config2);
        }
        return compareResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final CompareResult compareCollections(Collection<?> actual, Collection<?> expected, String field, FieldEqualityConfig config2) {
        CompareResult compareResult;
        if (actual.size() != expected.size()) {
            compareResult = CompareResult.Companion.single(field, (Throwable)((Object)FailuresKt.failure((String)("Collections differ in size: " + actual.size() + " != " + expected.size()))));
        } else if (actual.isEmpty()) {
            compareResult = CompareResult.Companion.getEmpty();
        } else {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)CollectionsKt.zip((Iterable)actual, (Iterable)expected));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CompareResult compareResult2;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int index = indexedValue.component1();
                Pair value = (Pair)indexedValue.component2();
                String elementName = field + '[' + index + ']';
                if (value.getFirst() == null && value.getSecond() == null) {
                    compareResult2 = CompareResult.Companion.getEmpty();
                } else if (value.getFirst() == null) {
                    compareResult2 = CompareResult.Companion.single(elementName, (Throwable)((Object)FailuresKt.failure((String)("Expected " + PrintKt.print((Object)value.getSecond()).getValue() + " but actual was null"))));
                } else if (value.getSecond() == null) {
                    compareResult2 = CompareResult.Companion.single(elementName, (Throwable)((Object)FailuresKt.failure((String)("Expected null but actual was " + PrintKt.print((Object)value.getFirst()).getValue()))));
                } else {
                    Object object = value.getFirst();
                    Object object2 = value.getSecond();
                    Object object3 = value.getFirst();
                    Intrinsics.checkNotNull((Object)object3);
                    compareResult2 = CompareKt.compareValue(object, object2, Reflection.getOrCreateKotlinClass(object3.getClass()), elementName, config2);
                }
                collection.add(compareResult2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void op;
                CompareResult $i$f$mapTo2 = (CompareResult)iterator$iv.next();
                CompareResult a = (CompareResult)accumulator$iv;
                boolean bl = false;
                accumulator$iv = a.reduce((CompareResult)op);
            }
            compareResult = (CompareResult)accumulator$iv;
        }
        return compareResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final CompareResult compareMaps(Map<?, ?> actual, Map<?, ?> expected, String field, FieldEqualityConfig config2) {
        CompareResult compareResult;
        if (actual.size() != expected.size()) {
            compareResult = CompareResult.Companion.single(field, (Throwable)((Object)FailuresKt.failure((String)("Maps differ in size: " + actual.size() + " != " + expected.size()))));
        } else if (actual.isEmpty()) {
            compareResult = CompareResult.Companion.getEmpty();
        } else {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = actual.keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void key;
                Object item$iv$iv;
                Object t2 = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object a = actual.get(key);
                Object b = expected.get(key);
                Object obj = a;
                Intrinsics.checkNotNull(obj);
                collection.add(CompareKt.compareValue(a, b, Reflection.getOrCreateKotlinClass(obj.getClass()), field + '[' + key + ']', config2));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void op;
                CompareResult $i$f$mapTo2 = (CompareResult)iterator$iv.next();
                CompareResult a = (CompareResult)accumulator$iv;
                boolean bl = false;
                accumulator$iv = a.reduce((CompareResult)op);
            }
            compareResult = (CompareResult)accumulator$iv;
        }
        return compareResult;
    }

    public static final boolean useEq(@Nullable Object actual, @Nullable Object expected, @NotNull KClass<?> typeName, @NotNull Collection<? extends KClass<?>> useEqs) {
        Intrinsics.checkNotNullParameter(typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter(useEqs, (String)"useEqs");
        boolean expectedOrActualIsNull = actual == null || expected == null;
        Lazy typeIsJavaOrKotlinBuiltIn$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(typeName){
            final /* synthetic */ KClass<?> $typeName;
            {
                this.$typeName = $typeName;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                String bestName = ReflectionKt.bestName(this.$typeName);
                return StringsKt.startsWith$default((String)bestName, (String)"kotlin", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)bestName, (String)"java", (boolean)false, (int)2, null) || CompareKt.access$getBuiltins$p().contains(bestName);
            }
        }));
        boolean expectedOrActualIsEnum = actual instanceof Enum || expected instanceof Enum || actual != null && actual.getClass().isEnum() || expected != null && expected.getClass().isEnum();
        return expectedOrActualIsNull || CompareKt.useEq$lambda$5((Lazy<Boolean>)typeIsJavaOrKotlinBuiltIn$delegate) || useEqs.contains(typeName) || expectedOrActualIsEnum;
    }

    private static final boolean useEq$lambda$5(Lazy<Boolean> $typeIsJavaOrKotlinBuiltIn$delegate) {
        Lazy<Boolean> lazy = $typeIsJavaOrKotlinBuiltIn$delegate;
        return (Boolean)lazy.getValue();
    }

    public static final /* synthetic */ Set access$getBuiltins$p() {
        return builtins;
    }

    static {
        Object[] objectArray = new String[]{"boolean", "byte", "double", "float", "int", "long", "short"};
        builtins = SetsKt.setOf((Object[])objectArray);
    }
}

