/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.floats;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.floats.FloatToleranceMatcher;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002H\u0086\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/kotest/matchers/floats/FloatToleranceMatcher;", "Lio/kotest/matchers/Matcher;", "", "expected", "tolerance", "(FF)V", "plusOrMinus", "test", "Lio/kotest/matchers/MatcherResult;", "value", "kotest-assertions-core"})
public final class FloatToleranceMatcher
implements Matcher<Float> {
    private final float expected;
    private final float tolerance;

    public FloatToleranceMatcher(float expected, float tolerance) {
        this.expected = expected;
        this.tolerance = tolerance;
    }

    @NotNull
    public MatcherResult test(float value) {
        MatcherResult matcherResult;
        if (Float.isNaN(this.expected) && Float.isNaN(value)) {
            System.out.println((Object)"[WARN] By design, Float.Nan != Float.Nan; see https://stackoverflow.com/questions/8819738/why-does-double-nan-double-nan-return-false/8819776#8819776");
            matcherResult = MatcherResult.Companion.invoke(false, (Function0)test.1.INSTANCE, (Function0)test.2.INSTANCE);
        } else {
            float diff;
            if (this.tolerance == 0.0f) {
                System.out.println((Object)"[WARN] When comparing Float consider using tolerance, eg: a shouldBe b plusOrMinus c");
            }
            matcherResult = MatcherResult.Companion.invoke((diff = Math.abs(value - this.expected)) <= this.tolerance, (Function0)new Function0<String>(value, this){
                final /* synthetic */ float $value;
                final /* synthetic */ FloatToleranceMatcher this$0;
                {
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$value + " should be equal to " + FloatToleranceMatcher.access$getExpected$p(this.this$0);
                }
            }, (Function0)new Function0<String>(value, this){
                final /* synthetic */ float $value;
                final /* synthetic */ FloatToleranceMatcher this$0;
                {
                    this.$value = $value;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$value + " should not be equal to " + FloatToleranceMatcher.access$getExpected$p(this.this$0);
                }
            });
        }
        return matcherResult;
    }

    @NotNull
    public final FloatToleranceMatcher plusOrMinus(float tolerance) {
        return new FloatToleranceMatcher(this.expected, tolerance);
    }

    @Deprecated(message="Use contramap. Deprecated in 5.3", replaceWith=@ReplaceWith(expression="contramap(fn)", imports={}))
    @NotNull
    public <U> Matcher<U> compose(@NotNull Function1<? super U, Float> fn) {
        return Matcher.DefaultImpls.compose((Matcher)this, fn);
    }

    @NotNull
    public <U> Matcher<U> contramap(@NotNull Function1<? super U, Float> f) {
        return Matcher.DefaultImpls.contramap((Matcher)this, f);
    }

    @NotNull
    public Matcher<Float> invert() {
        return Matcher.DefaultImpls.invert((Matcher)this);
    }

    @NotNull
    public <T> Matcher<T> invertIf(@NotNull Matcher<? super T> $this$invertIf, boolean invert) {
        return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
    }

    public static final /* synthetic */ float access$getExpected$p(FloatToleranceMatcher $this) {
        return $this.expected;
    }
}

