/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.collections;

import io.kotest.assertions.ErrorCollectionMode;
import io.kotest.assertions.ErrorCollector;
import io.kotest.assertions.jvmerrorcollector;
import io.kotest.assertions.print.PrintKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherKt;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.collections.CollectionMatchersKt;
import io.kotest.matchers.collections.SizeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001aK\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u0004\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00070\u00060\u0005\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\b\u001a4\u0010\u0000\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00070\u00060\n\u001a \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0006\u0010\f\u001a\u00020\r\u001a\"\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000f\u001a\"\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000f\u001a<\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00120\u0006\u001a<\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00120\u0006\u001a\"\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000f\u001a\"\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u000e\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u000f\u001a<\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00120\u0006\u001a<\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\n0\u0001\"\u0004\b\u0000\u0010\u0003\"\u000e\b\u0001\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00120\u0006\u001aK\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u001a\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u00060\u0005\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u0006\u00a2\u0006\u0002\u0010\b\u001aK\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u001a\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u00060\u0005\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u0006\u00a2\u0006\u0002\u0010\b\u001aK\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032*\u0010\u001a\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u00060\u0005\"\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u0006\u00a2\u0006\u0002\u0010\b\u001a<\u0010\u001c\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u00060\n2\u0006\u0010\u001f\u001a\u00020\u0007\u001aB\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00030\n2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\"\u001a4\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0003\u0018\u00010\u00020\u0001\"\u0004\b\u0000\u0010\u00032\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u001b0\u00060\n\u00a8\u0006#"}, d2={"existInOrder", "Lio/kotest/matchers/Matcher;", "", "T", "ps", "", "Lkotlin/Function1;", "", "([Lkotlin/jvm/functions/Function1;)Lio/kotest/matchers/Matcher;", "predicates", "", "haveSize", "size", "", "beSorted", "", "sorted", "beSortedBy", "E", "transform", "sortedBy", "beSortedDescending", "sortedDescending", "beSortedDescendingBy", "sortedDescendingBy", "matchEach", "fns", "", "matchInOrder", "matchInOrderSubset", "assertions", "allowGaps", "expected", "asserter", "Lkotlin/Function2;", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nCollectionMatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionMatchers.kt\nio/kotest/matchers/collections/CollectionMatchersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ErrorCollector.kt\nio/kotest/assertions/ErrorCollectorKt\n*L\n1#1,217:1\n1557#2:218\n1628#2,3:219\n1577#2,11:227\n1872#2,2:238\n1874#2:241\n1588#2:242\n1557#2:246\n1628#2,3:247\n1#3:222\n1#3:240\n167#4,4:223\n172#4,3:243\n*S KotlinDebug\n*F\n+ 1 CollectionMatchers.kt\nio/kotest/matchers/collections/CollectionMatchersKt\n*L\n173#1:218\n173#1:219,3\n187#1:227,11\n187#1:238,2\n187#1:241\n187#1:242\n201#1:246\n201#1:247,3\n187#1:240\n186#1:223,4\n186#1:243,3\n*E\n"})
public final class CollectionMatchersKt {
    @NotNull
    public static final <T> Matcher<Collection<? extends T>> existInOrder(Function1<? super T, Boolean> ... ps) {
        Intrinsics.checkNotNullParameter(ps, (String)"ps");
        return CollectionMatchersKt.existInOrder(ArraysKt.asList((Object[])ps));
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> existInOrder(@NotNull List<? extends Function1<? super T, Boolean>> predicates) {
        Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
        return MatcherKt.neverNullMatcher(arg_0 -> CollectionMatchersKt.existInOrder$lambda$3(predicates, arg_0));
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> haveSize(int size) {
        return SizeKt.haveSizeMatcher(size);
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<? extends T>> beSorted() {
        return CollectionMatchersKt.sorted();
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<? extends T>> sorted() {
        return CollectionMatchersKt.sortedBy(CollectionMatchersKt::sorted$lambda$4);
    }

    @NotNull
    public static final <T, E extends Comparable<? super E>> Matcher<List<? extends T>> beSortedBy(@NotNull Function1<? super T, ? extends E> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return CollectionMatchersKt.sortedBy(transform);
    }

    @NotNull
    public static final <T, E extends Comparable<? super E>> Matcher<List<? extends T>> sortedBy(@NotNull Function1<? super T, ? extends E> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return new Matcher<List<? extends T>>(transform){
            final /* synthetic */ Function1<T, E> $transform;
            {
                this.$transform = $transform;
            }

            /*
             * WARNING - void declaration
             */
            public MatcherResult test(List<? extends T> value) {
                Object v0;
                block1: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    Iterable iterable = CollectionsKt.withIndex((Iterable)value);
                    Function1<T, E> function1 = this.$transform;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        IndexedValue indexedValue = (IndexedValue)element$iv;
                        boolean bl = false;
                        int i = indexedValue.component1();
                        Object it = indexedValue.component2();
                        if (!(i != CollectionsKt.getLastIndex(value) && ((Comparable)function1.invoke(it)).compareTo(function1.invoke(value.get(i + 1))) > 0)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                IndexedValue failure = v0;
                String elementMessage = failure == null ? "" : ". Element " + failure.getValue() + " at index " + failure.getIndex() + " was greater than element " + value.get(failure.getIndex() + 1);
                return MatcherResult.Companion.invoke(failure == null, () -> sortedBy.1.test$lambda$1(value, elementMessage), () -> sortedBy.1.test$lambda$2(value));
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends List<? extends T>> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<List<? extends T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$1(List $value, String $elementMessage) {
                return "List " + PrintKt.print((Object)$value).getValue() + " should be sorted" + $elementMessage;
            }

            private static final String test$lambda$2(List $value) {
                return "List " + PrintKt.print((Object)$value).getValue() + " should not be sorted";
            }
        };
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<? extends T>> beSortedDescending() {
        return CollectionMatchersKt.sortedDescending();
    }

    @NotNull
    public static final <T extends Comparable<? super T>> Matcher<List<? extends T>> sortedDescending() {
        return CollectionMatchersKt.sortedDescendingBy(CollectionMatchersKt::sortedDescending$lambda$5);
    }

    @NotNull
    public static final <T, E extends Comparable<? super E>> Matcher<List<? extends T>> beSortedDescendingBy(@NotNull Function1<? super T, ? extends E> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return CollectionMatchersKt.sortedDescendingBy(transform);
    }

    @NotNull
    public static final <T, E extends Comparable<? super E>> Matcher<List<? extends T>> sortedDescendingBy(@NotNull Function1<? super T, ? extends E> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return new Matcher<List<? extends T>>(transform){
            final /* synthetic */ Function1<T, E> $transform;
            {
                this.$transform = $transform;
            }

            /*
             * WARNING - void declaration
             */
            public MatcherResult test(List<? extends T> value) {
                Object v0;
                block1: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    Iterable iterable = CollectionsKt.withIndex((Iterable)value);
                    Function1<T, E> function1 = this.$transform;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        IndexedValue indexedValue = (IndexedValue)element$iv;
                        boolean bl = false;
                        int i = indexedValue.component1();
                        Object it = indexedValue.component2();
                        if (!(i != CollectionsKt.getLastIndex(value) && ((Comparable)function1.invoke(it)).compareTo(function1.invoke(value.get(i + 1))) < 0)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                IndexedValue failure = v0;
                String elementMessage = failure == null ? "" : ". Element " + failure.getValue() + " at index " + failure.getIndex() + " was less than element " + value.get(failure.getIndex() + 1);
                return MatcherResult.Companion.invoke(failure == null, () -> sortedDescendingBy.1.test$lambda$1(value, elementMessage), () -> sortedDescendingBy.1.test$lambda$2(value));
            }

            public <U> Matcher<U> contramap(Function1<? super U, ? extends List<? extends T>> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<List<? extends T>> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$1(List $value, String $elementMessage) {
                return "List " + PrintKt.print((Object)$value).getValue() + " should be sorted" + $elementMessage;
            }

            private static final String test$lambda$2(List $value) {
                return "List " + PrintKt.print((Object)$value).getValue() + " should not be sorted";
            }
        };
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchEach(Function1<? super T, Unit> ... fns) {
        Intrinsics.checkNotNullParameter(fns, (String)"fns");
        return CollectionMatchersKt.matchEach(ArraysKt.asList((Object[])fns));
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchInOrder(Function1<? super T, Unit> ... fns) {
        Intrinsics.checkNotNullParameter(fns, (String)"fns");
        return CollectionMatchersKt.matchInOrder(ArraysKt.asList((Object[])fns), false);
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchInOrderSubset(Function1<? super T, Unit> ... fns) {
        Intrinsics.checkNotNullParameter(fns, (String)"fns");
        return CollectionMatchersKt.matchInOrder(ArraysKt.asList((Object[])fns), true);
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchInOrder(@NotNull List<? extends Function1<? super T, Unit>> assertions, boolean allowGaps) {
        Intrinsics.checkNotNullParameter(assertions, (String)"assertions");
        return MatcherKt.neverNullMatcher(arg_0 -> CollectionMatchersKt.matchInOrder$lambda$10(assertions, allowGaps, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchEach(@NotNull List<? extends T> expected, @NotNull Function2<? super T, ? super T, Unit> asserter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(asserter, (String)"asserter");
        Iterable $this$map$iv = expected;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void expectedElement;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(arg_0 -> CollectionMatchersKt.matchEach$lambda$12$lambda$11(asserter, expectedElement, arg_0));
        }
        return CollectionMatchersKt.matchEach((List)destination$iv$iv);
    }

    @NotNull
    public static final <T> Matcher<Collection<? extends T>> matchEach(@NotNull List<? extends Function1<? super T, Unit>> assertions) {
        Intrinsics.checkNotNullParameter(assertions, (String)"assertions");
        return MatcherKt.neverNullMatcher(arg_0 -> CollectionMatchersKt.matchEach$lambda$22(assertions, arg_0));
    }

    private static final String existInOrder$lambda$3$lambda$1(Collection $actual, Ref.IntRef $subsequenceIndex) {
        return PrintKt.print((Object)$actual).getValue() + " did not match the predicates in order. Predicate at index " + $subsequenceIndex.element + " did not match.";
    }

    private static final String existInOrder$lambda$3$lambda$2(Collection $actual) {
        return PrintKt.print((Object)$actual).getValue() + " should not match the predicates in order";
    }

    private static final MatcherResult existInOrder$lambda$3(List $predicates, Collection actual) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        if (!(!((Collection)$predicates).isEmpty())) {
            boolean $i$a$-require-CollectionMatchersKt$existInOrder$1$22 = false;
            String $i$a$-require-CollectionMatchersKt$existInOrder$1$22 = "predicates must not be empty";
            throw new IllegalArgumentException($i$a$-require-CollectionMatchersKt$existInOrder$1$22.toString());
        }
        Ref.IntRef subsequenceIndex = new Ref.IntRef();
        Iterator actualIterator = actual.iterator();
        while (actualIterator.hasNext() && subsequenceIndex.element < $predicates.size()) {
            if (!((Boolean)((Function1)$predicates.get(subsequenceIndex.element)).invoke(actualIterator.next())).booleanValue()) continue;
            ++subsequenceIndex.element;
        }
        return MatcherResult.Companion.invoke(subsequenceIndex.element == $predicates.size(), () -> CollectionMatchersKt.existInOrder$lambda$3$lambda$1(actual, subsequenceIndex), () -> CollectionMatchersKt.existInOrder$lambda$3$lambda$2(actual));
    }

    private static final Comparable sorted$lambda$4(Comparable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Comparable sortedDescending$lambda$5(Comparable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final CharSequence matchInOrder$lambda$10$lambda$8$lambda$7(matchInOrder.1.MatchInOrderSubsetProblem problem) {
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"io/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetProblem", "", "atIndex", "", "problem", "", "<init>", "(ILjava/lang/String;)V", "getAtIndex", "()I", "getProblem", "()Ljava/lang/String;", "component1", "component2", "copy", "(ILjava/lang/String;)Lio/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetProblem;", "equals", "", "other", "hashCode", "toString", "kotest-assertions-core"})
        public final class MatchInOrderSubsetProblem {
            private final int atIndex;
            private final String problem;

            public MatchInOrderSubsetProblem(int atIndex, String problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                this.atIndex = atIndex;
                this.problem = problem;
            }

            public final int getAtIndex() {
                return this.atIndex;
            }

            public final String getProblem() {
                return this.problem;
            }

            public final int component1() {
                return this.atIndex;
            }

            public final String component2() {
                return this.problem;
            }

            public final MatchInOrderSubsetProblem copy(int atIndex, String problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                return new MatchInOrderSubsetProblem(atIndex, problem);
            }

            public static /* synthetic */ MatchInOrderSubsetProblem copy$default(MatchInOrderSubsetProblem matchInOrderSubsetProblem, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = matchInOrderSubsetProblem.atIndex;
                }
                if ((n2 & 2) != 0) {
                    string = matchInOrderSubsetProblem.problem;
                }
                return matchInOrderSubsetProblem.copy(n, string);
            }

            public String toString() {
                return "MatchInOrderSubsetProblem(atIndex=" + this.atIndex + ", problem=" + this.problem + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.atIndex);
                result = result * 31 + this.problem.hashCode();
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchInOrderSubsetProblem)) {
                    return false;
                }
                MatchInOrderSubsetProblem matchInOrderSubsetProblem = (MatchInOrderSubsetProblem)other;
                if (this.atIndex != matchInOrderSubsetProblem.atIndex) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.problem, (Object)matchInOrderSubsetProblem.problem);
            }
        }
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        return "" + '|' + problem.getAtIndex() + " => " + problem.getProblem();
    }

    private static final String matchInOrder$lambda$10$lambda$8(boolean $allowGaps, Ref.ObjectRef $bestResult) {
        Object object;
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0002\u0000\u0007\b\u008a\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J2\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"io/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetResult", "", "startIndex", "", "elementsPassed", "problems", "", "io/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetProblem", "<init>", "(IILjava/util/List;)V", "getStartIndex", "()I", "getElementsPassed", "getProblems", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "(IILjava/util/List;)Lio/kotest/matchers/collections/CollectionMatchersKt$matchInOrder$1$MatchInOrderSubsetResult;", "equals", "", "other", "hashCode", "toString", "", "kotest-assertions-core"})
        public final class MatchInOrderSubsetResult {
            private final int startIndex;
            private final int elementsPassed;
            private final List<matchInOrder.1.MatchInOrderSubsetProblem> problems;

            public MatchInOrderSubsetResult(int startIndex, int elementsPassed, List<matchInOrder.1.MatchInOrderSubsetProblem> problems) {
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                this.startIndex = startIndex;
                this.elementsPassed = elementsPassed;
                this.problems = problems;
            }

            public final int getStartIndex() {
                return this.startIndex;
            }

            public final int getElementsPassed() {
                return this.elementsPassed;
            }

            public final List<matchInOrder.1.MatchInOrderSubsetProblem> getProblems() {
                return this.problems;
            }

            public final int component1() {
                return this.startIndex;
            }

            public final int component2() {
                return this.elementsPassed;
            }

            public final List<matchInOrder.1.MatchInOrderSubsetProblem> component3() {
                return this.problems;
            }

            public final MatchInOrderSubsetResult copy(int startIndex, int elementsPassed, List<matchInOrder.1.MatchInOrderSubsetProblem> problems) {
                Intrinsics.checkNotNullParameter(problems, (String)"problems");
                return new MatchInOrderSubsetResult(startIndex, elementsPassed, problems);
            }

            public static /* synthetic */ MatchInOrderSubsetResult copy$default(MatchInOrderSubsetResult matchInOrderSubsetResult, int n, int n2, List list, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = matchInOrderSubsetResult.startIndex;
                }
                if ((n3 & 2) != 0) {
                    n2 = matchInOrderSubsetResult.elementsPassed;
                }
                if ((n3 & 4) != 0) {
                    list = matchInOrderSubsetResult.problems;
                }
                return matchInOrderSubsetResult.copy(n, n2, list);
            }

            public String toString() {
                return "MatchInOrderSubsetResult(startIndex=" + this.startIndex + ", elementsPassed=" + this.elementsPassed + ", problems=" + this.problems + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.startIndex);
                result = result * 31 + Integer.hashCode(this.elementsPassed);
                result = result * 31 + ((Object)this.problems).hashCode();
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchInOrderSubsetResult)) {
                    return false;
                }
                MatchInOrderSubsetResult matchInOrderSubsetResult = (MatchInOrderSubsetResult)other;
                if (this.startIndex != matchInOrderSubsetResult.startIndex) {
                    return false;
                }
                if (this.elementsPassed != matchInOrderSubsetResult.elementsPassed) {
                    return false;
                }
                return Intrinsics.areEqual(this.problems, matchInOrderSubsetResult.problems);
            }
        }
        MatchInOrderSubsetResult matchInOrderSubsetResult = (MatchInOrderSubsetResult)$bestResult.element;
        MatchInOrderSubsetResult matchInOrderSubsetResult2 = (MatchInOrderSubsetResult)$bestResult.element;
        return StringsKt.trimMargin$default((String)("\n            |Expected a sequence of elements to pass the assertions, " + ($allowGaps ? "possibly with gaps between " : "") + "but failed to match all assertions\n            |\n            |Best result when comparing from index [" + (matchInOrderSubsetResult != null ? Integer.valueOf(matchInOrderSubsetResult.getStartIndex()) : null) + "], where " + (matchInOrderSubsetResult2 != null ? Integer.valueOf(matchInOrderSubsetResult2.getElementsPassed()) : null) + " elements passed, but the following elements failed:\n            |\n            " + ((object = (MatchInOrderSubsetResult)$bestResult.element) != null && (object = ((MatchInOrderSubsetResult)object).getProblems()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, CollectionMatchersKt::matchInOrder$lambda$10$lambda$8$lambda$7, (int)30, null) : null) + "\n            "), null, (int)1, null);
    }

    private static final String matchInOrder$lambda$10$lambda$9() {
        return "Expected some assertion to fail but all passed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MatcherResult matchInOrder$lambda$10(List $assertions, boolean $allowGaps, Collection actual) {
        MatcherResult matcherResult;
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        ErrorCollectionMode originalMode = jvmerrorcollector.getErrorCollector().getCollectionMode();
        try {
            List actualAsList = CollectionsKt.toList((Iterable)actual);
            boolean allPassed = false;
            Ref.ObjectRef bestResult = new Ref.ObjectRef();
            int startIndex = 0;
            int n = actual.size() - $assertions.size();
            if (startIndex <= n) {
                while (true) {
                    int elementsPassed = 0;
                    int elementsTested = 0;
                    ArrayList<MatchInOrderSubsetProblem> currentProblems = new ArrayList<MatchInOrderSubsetProblem>();
                    while (startIndex + elementsTested < actual.size()) {
                        int n2;
                        Object object;
                        if (bestResult.element == null || elementsPassed > ((MatchInOrderSubsetResult)bestResult.element).getElementsPassed()) {
                            bestResult.element = new MatchInOrderSubsetResult(startIndex, elementsPassed, (List<MatchInOrderSubsetProblem>)currentProblems);
                        }
                        if (!$allowGaps && elementsTested > elementsPassed) break;
                        try {
                            boolean bl = false;
                            ((Function1)$assertions.get(elementsPassed)).invoke(actualAsList.get(startIndex + elementsTested));
                            object = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        Object elementResult = object;
                        if (Result.isSuccess-impl((Object)elementResult)) {
                            n2 = elementsPassed;
                            elementsPassed = n2 + 1;
                            currentProblems.clear();
                            if (elementsPassed == $assertions.size()) {
                                allPassed = true;
                                break;
                            }
                        } else {
                            Throwable throwable = Result.exceptionOrNull-impl((Object)elementResult);
                            Intrinsics.checkNotNull((Object)throwable);
                            String string = throwable.getMessage();
                            Intrinsics.checkNotNull((Object)string);
                            currentProblems.add(new MatchInOrderSubsetProblem(startIndex + elementsTested, string));
                        }
                        n2 = elementsTested;
                        elementsTested = n2 + 1;
                    }
                    if (allPassed || startIndex == n) break;
                    ++startIndex;
                }
            }
            matcherResult = MatcherResult.Companion.invoke(allPassed, () -> CollectionMatchersKt.matchInOrder$lambda$10$lambda$8($allowGaps, bestResult), CollectionMatchersKt::matchInOrder$lambda$10$lambda$9);
        }
        finally {
            jvmerrorcollector.getErrorCollector().setCollectionMode(originalMode);
        }
        return matcherResult;
    }

    private static final Unit matchEach$lambda$12$lambda$11(Function2 $asserter, Object $expectedElement, Object actualElement) {
        $asserter.invoke(actualElement, $expectedElement);
        return Unit.INSTANCE;
    }

    private static final CharSequence matchEach$lambda$22$lambda$20$lambda$18(matchEach.2.MatchEachProblem it) {
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J$\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"io/kotest/matchers/collections/CollectionMatchersKt$matchEach$2$MatchEachProblem", "", "atIndex", "", "problem", "", "<init>", "(ILjava/lang/String;)V", "getAtIndex", "()I", "getProblem", "()Ljava/lang/String;", "component1", "component2", "copy", "(ILjava/lang/String;)Lio/kotest/matchers/collections/CollectionMatchersKt$matchEach$2$MatchEachProblem;", "equals", "", "other", "hashCode", "toString", "kotest-assertions-core"})
        public final class MatchEachProblem {
            private final int atIndex;
            private final String problem;

            public MatchEachProblem(int atIndex, String problem) {
                this.atIndex = atIndex;
                this.problem = problem;
            }

            public final int getAtIndex() {
                return this.atIndex;
            }

            public final String getProblem() {
                return this.problem;
            }

            public final int component1() {
                return this.atIndex;
            }

            public final String component2() {
                return this.problem;
            }

            public final MatchEachProblem copy(int atIndex, String problem) {
                return new MatchEachProblem(atIndex, problem);
            }

            public static /* synthetic */ MatchEachProblem copy$default(MatchEachProblem matchEachProblem, int n, String string, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = matchEachProblem.atIndex;
                }
                if ((n2 & 2) != 0) {
                    string = matchEachProblem.problem;
                }
                return matchEachProblem.copy(n, string);
            }

            public String toString() {
                return "MatchEachProblem(atIndex=" + this.atIndex + ", problem=" + this.problem + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.atIndex);
                result = result * 31 + (this.problem == null ? 0 : this.problem.hashCode());
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchEachProblem)) {
                    return false;
                }
                MatchEachProblem matchEachProblem = (MatchEachProblem)other;
                if (this.atIndex != matchEachProblem.atIndex) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.problem, (Object)matchEachProblem.problem);
            }
        }
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getAtIndex());
    }

    private static final CharSequence matchEach$lambda$22$lambda$20$lambda$19(matchEach.2.MatchEachProblem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAtIndex() + " => " + it.getProblem();
    }

    private static final String matchEach$lambda$22$lambda$20(List $problems) {
        return "Expected each element to pass its assertion, but found issues at indexes: [" + CollectionsKt.joinToString$default((Iterable)$problems, null, null, null, (int)0, null, CollectionMatchersKt::matchEach$lambda$22$lambda$20$lambda$18, (int)31, null) + "]\n\n" + CollectionsKt.joinToString$default((Iterable)$problems, (CharSequence)"\n", null, null, (int)0, null, CollectionMatchersKt::matchEach$lambda$22$lambda$20$lambda$19, (int)30, null);
    }

    private static final String matchEach$lambda$22$lambda$21() {
        return "Expected some element to fail its assertion, but all passed.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final MatcherResult matchEach$lambda$22(List $assertions, Collection actual) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        int $i$f$mapIndexedNotNull;
        Iterable $this$runWithMode$iv;
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        ErrorCollector errorCollector = jvmerrorcollector.getErrorCollector();
        ErrorCollectionMode mode$iv = ErrorCollectionMode.Hard;
        boolean $i$f$runWithMode22 = false;
        ErrorCollectionMode original$iv = $this$runWithMode$iv.getCollectionMode();
        boolean bl = false;
        $this$runWithMode$iv.setCollectionMode(mode$iv);
        try {
            void $this$mapIndexedNotNullTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$mapIndexedNotNull$iv = actual;
            $i$f$mapIndexedNotNull = 0;
            Iterable iterable = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                MatchEachProblem matchEachProblem;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl3 = false;
                void var23_27 = element$iv$iv;
                int index = index$iv$iv;
                boolean bl4 = false;
                if (!(0 <= index ? index < ((Collection)$assertions).size() : false)) {
                    matchEachProblem = new MatchEachProblem(index, "Element has no corresponding assertion. Only " + $assertions.size() + " assertions provided");
                } else {
                    Object object;
                    try {
                        void element;
                        boolean bl5 = false;
                        ((Function1)$assertions.get(index)).invoke((Object)element);
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Throwable exception = throwable;
                        boolean bl6 = false;
                        matchEachProblem = new MatchEachProblem(index, exception.getMessage());
                    } else {
                        matchEachProblem = null;
                    }
                }
                if (matchEachProblem == null) continue;
                MatchEachProblem it$iv$iv = matchEachProblem;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        finally {
            $this$runWithMode$iv.setCollectionMode(original$iv);
        }
        $this$runWithMode$iv = (Iterable)RangesKt.until((int)actual.size(), (int)$assertions.size());
        Collection collection = list;
        boolean $i$f$map = false;
        void $i$f$runWithMode22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            $i$f$mapIndexedNotNull = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl8 = false;
            collection2.add(new MatchEachProblem((int)it, "No actual element for assertion at index " + (int)it));
        }
        List problems = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        return MatcherResult.Companion.invoke(problems.isEmpty(), () -> CollectionMatchersKt.matchEach$lambda$22$lambda$20(problems), CollectionMatchersKt::matchEach$lambda$22$lambda$21);
    }
}

