/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.floats;

import io.kotest.assertions.AssertionsConfig;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.floats.MatchersKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0002\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0011\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0012\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0013\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0014\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0016\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0017\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0018\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u0019\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0086\u0004\u001a\n\u0010\u001a\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u001b\u001a\u00020\u0002*\u00020\u0002\u001a\u001a\u0010\u001c\u001a\u00020\u001d*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 \u001a\u001a\u0010!\u001a\u00020\u001d*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 \u001a\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006#"}, d2={"exactly", "Lio/kotest/matchers/Matcher;", "", "d", "exactlyByBits", "expected", "lt", "x", "beLessThan", "lte", "beLessThanOrEqualTo", "gt", "beGreaterThan", "gte", "beGreaterThanOrEqualTo", "shouldBeLessThan", "", "shouldNotBeLessThan", "shouldBeLessThanOrEqual", "shouldNotBeLessThanOrEqual", "shouldBeGreaterThan", "shouldNotBeGreaterThan", "shouldBeGreaterThanOrEqual", "shouldNotBeGreaterThanOrEqual", "shouldBeExactly", "shouldNotBeExactly", "shouldBeZero", "shouldNotBeZero", "shouldBeWithinPercentageOf", "", "other", "percentage", "", "shouldNotBeWithinPercentageOf", "beWithinPercentageOf", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nmatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 matchers.kt\nio/kotest/matchers/floats/MatchersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
public final class MatchersKt {
    @NotNull
    public static final Matcher<Float> exactly(float d) {
        return (Matcher)new Matcher<Float>(d){
            final /* synthetic */ float $d;
            {
                this.$d = $d;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value == this.$d, () -> exactly.1.test$lambda$0(value, this.$d), () -> exactly.1.test$lambda$1(value, this.$d));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Float> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(float $value, float $d) {
                return $value + " is not equal to expected value " + $d;
            }

            private static final String test$lambda$1(float $value, float $d) {
                return $value + " should not be equal to " + $d;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> exactlyByBits(float expected) {
        return (Matcher)new Matcher<Float>(expected){
            final /* synthetic */ float $expected;
            {
                this.$expected = $expected;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(Float.floatToIntBits(value) == Float.floatToIntBits(this.$expected), () -> exactlyByBits.1.test$lambda$0(value, this.$expected), () -> exactlyByBits.1.test$lambda$1(value, this.$expected));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Float> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(float $value, float $expected) {
                return $value + " is not equal to expected value " + $expected;
            }

            private static final String test$lambda$1(float $value, float $expected) {
                return $value + " should not equal " + $expected;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> lt(float x) {
        return MatchersKt.beLessThan(x);
    }

    @NotNull
    public static final Matcher<Float> beLessThan(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value < this.$x, () -> beLessThan.1.test$lambda$0(value, this.$x), () -> beLessThan.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Float> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be < " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be < " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> lte(float x) {
        return MatchersKt.beLessThanOrEqualTo(x);
    }

    @NotNull
    public static final Matcher<Float> beLessThanOrEqualTo(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value <= this.$x, () -> beLessThanOrEqualTo.1.test$lambda$0(value, this.$x), () -> beLessThanOrEqualTo.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Float> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be <= " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be <= " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> gt(float x) {
        return MatchersKt.beGreaterThan(x);
    }

    @NotNull
    public static final Matcher<Float> beGreaterThan(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value > this.$x, () -> beGreaterThan.1.test$lambda$0(value, this.$x), () -> beGreaterThan.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Float> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be > " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be > " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Float> gte(float x) {
        return MatchersKt.beGreaterThanOrEqualTo(x);
    }

    @NotNull
    public static final Matcher<Float> beGreaterThanOrEqualTo(float x) {
        return (Matcher)new Matcher<Float>(x){
            final /* synthetic */ float $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(value >= this.$x, () -> beGreaterThanOrEqualTo.1.test$lambda$0(value, this.$x), () -> beGreaterThanOrEqualTo.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Float> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(float $value, float $x) {
                return $value + " should be >= " + $x;
            }

            private static final String test$lambda$1(float $value, float $x) {
                return $value + " should not be >= " + $x;
            }
        };
    }

    @NotNull
    public static final Object shouldBeLessThan(float $this$shouldBeLessThan, float x) {
        return ShouldKt.shouldBe((Object)Float.valueOf($this$shouldBeLessThan), MatchersKt.lt(x));
    }

    public static final float shouldNotBeLessThan(float $this$shouldNotBeLessThan, float x) {
        return ((Number)ShouldKt.shouldNotBe((Object)Float.valueOf($this$shouldNotBeLessThan), MatchersKt.lt(x))).floatValue();
    }

    @NotNull
    public static final Object shouldBeLessThanOrEqual(float $this$shouldBeLessThanOrEqual, float x) {
        return ShouldKt.shouldBe((Object)Float.valueOf($this$shouldBeLessThanOrEqual), MatchersKt.lte(x));
    }

    public static final float shouldNotBeLessThanOrEqual(float $this$shouldNotBeLessThanOrEqual, float x) {
        return ((Number)ShouldKt.shouldNotBe((Object)Float.valueOf($this$shouldNotBeLessThanOrEqual), MatchersKt.lte(x))).floatValue();
    }

    @NotNull
    public static final Object shouldBeGreaterThan(float $this$shouldBeGreaterThan, float x) {
        return ShouldKt.shouldBe((Object)Float.valueOf($this$shouldBeGreaterThan), MatchersKt.gt(x));
    }

    public static final float shouldNotBeGreaterThan(float $this$shouldNotBeGreaterThan, float x) {
        return ((Number)ShouldKt.shouldNotBe((Object)Float.valueOf($this$shouldNotBeGreaterThan), MatchersKt.gt(x))).floatValue();
    }

    @NotNull
    public static final Object shouldBeGreaterThanOrEqual(float $this$shouldBeGreaterThanOrEqual, float x) {
        return ShouldKt.shouldBe((Object)Float.valueOf($this$shouldBeGreaterThanOrEqual), MatchersKt.gte(x));
    }

    public static final float shouldNotBeGreaterThanOrEqual(float $this$shouldNotBeGreaterThanOrEqual, float x) {
        return ((Number)ShouldKt.shouldNotBe((Object)Float.valueOf($this$shouldNotBeGreaterThanOrEqual), MatchersKt.gte(x))).floatValue();
    }

    public static final float shouldBeExactly(float $this$shouldBeExactly, float x) {
        Object object = AssertionsConfig.INSTANCE.getDisableNaNEquality() ? ShouldKt.shouldBe((Object)Float.valueOf($this$shouldBeExactly), MatchersKt.exactly(x)) : ShouldKt.shouldBe((Object)Float.valueOf($this$shouldBeExactly), MatchersKt.exactlyByBits(x));
        return $this$shouldBeExactly;
    }

    public static final float shouldNotBeExactly(float $this$shouldNotBeExactly, float x) {
        float f = AssertionsConfig.INSTANCE.getDisableNaNEquality() ? ((Number)ShouldKt.shouldNotBe((Object)Float.valueOf($this$shouldNotBeExactly), MatchersKt.exactly(x))).floatValue() : ((Number)ShouldKt.shouldNotBe((Object)Float.valueOf($this$shouldNotBeExactly), MatchersKt.exactlyByBits(x))).floatValue();
        return $this$shouldNotBeExactly;
    }

    public static final float shouldBeZero(float $this$shouldBeZero) {
        return MatchersKt.shouldBeExactly($this$shouldBeZero, 0.0f);
    }

    public static final float shouldNotBeZero(float $this$shouldNotBeZero) {
        return MatchersKt.shouldNotBeExactly($this$shouldNotBeZero, 0.0f);
    }

    public static final void shouldBeWithinPercentageOf(float $this$shouldBeWithinPercentageOf, float other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.should((Object)Float.valueOf($this$shouldBeWithinPercentageOf), MatchersKt.beWithinPercentageOf(other, percentage));
    }

    public static final void shouldNotBeWithinPercentageOf(float $this$shouldNotBeWithinPercentageOf, float other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.shouldNot((Object)Float.valueOf($this$shouldNotBeWithinPercentageOf), MatchersKt.beWithinPercentageOf(other, percentage));
    }

    @NotNull
    public static final Matcher<Float> beWithinPercentageOf(float other, double percentage) {
        return (Matcher)new Matcher<Float>(other, percentage){
            private final float tolerance;
            private final ClosedFloatingPointRange<Float> range;
            {
                this.tolerance = (float)Math.abs((double)$other * ($percentage / (double)100));
                this.range = RangesKt.rangeTo((float)($other - this.tolerance), (float)($other + this.tolerance));
            }

            public MatcherResult test(float value) {
                return MatcherResult.Companion.invoke(this.range.contains((Comparable)Float.valueOf(value)), () -> beWithinPercentageOf.1.test$lambda$0(value, this), () -> beWithinPercentageOf.1.test$lambda$1(value, this));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Float> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Float> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(float $value, beWithinPercentageOf.1 this$0) {
                return $value + " should be in " + this$0.range;
            }

            private static final String test$lambda$1(float $value, beWithinPercentageOf.1 this$0) {
                return $value + " should not be in " + this$0.range;
            }
        };
    }
}

