/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.longs;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.longs.LongMatchersKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0004\u001a\u0015\u0010\u000f\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0004\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u001a\u0010\u0012\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001a\u0010\u0016\u001a\u00020\f*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0018"}, d2={"lt", "Lio/kotest/matchers/Matcher;", "", "x", "beLessThan", "lte", "beLessThanOrEqualTo", "gt", "beGreaterThan", "gte", "beGreaterThanOrEqualTo", "shouldBeInRange", "", "range", "Lkotlin/ranges/LongRange;", "shouldNotBeInRange", "beInRange", "exactly", "shouldBeWithinPercentageOf", "other", "percentage", "", "shouldNotBeWithinPercentageOf", "beWithinPercentageOf", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nLongMatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongMatchers.kt\nio/kotest/matchers/longs/LongMatchersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class LongMatchersKt {
    @NotNull
    public static final Matcher<Long> lt(long x) {
        return LongMatchersKt.beLessThan(x);
    }

    @NotNull
    public static final Matcher<Long> beLessThan(long x) {
        return (Matcher)new Matcher<Long>(x){
            final /* synthetic */ long $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(long value) {
                return MatcherResult.Companion.invoke(value < this.$x, () -> beLessThan.1.test$lambda$0(value, this.$x), () -> beLessThan.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Long> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Long> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(long $value, long $x) {
                return $value + " should be < " + $x;
            }

            private static final String test$lambda$1(long $value, long $x) {
                return $value + " should not be < " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Long> lte(long x) {
        return LongMatchersKt.beLessThanOrEqualTo(x);
    }

    @NotNull
    public static final Matcher<Long> beLessThanOrEqualTo(long x) {
        return (Matcher)new Matcher<Long>(x){
            final /* synthetic */ long $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(long value) {
                return MatcherResult.Companion.invoke(value <= this.$x, () -> beLessThanOrEqualTo.1.test$lambda$0(value, this.$x), () -> beLessThanOrEqualTo.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Long> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Long> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(long $value, long $x) {
                return $value + " should be <= " + $x;
            }

            private static final String test$lambda$1(long $value, long $x) {
                return $value + " should not be <= " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Long> gt(long x) {
        return LongMatchersKt.beGreaterThan(x);
    }

    @NotNull
    public static final Matcher<Long> beGreaterThan(long x) {
        return (Matcher)new Matcher<Long>(x){
            final /* synthetic */ long $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(long value) {
                return MatcherResult.Companion.invoke(value > this.$x, () -> beGreaterThan.1.test$lambda$0(value, this.$x), () -> beGreaterThan.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Long> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Long> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(long $value, long $x) {
                return $value + " should be > " + $x;
            }

            private static final String test$lambda$1(long $value, long $x) {
                return $value + " should not be > " + $x;
            }
        };
    }

    @NotNull
    public static final Matcher<Long> gte(long x) {
        return LongMatchersKt.beGreaterThanOrEqualTo(x);
    }

    @NotNull
    public static final Matcher<Long> beGreaterThanOrEqualTo(long x) {
        return (Matcher)new Matcher<Long>(x){
            final /* synthetic */ long $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(long value) {
                return MatcherResult.Companion.invoke(value >= this.$x, () -> beGreaterThanOrEqualTo.1.test$lambda$0(value, this.$x), () -> beGreaterThanOrEqualTo.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Long> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Long> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(long $value, long $x) {
                return $value + " should be >= " + $x;
            }

            private static final String test$lambda$1(long $value, long $x) {
                return $value + " should not be >= " + $x;
            }
        };
    }

    public static final void shouldBeInRange(long $this$shouldBeInRange, @NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        ShouldKt.should((Object)$this$shouldBeInRange, LongMatchersKt.beInRange(range));
    }

    public static final void shouldNotBeInRange(long $this$shouldNotBeInRange, @NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        ShouldKt.shouldNot((Object)$this$shouldNotBeInRange, LongMatchersKt.beInRange(range));
    }

    @NotNull
    public static final Matcher<Long> beInRange(@NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return (Matcher)new Matcher<Long>(range){
            final /* synthetic */ LongRange $range;
            {
                this.$range = $range;
            }

            public MatcherResult test(long value) {
                long l = this.$range.getFirst();
                return MatcherResult.Companion.invoke(value <= this.$range.getLast() ? l <= value : false, () -> beInRange.1.test$lambda$0(value, this.$range), () -> beInRange.1.test$lambda$1(value, this.$range));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Long> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Long> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(long $value, LongRange $range) {
                return $value + " should be in range " + $range;
            }

            private static final String test$lambda$1(long $value, LongRange $range) {
                return $value + " should not be in range " + $range;
            }
        };
    }

    @NotNull
    public static final Matcher<Long> exactly(long x) {
        return (Matcher)new Matcher<Long>(x){
            final /* synthetic */ long $x;
            {
                this.$x = $x;
            }

            public MatcherResult test(long value) {
                return MatcherResult.Companion.invoke(value == this.$x, () -> exactly.1.test$lambda$0(value, this.$x), () -> exactly.1.test$lambda$1(value, this.$x));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Long> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Long> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(long $value, long $x) {
                return $value + " should be equal to " + $x;
            }

            private static final String test$lambda$1(long $value, long $x) {
                return $value + " should not be equal to " + $x;
            }
        };
    }

    public static final void shouldBeWithinPercentageOf(long $this$shouldBeWithinPercentageOf, long other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.should((Object)$this$shouldBeWithinPercentageOf, LongMatchersKt.beWithinPercentageOf(other, percentage));
    }

    public static final void shouldNotBeWithinPercentageOf(long $this$shouldNotBeWithinPercentageOf, long other, double percentage) {
        if (!(percentage > 0.0)) {
            boolean bl = false;
            String string = "Percentage must be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        ShouldKt.shouldNot((Object)$this$shouldNotBeWithinPercentageOf, LongMatchersKt.beWithinPercentageOf(other, percentage));
    }

    @NotNull
    public static final Matcher<Long> beWithinPercentageOf(long other, double percentage) {
        return (Matcher)new Matcher<Long>(other, percentage){
            private final double tolerance;
            private final ClosedFloatingPointRange<Double> range;
            {
                this.tolerance = Math.abs((double)$other * ($percentage / (double)100));
                this.range = RangesKt.rangeTo((double)((double)$other - this.tolerance), (double)((double)$other + this.tolerance));
            }

            public MatcherResult test(long value) {
                return MatcherResult.Companion.invoke(this.range.contains((Comparable)Double.valueOf(value)), () -> beWithinPercentageOf.1.test$lambda$0(value, this), () -> beWithinPercentageOf.1.test$lambda$1(value, this));
            }

            public <U> Matcher<U> contramap(Function1<? super U, Long> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<Long> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(long $value, beWithinPercentageOf.1 this$0) {
                return $value + " should be in " + this$0.range;
            }

            private static final String test$lambda$1(long $value, beWithinPercentageOf.1 this$0) {
                return $value + " should not be in " + this$0.range;
            }
        };
    }
}

