/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.ranges;

import io.kotest.matchers.ranges.RangeEdge;
import io.kotest.matchers.ranges.RangeEdgeType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001c*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\u001cB#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J/\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001d"}, d2={"Lio/kotest/matchers/ranges/Range;", "T", "", "", "start", "Lio/kotest/matchers/ranges/RangeEdge;", "end", "<init>", "(Lio/kotest/matchers/ranges/RangeEdge;Lio/kotest/matchers/ranges/RangeEdge;)V", "getStart", "()Lio/kotest/matchers/ranges/RangeEdge;", "getEnd", "toString", "", "isEmpty", "", "intersect", "other", "lessThan", "greaterThan", "contains", "edge", "component1", "component2", "copy", "equals", "hashCode", "", "Companion", "kotest-assertions-core"})
public final class Range<T extends Comparable<? super T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RangeEdge<T> start;
    @NotNull
    private final RangeEdge<T> end;

    public Range(@NotNull RangeEdge<T> start, @NotNull RangeEdge<T> end) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        this.start = start;
        this.end = end;
        if (!(this.start.getValue().compareTo(this.end.getValue()) <= 0)) {
            boolean bl = false;
            String string = this.start.getValue() + " cannot be after " + this.end.getValue();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final RangeEdge<T> getStart() {
        return this.start;
    }

    @NotNull
    public final RangeEdge<T> getEnd() {
        return this.end;
    }

    @NotNull
    public String toString() {
        return (this.start.getEdgeType() == RangeEdgeType.INCLUSIVE ? "[" : "(") + this.start.getValue() + ", " + this.end.getValue() + (this.end.getEdgeType() == RangeEdgeType.INCLUSIVE ? "]" : ")");
    }

    public final boolean isEmpty() {
        return Intrinsics.areEqual(this.start.getValue(), this.end.getValue()) && (this.start.getEdgeType() == RangeEdgeType.EXCLUSIVE || this.end.getEdgeType() == RangeEdgeType.EXCLUSIVE);
    }

    public final boolean intersect(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return !this.lessThan(other) && !other.lessThan(this);
    }

    public final boolean lessThan(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        T endOfThis = this.end.getValue();
        T startOfOther = other.start.getValue();
        return this.end.getEdgeType() == RangeEdgeType.INCLUSIVE && other.start.getEdgeType() == RangeEdgeType.INCLUSIVE ? endOfThis.compareTo(startOfOther) < 0 : endOfThis.compareTo(startOfOther) <= 0;
    }

    public final boolean greaterThan(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return other.lessThan(this);
    }

    public final boolean contains(@NotNull Range<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.contains(other.start) && this.contains(other.end);
    }

    public final boolean contains(@NotNull RangeEdge<T> edge) {
        Intrinsics.checkNotNullParameter(edge, (String)"edge");
        return edge.getValue().compareTo(this.start.getValue()) < 0 ? false : (Intrinsics.areEqual(edge.getValue(), this.start.getValue()) ? this.start.getEdgeType() == RangeEdgeType.INCLUSIVE || edge.getEdgeType() == RangeEdgeType.EXCLUSIVE : (this.start.getValue().compareTo(edge.getValue()) < 0 && edge.getValue().compareTo(this.end.getValue()) < 0 ? true : (Intrinsics.areEqual(edge.getValue(), this.end.getValue()) ? this.end.getEdgeType() == RangeEdgeType.INCLUSIVE || edge.getEdgeType() == RangeEdgeType.EXCLUSIVE : false)));
    }

    @NotNull
    public final RangeEdge<T> component1() {
        return this.start;
    }

    @NotNull
    public final RangeEdge<T> component2() {
        return this.end;
    }

    @NotNull
    public final Range<T> copy(@NotNull RangeEdge<T> start, @NotNull RangeEdge<T> end) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        return new Range<T>(start, end);
    }

    public static /* synthetic */ Range copy$default(Range range, RangeEdge rangeEdge, RangeEdge rangeEdge2, int n, Object object) {
        if ((n & 1) != 0) {
            rangeEdge = range.start;
        }
        if ((n & 2) != 0) {
            rangeEdge2 = range.end;
        }
        return range.copy(rangeEdge, rangeEdge2);
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Range)) {
            return false;
        }
        Range range = (Range)other;
        if (!Intrinsics.areEqual(this.start, range.start)) {
            return false;
        }
        return Intrinsics.areEqual(this.end, range.end);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/kotest/matchers/ranges/Range$Companion;", "", "<init>", "()V", "kotest-assertions-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

