/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.string;

import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.print.PrintKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherKt;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.string.ContainInOrderOutcome;
import io.kotest.matchers.string.MatchersKt;
import io.kotest.matchers.string.UUIDVersion;
import io.kotest.submatching.StringPartialMatchesKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u0019\u0010\b\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010\n\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019\u001a'\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001f\u001a'\u0010 \u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001f\u001a'\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\"\u001a\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0001H\u0000\u001a(\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010(2\b\b\u0002\u0010)\u001a\u00020*H\u0000\u001a\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0019\u0010+\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010,\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0019\u0010.\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010/\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u00100\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010/\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010/\u001a\u00020\u0001\u001a\u001e\u00102\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206\u001a\u001e\u00107\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206\u001a \u00108\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206\u001a#\u00109\u001a\u00020**\u0004\u0018\u00010\u00012\b\b\u0002\u0010:\u001a\u00020*\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0003\u0010\u0000\u00a8\u0006;"}, d2={"shouldContainOnlyDigits", "", "shouldNotContainOnlyDigits", "containOnlyDigits", "Lio/kotest/matchers/Matcher;", "shouldContainADigit", "shouldNotContainADigit", "containADigit", "shouldContainOnlyOnce", "substr", "shouldNotContainOnlyOnce", "containOnlyOnce", "substring", "shouldBeEmpty", "shouldNotBeEmpty", "beEmpty", "shouldBeBlank", "shouldNotBeBlank", "containOnlyWhitespace", "beBlank", "shouldContainIgnoringCase", "shouldNotContainIgnoringCase", "containIgnoringCase", "shouldContain", "regex", "Lkotlin/text/Regex;", "shouldNotContain", "contain", "shouldContainInOrder", "substrings", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "shouldNotContainInOrder", "containInOrder", "([Ljava/lang/String;)Lio/kotest/matchers/Matcher;", "prefixIfNotEmpty", "value", "prefix", "matchSubstrings", "Lio/kotest/matchers/string/ContainInOrderOutcome;", "", "depth", "", "shouldInclude", "shouldNotInclude", "include", "shouldBeEqualIgnoringCase", "other", "shouldNotBeEqualIgnoringCase", "beEqualIgnoringCase", "shouldBeUUID", "version", "Lio/kotest/matchers/string/UUIDVersion;", "considerNilValid", "", "shouldNotBeUUID", "beUUID", "shouldBeInteger", "radix", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nmatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 matchers.kt\nio/kotest/matchers/string/MatchersKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,390:1\n12483#2,2:391\n12654#2,2:393\n774#3:395\n865#3,2:396\n*S KotlinDebug\n*F\n+ 1 matchers.kt\nio/kotest/matchers/string/MatchersKt\n*L\n27#1:391,2\n44#1:393,2\n217#1:395\n217#1:396,2\n*E\n"})
public final class MatchersKt {
    @Nullable
    public static final String shouldContainOnlyDigits(@Nullable String $this$shouldContainOnlyDigits) {
        ShouldKt.should((Object)$this$shouldContainOnlyDigits, MatchersKt.containOnlyDigits());
        return $this$shouldContainOnlyDigits;
    }

    @Nullable
    public static final String shouldNotContainOnlyDigits(@Nullable String $this$shouldNotContainOnlyDigits) {
        ShouldKt.shouldNot((Object)$this$shouldNotContainOnlyDigits, MatchersKt.containOnlyDigits());
        return $this$shouldNotContainOnlyDigits;
    }

    @NotNull
    public static final Matcher<String> containOnlyDigits() {
        return MatcherKt.neverNullMatcher(MatchersKt::containOnlyDigits$lambda$3);
    }

    @Nullable
    public static final String shouldContainADigit(@Nullable String $this$shouldContainADigit) {
        ShouldKt.should((Object)$this$shouldContainADigit, MatchersKt.containADigit());
        return $this$shouldContainADigit;
    }

    @Nullable
    public static final String shouldNotContainADigit(@Nullable String $this$shouldNotContainADigit) {
        ShouldKt.shouldNot((Object)$this$shouldNotContainADigit, MatchersKt.containADigit());
        return $this$shouldNotContainADigit;
    }

    @NotNull
    public static final Matcher<String> containADigit() {
        return MatcherKt.neverNullMatcher(MatchersKt::containADigit$lambda$7);
    }

    @Nullable
    public static final String shouldContainOnlyOnce(@Nullable String $this$shouldContainOnlyOnce, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldContainOnlyOnce, MatchersKt.containOnlyOnce(substr));
        return $this$shouldContainOnlyOnce;
    }

    @Nullable
    public static final String shouldNotContainOnlyOnce(@Nullable String $this$shouldNotContainOnlyOnce, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotContainOnlyOnce, MatchersKt.containOnlyOnce(substr));
        return $this$shouldNotContainOnlyOnce;
    }

    @NotNull
    public static final Matcher<String> containOnlyOnce(@NotNull String substring) {
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        return MatcherKt.neverNullMatcher(arg_0 -> MatchersKt.containOnlyOnce$lambda$10(substring, arg_0));
    }

    @Nullable
    public static final String shouldBeEmpty(@Nullable String $this$shouldBeEmpty) {
        ShouldKt.should((Object)$this$shouldBeEmpty, MatchersKt.beEmpty());
        return $this$shouldBeEmpty;
    }

    @Nullable
    public static final String shouldNotBeEmpty(@Nullable String $this$shouldNotBeEmpty) {
        ShouldKt.shouldNot((Object)$this$shouldNotBeEmpty, MatchersKt.beEmpty());
        return $this$shouldNotBeEmpty;
    }

    @NotNull
    public static final Matcher<String> beEmpty() {
        return MatcherKt.neverNullMatcher(MatchersKt::beEmpty$lambda$13);
    }

    @Nullable
    public static final String shouldBeBlank(@Nullable String $this$shouldBeBlank) {
        ShouldKt.should((Object)$this$shouldBeBlank, MatchersKt.beBlank());
        return $this$shouldBeBlank;
    }

    @Nullable
    public static final String shouldNotBeBlank(@Nullable String $this$shouldNotBeBlank) {
        ShouldKt.shouldNot((Object)$this$shouldNotBeBlank, MatchersKt.beBlank());
        return $this$shouldNotBeBlank;
    }

    @NotNull
    public static final Matcher<String> containOnlyWhitespace() {
        return MatchersKt.beBlank();
    }

    @NotNull
    public static final Matcher<String> beBlank() {
        return MatcherKt.neverNullMatcher(MatchersKt::beBlank$lambda$16);
    }

    @Nullable
    public static final String shouldContainIgnoringCase(@Nullable String $this$shouldContainIgnoringCase, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldContainIgnoringCase, MatchersKt.containIgnoringCase(substr));
        return $this$shouldContainIgnoringCase;
    }

    @Nullable
    public static final String shouldNotContainIgnoringCase(@Nullable String $this$shouldNotContainIgnoringCase, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotContainIgnoringCase, MatchersKt.containIgnoringCase(substr));
        return $this$shouldNotContainIgnoringCase;
    }

    @NotNull
    public static final Matcher<String> containIgnoringCase(@NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        return MatcherKt.neverNullMatcher(arg_0 -> MatchersKt.containIgnoringCase$lambda$19(substr, arg_0));
    }

    @Nullable
    public static final String shouldContain(@Nullable String $this$shouldContain, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        ShouldKt.should((Object)$this$shouldContain, MatchersKt.contain(regex));
        return $this$shouldContain;
    }

    @Nullable
    public static final String shouldNotContain(@Nullable String $this$shouldNotContain, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        ShouldKt.shouldNot((Object)$this$shouldNotContain, MatchersKt.contain(regex));
        return $this$shouldNotContain;
    }

    @NotNull
    public static final Matcher<String> contain(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return MatcherKt.neverNullMatcher(arg_0 -> MatchersKt.contain$lambda$22(regex, arg_0));
    }

    @Nullable
    public static final String shouldContainInOrder(@Nullable String $this$shouldContainInOrder, String ... substrings) {
        Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
        ShouldKt.should((Object)$this$shouldContainInOrder, MatchersKt.containInOrder(Arrays.copyOf(substrings, substrings.length)));
        return $this$shouldContainInOrder;
    }

    @Nullable
    public static final String shouldNotContainInOrder(@Nullable String $this$shouldNotContainInOrder, String ... substrings) {
        Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
        ShouldKt.shouldNot((Object)$this$shouldNotContainInOrder, MatchersKt.containInOrder(Arrays.copyOf(substrings, substrings.length)));
        return $this$shouldNotContainInOrder;
    }

    @NotNull
    public static final Matcher<String> containInOrder(String ... substrings) {
        Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
        return MatcherKt.neverNullMatcher(arg_0 -> MatchersKt.containInOrder$lambda$25(substrings, arg_0));
    }

    @NotNull
    public static final String prefixIfNotEmpty(@NotNull String value, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return ((CharSequence)value).length() == 0 ? "" : prefix + value;
    }

    @NotNull
    public static final ContainInOrderOutcome matchSubstrings(@NotNull String value, @NotNull List<String> substrings, int depth) {
        ContainInOrderOutcome containInOrderOutcome;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(substrings, (String)"substrings");
        if (substrings.isEmpty()) {
            containInOrderOutcome = ContainInOrderOutcome.Match.INSTANCE;
        } else {
            String currentSubstring = substrings.get(0);
            int matchAtIndex = StringsKt.indexOf$default((CharSequence)value, (String)currentSubstring, (int)0, (boolean)false, (int)6, null);
            if (matchAtIndex == -1) {
                containInOrderOutcome = new ContainInOrderOutcome.Mismatch(currentSubstring, depth);
            } else if (Intrinsics.areEqual((Object)currentSubstring, (Object)"")) {
                containInOrderOutcome = MatchersKt.matchSubstrings(value, CollectionsKt.drop((Iterable)substrings, (int)1), depth + 1);
            } else {
                String string = value.substring(matchAtIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                containInOrderOutcome = MatchersKt.matchSubstrings(string, CollectionsKt.drop((Iterable)substrings, (int)1), depth + 1);
            }
        }
        return containInOrderOutcome;
    }

    public static /* synthetic */ ContainInOrderOutcome matchSubstrings$default(String string, List list, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return MatchersKt.matchSubstrings(string, list, n);
    }

    @Nullable
    public static final String shouldContain(@Nullable String $this$shouldContain, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldContain, MatchersKt.contain(substr));
        return $this$shouldContain;
    }

    @Nullable
    public static final String shouldNotContain(@Nullable String $this$shouldNotContain, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotContain, MatchersKt.contain(substr));
        return $this$shouldNotContain;
    }

    @NotNull
    public static final Matcher<String> contain(@NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        return MatchersKt.include(substr);
    }

    @Nullable
    public static final String shouldInclude(@Nullable String $this$shouldInclude, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should((Object)$this$shouldInclude, MatchersKt.include(substr));
        return $this$shouldInclude;
    }

    @Nullable
    public static final String shouldNotInclude(@Nullable String $this$shouldNotInclude, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot((Object)$this$shouldNotInclude, MatchersKt.include(substr));
        return $this$shouldNotInclude;
    }

    @NotNull
    public static final Matcher<String> include(@NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        return MatcherKt.neverNullMatcher(arg_0 -> MatchersKt.include$lambda$29(substr, arg_0));
    }

    @Nullable
    public static final String shouldBeEqualIgnoringCase(@Nullable String $this$shouldBeEqualIgnoringCase, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should((Object)$this$shouldBeEqualIgnoringCase, MatchersKt.beEqualIgnoringCase(other));
        return $this$shouldBeEqualIgnoringCase;
    }

    @Nullable
    public static final String shouldNotBeEqualIgnoringCase(@Nullable String $this$shouldNotBeEqualIgnoringCase, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot((Object)$this$shouldNotBeEqualIgnoringCase, MatchersKt.beEqualIgnoringCase(other));
        return $this$shouldNotBeEqualIgnoringCase;
    }

    @NotNull
    public static final Matcher<String> beEqualIgnoringCase(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MatcherKt.neverNullMatcher(arg_0 -> MatchersKt.beEqualIgnoringCase$lambda$32(other, arg_0));
    }

    @NotNull
    public static final String shouldBeUUID(@NotNull String $this$shouldBeUUID, @NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        ShouldKt.should((Object)$this$shouldBeUUID, MatchersKt.beUUID(version, considerNilValid));
        return $this$shouldBeUUID;
    }

    public static /* synthetic */ String shouldBeUUID$default(String string, UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return MatchersKt.shouldBeUUID(string, uUIDVersion, bl);
    }

    @NotNull
    public static final String shouldNotBeUUID(@NotNull String $this$shouldNotBeUUID, @NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        ShouldKt.shouldNot((Object)$this$shouldNotBeUUID, MatchersKt.beUUID(version, considerNilValid));
        return $this$shouldNotBeUUID;
    }

    public static /* synthetic */ String shouldNotBeUUID$default(String string, UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return MatchersKt.shouldNotBeUUID(string, uUIDVersion, bl);
    }

    @NotNull
    public static final Matcher<String> beUUID(@NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        return (Matcher)new Matcher<String>(version, considerNilValid){
            final /* synthetic */ UUIDVersion $version;
            final /* synthetic */ boolean $considerNilValid;
            {
                this.$version = $version;
                this.$considerNilValid = $considerNilValid;
            }

            public MatcherResult test(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                CharSequence charSequence = value;
                return MatcherResult.Companion.invoke(this.$version.getUuidRegex().matches(charSequence) || this.$considerNilValid && this.isNilUUID(value), () -> beUUID.1.test$lambda$0(value, this.$version), () -> beUUID.1.test$lambda$1(value, this.$version));
            }

            private final boolean isNilUUID(String $this$isNilUUID) {
                return Intrinsics.areEqual((Object)$this$isNilUUID, (Object)"00000000-0000-0000-0000-000000000000");
            }

            public <U> Matcher<U> contramap(Function1<? super U, String> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            public Matcher<String> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }

            public <T> Matcher<T> invertIf(Matcher<? super T> $this$invertIf, boolean invert) {
                return Matcher.DefaultImpls.invertIf((Matcher)this, $this$invertIf, (boolean)invert);
            }

            private static final String test$lambda$0(String $value, UUIDVersion $version) {
                return "String " + $value + " is not an UUID (" + (Object)((Object)$version) + "), but should be";
            }

            private static final String test$lambda$1(String $value, UUIDVersion $version) {
                return "String " + $value + " is an UUID (" + (Object)((Object)$version) + "), but shouldn't be";
            }
        };
    }

    public static /* synthetic */ Matcher beUUID$default(UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return MatchersKt.beUUID(uUIDVersion, bl);
    }

    public static final int shouldBeInteger(@Nullable String $this$shouldBeInteger, int radix) {
        Integer integer;
        if ($this$shouldBeInteger == null) {
            throw FailuresKt.failure((String)"String is null, but it should be integer.");
        }
        Integer n = integer = StringsKt.toIntOrNull((String)$this$shouldBeInteger, (int)radix);
        if (n == null) {
            throw FailuresKt.failure((String)("String '" + $this$shouldBeInteger + "' is not integer, but it should be."));
        }
        return n;
    }

    public static /* synthetic */ int shouldBeInteger$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return MatchersKt.shouldBeInteger(string, n);
    }

    private static final String containOnlyDigits$lambda$3$lambda$1(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should contain only digits";
    }

    private static final String containOnlyDigits$lambda$3$lambda$2(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should not contain only digits";
    }

    /*
     * WARNING - void declaration
     */
    private static final MatcherResult containOnlyDigits$lambda$3(String value) {
        boolean bl;
        MatcherResult.Companion companion;
        block1: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = value.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] cArray2 = cArray;
            companion = MatcherResult.Companion;
            boolean $i$f$all = false;
            int n = ((void)$this$all$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (48 <= it ? it < 58 : false) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        boolean bl3 = bl;
        return companion.invoke(bl3, () -> MatchersKt.containOnlyDigits$lambda$3$lambda$1(value), () -> MatchersKt.containOnlyDigits$lambda$3$lambda$2(value));
    }

    private static final String containADigit$lambda$7$lambda$5(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should contain at least one digit";
    }

    private static final String containADigit$lambda$7$lambda$6(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should not contain any digits";
    }

    /*
     * WARNING - void declaration
     */
    private static final MatcherResult containADigit$lambda$7(String value) {
        boolean bl;
        MatcherResult.Companion companion;
        block1: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = value.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            char[] cArray2 = cArray;
            companion = MatcherResult.Companion;
            boolean $i$f$any = false;
            int n = ((void)$this$any$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                boolean bl3 = 48 <= it ? it < 58 : false;
                if (!bl3) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean bl4 = bl;
        return companion.invoke(bl4, () -> MatchersKt.containADigit$lambda$7$lambda$5(value), () -> MatchersKt.containADigit$lambda$7$lambda$6(value));
    }

    private static final String containOnlyOnce$lambda$10$lambda$8(String $value, String $substring) {
        return PrintKt.print((Object)$value).getValue() + " should contain the substring " + PrintKt.print((Object)$substring).getValue() + " exactly once";
    }

    private static final String containOnlyOnce$lambda$10$lambda$9(String $value, String $substring) {
        return PrintKt.print((Object)$value).getValue() + " should not contain the substring " + PrintKt.print((Object)$substring).getValue() + " exactly once";
    }

    private static final MatcherResult containOnlyOnce$lambda$10(String $substring, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke(StringsKt.indexOf$default((CharSequence)value, (String)$substring, (int)0, (boolean)false, (int)6, null) >= 0 && StringsKt.indexOf$default((CharSequence)value, (String)$substring, (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)value, (String)$substring, (int)0, (boolean)false, (int)6, null), () -> MatchersKt.containOnlyOnce$lambda$10$lambda$8(value, $substring), () -> MatchersKt.containOnlyOnce$lambda$10$lambda$9(value, $substring));
    }

    private static final String beEmpty$lambda$13$lambda$11(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should be empty";
    }

    private static final String beEmpty$lambda$13$lambda$12(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should not be empty";
    }

    private static final MatcherResult beEmpty$lambda$13(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke(((CharSequence)value).length() == 0, () -> MatchersKt.beEmpty$lambda$13$lambda$11(value), () -> MatchersKt.beEmpty$lambda$13$lambda$12(value));
    }

    private static final String beBlank$lambda$16$lambda$14(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should contain only whitespace";
    }

    private static final String beBlank$lambda$16$lambda$15(String $value) {
        return PrintKt.print((Object)$value).getValue() + " should not contain only whitespace";
    }

    private static final MatcherResult beBlank$lambda$16(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke(StringsKt.isBlank((CharSequence)value), () -> MatchersKt.beBlank$lambda$16$lambda$14(value), () -> MatchersKt.beBlank$lambda$16$lambda$15(value));
    }

    private static final String containIgnoringCase$lambda$19$lambda$17(String $value, String $substr) {
        return PrintKt.print((Object)$value).getValue() + " should contain the substring " + PrintKt.print((Object)$substr).getValue() + " (case insensitive)";
    }

    private static final String containIgnoringCase$lambda$19$lambda$18(String $value, String $substr) {
        return PrintKt.print((Object)$value).getValue() + " should not contain the substring " + PrintKt.print((Object)$substr).getValue() + " (case insensitive)";
    }

    private static final MatcherResult containIgnoringCase$lambda$19(String $substr, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = string;
        String string2 = $substr.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return MatcherResult.Companion.invoke(StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null) >= 0, () -> MatchersKt.containIgnoringCase$lambda$19$lambda$17(value, $substr), () -> MatchersKt.containIgnoringCase$lambda$19$lambda$18(value, $substr));
    }

    private static final String contain$lambda$22$lambda$20(String $value, Regex $regex) {
        return PrintKt.print((Object)$value).getValue() + " should contain regex " + $regex;
    }

    private static final String contain$lambda$22$lambda$21(String $value, Regex $regex) {
        return PrintKt.print((Object)$value).getValue() + " should not contain regex " + $regex;
    }

    private static final MatcherResult contain$lambda$22(Regex $regex, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke($regex.containsMatchIn((CharSequence)value), () -> MatchersKt.contain$lambda$22$lambda$20(value, $regex), () -> MatchersKt.contain$lambda$22$lambda$21(value, $regex));
    }

    private static final String containInOrder$lambda$25$lambda$23(String $value, String[] $substrings, ContainInOrderOutcome $matchOutcome) {
        return PrintKt.print((Object)$value).getValue() + " should include substrings " + PrintKt.print((Object)$substrings).getValue() + " in order" + MatchersKt.prefixIfNotEmpty($matchOutcome.getMistmatchDescription(), "\n");
    }

    private static final String containInOrder$lambda$25$lambda$24(String $value, String[] $substrings) {
        return PrintKt.print((Object)$value).getValue() + " should not include substrings " + PrintKt.print((Object)$substrings).getValue() + " in order";
    }

    private static final MatcherResult containInOrder$lambda$25(String[] $substrings, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ContainInOrderOutcome matchOutcome = MatchersKt.matchSubstrings$default(value, ArraysKt.toList((Object[])$substrings), 0, 4, null);
        return MatcherResult.Companion.invoke(matchOutcome.getMatch(), () -> MatchersKt.containInOrder$lambda$25$lambda$23(value, $substrings, matchOutcome), () -> MatchersKt.containInOrder$lambda$25$lambda$24(value, $substrings));
    }

    /*
     * WARNING - void declaration
     */
    private static final String include$lambda$29$lambda$27(List $differencesDescription) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $differencesDescription;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String include$lambda$29$lambda$28(String $value, String $substr) {
        return PrintKt.print((Object)$value).getValue() + " should not include substring " + PrintKt.print((Object)$substr).getValue();
    }

    private static final MatcherResult include$lambda$29(String $substr, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean passed = StringsKt.contains$default((CharSequence)value, (CharSequence)$substr, (boolean)false, (int)2, null);
        Object[] objectArray = new String[]{PrintKt.print((Object)value).getValue() + " should include substring " + PrintKt.print((Object)$substr).getValue(), StringPartialMatchesKt.describePartialMatchesInString($substr, value).toString()};
        List differencesDescription = CollectionsKt.listOf((Object[])objectArray);
        return MatcherResult.Companion.invoke(passed, () -> MatchersKt.include$lambda$29$lambda$27(differencesDescription), () -> MatchersKt.include$lambda$29$lambda$28(value, $substr));
    }

    private static final String beEqualIgnoringCase$lambda$32$lambda$30(String $value, String $other) {
        return PrintKt.print((Object)$value).getValue() + " should be equal ignoring case " + PrintKt.print((Object)$other).getValue();
    }

    private static final String beEqualIgnoringCase$lambda$32$lambda$31(String $value, String $other) {
        return PrintKt.print((Object)$value).getValue() + " should not be equal ignoring case " + PrintKt.print((Object)$other).getValue();
    }

    private static final MatcherResult beEqualIgnoringCase$lambda$32(String $other, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke(StringsKt.equals((String)value, (String)$other, (boolean)true), () -> MatchersKt.beEqualIgnoringCase$lambda$32$lambda$30(value, $other), () -> MatchersKt.beEqualIgnoringCase$lambda$32$lambda$31(value, $other));
    }
}

