package io.kotest.matchers.iterator

import io.kotest.matchers.Matcher
import io.kotest.matchers.MatcherResult
import io.kotest.matchers.should
import io.kotest.matchers.shouldNot

fun <T> Iterator<T>.shouldBeEmpty() = this should beEmpty()
fun <T> Iterator<T>.shouldNotBeEmpty() = this shouldNot beEmpty()
fun <T> beEmpty(): Matcher<Iterator<T>> = object : Matcher<Iterator<T>> {
   override fun test(value: Iterator<T>): MatcherResult {
      return MatcherResult(
         !value.hasNext(),
         "Iterator should be empty but still has values",
         "Iterator should not be empty"
      )
   }
}
