/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json;

import io.kotest.assertions.Actual;
import io.kotest.assertions.Expected;
import io.kotest.assertions.IntellijFormatterKt;
import io.kotest.assertions.json.CompareJsonOptions;
import io.kotest.assertions.json.CompareKt;
import io.kotest.assertions.json.CompareMode;
import io.kotest.assertions.json.CompareOrder;
import io.kotest.assertions.json.ErrorsKt;
import io.kotest.assertions.json.JsonError;
import io.kotest.assertions.json.JsonMatchersKt;
import io.kotest.assertions.json.JsonTree;
import io.kotest.assertions.json.MatchersKt;
import io.kotest.assertions.print.PrintKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0015\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\fH\u0086\u0004\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t\u001a\u0015\u0010\r\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\fH\u0086\u0004\u001a\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\fH\u0086\u0004\u001a\u001a\u0010\u000e\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\u000e\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t\u001a\u0015\u0010\u000f\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0003\u001a\u00020\fH\u0086\u0004\u00a8\u0006\u0010"}, d2={"equalJson", "Lio/kotest/matchers/Matcher;", "Lio/kotest/assertions/json/JsonTree;", "expected", "options", "Lio/kotest/assertions/json/CompareJsonOptions;", "mode", "Lio/kotest/assertions/json/CompareMode;", "order", "Lio/kotest/assertions/json/CompareOrder;", "shouldEqualJson", "", "", "shouldEqualSpecifiedJson", "shouldNotEqualJson", "shouldNotEqualSpecifiedJson", "kotest-assertions-json"})
public final class MatchersKt {
    @NotNull
    public static final Matcher<JsonTree> equalJson(@NotNull JsonTree expected, @NotNull CompareMode mode, @NotNull CompareOrder order) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        return MatchersKt.equalJson(expected, CompareKt.legacyOptions(mode, order));
    }

    @NotNull
    public static final Matcher<JsonTree> equalJson(@NotNull JsonTree expected, @NotNull CompareJsonOptions options) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return (Matcher)new Matcher<JsonTree>(expected, options){
            final /* synthetic */ JsonTree $expected;
            final /* synthetic */ CompareJsonOptions $options;
            {
                this.$expected = $expected;
                this.$options = $options;
            }

            @NotNull
            public MatcherResult test(@NotNull JsonTree value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                JsonError jsonError = CompareKt.compare(CollectionsKt.emptyList(), this.$expected.getRoot(), value.getRoot(), this.$options);
                String error = jsonError == null ? null : ErrorsKt.asString(jsonError);
                return MatcherResult.Companion.invoke(error == null, (Function0)new Function0<String>(error, this.$expected, value){
                    final /* synthetic */ String $error;
                    final /* synthetic */ JsonTree $expected;
                    final /* synthetic */ JsonTree $value;
                    {
                        this.$error = $error;
                        this.$expected = $expected;
                        this.$value = $value;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$error + "\n\n" + IntellijFormatterKt.intellijFormatError((Expected)new Expected(PrintKt.printed((String)this.$expected.getRaw())), (Actual)new Actual(PrintKt.printed((String)this.$value.getRaw())));
                    }
                }, (Function0)new Function0<String>(this.$expected){
                    final /* synthetic */ JsonTree $expected;
                    {
                        this.$expected = $expected;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return Intrinsics.stringPlus((String)"Expected values to not match ", (Object)this.$expected.getRaw());
                    }
                });
            }

            @NotNull
            public <U> Matcher<U> compose(@NotNull Function1<? super U, JsonTree> fn) {
                return Matcher.DefaultImpls.compose((Matcher)this, fn);
            }

            @NotNull
            public <U> Matcher<U> contramap(@NotNull Function1<? super U, JsonTree> f) {
                return Matcher.DefaultImpls.contramap((Matcher)this, f);
            }

            @NotNull
            public Matcher<JsonTree> invert() {
                return Matcher.DefaultImpls.invert((Matcher)this);
            }
        };
    }

    public static final void shouldEqualJson(@NotNull String $this$shouldEqualJson, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldEqualJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        JsonMatchersKt.shouldEqualJson($this$shouldEqualJson, expected, CompareKt.getDefaultCompareJsonOptions());
    }

    public static final void shouldNotEqualJson(@NotNull String $this$shouldNotEqualJson, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotEqualJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        JsonMatchersKt.shouldNotEqualJson($this$shouldNotEqualJson, expected, CompareKt.getDefaultCompareJsonOptions());
    }

    public static final void shouldEqualJson(@NotNull String $this$shouldEqualJson, @NotNull String expected, @NotNull CompareMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldEqualJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        JsonMatchersKt.shouldEqualJson($this$shouldEqualJson, expected, CompareKt.legacyOptions(mode, CompareOrder.Strict));
    }

    public static final void shouldNotEqualJson(@NotNull String $this$shouldNotEqualJson, @NotNull String expected, @NotNull CompareMode mode) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotEqualJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        JsonMatchersKt.shouldNotEqualJson($this$shouldNotEqualJson, expected, CompareKt.legacyOptions(mode, CompareOrder.Strict));
    }

    public static final void shouldEqualJson(@NotNull String $this$shouldEqualJson, @NotNull String expected, @NotNull CompareOrder order) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldEqualJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        JsonMatchersKt.shouldEqualJson($this$shouldEqualJson, expected, CompareKt.legacyOptions(CompareMode.Strict, order));
    }

    public static final void shouldNotEqualJson(@NotNull String $this$shouldNotEqualJson, @NotNull String expected, @NotNull CompareOrder order) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotEqualJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)((Object)order), (String)"order");
        JsonMatchersKt.shouldNotEqualJson($this$shouldNotEqualJson, expected, CompareKt.legacyOptions(CompareMode.Strict, order));
    }

    public static final void shouldEqualSpecifiedJson(@NotNull String $this$shouldEqualSpecifiedJson, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldEqualSpecifiedJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        JsonMatchersKt.shouldEqualJson($this$shouldEqualSpecifiedJson, expected, CompareKt.compareJsonOptions((Function1<? super CompareJsonOptions, Unit>)((Function1)shouldEqualSpecifiedJson.1.INSTANCE)));
    }

    public static final void shouldNotEqualSpecifiedJson(@NotNull String $this$shouldNotEqualSpecifiedJson, @NotNull String expected) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotEqualSpecifiedJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        JsonMatchersKt.shouldNotEqualJson($this$shouldNotEqualSpecifiedJson, expected, CompareKt.compareJsonOptions((Function1<? super CompareJsonOptions, Unit>)((Function1)shouldNotEqualSpecifiedJson.1.INSTANCE)));
    }
}

