/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json;

import io.kotest.assertions.json.JsonNode;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u001a\u001a\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0000\u001aW\u0010\u0007\u001a\u00020\u0001\"\u0004\b\u0000\u0010\b\"\u000e\b\u0001\u0010\t*\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u0002H\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"indent", "", "prettyPrint", "node", "Lio/kotest/assertions/json/JsonNode;", "depth", "", "prettyPrintElements", "S", "T", "", "prefix", "suffix", "elements", "transform", "Lkotlin/Function1;", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)Ljava/lang/String;", "kotest-assertions-json"})
public final class PrintKt {
    @NotNull
    private static final String indent = "  ";

    @NotNull
    public static final String prettyPrint(@NotNull JsonNode node, int depth) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JsonNode jsonNode = node;
        if (jsonNode instanceof JsonNode.ArrayNode) {
            string = PrintKt.prettyPrintElements(depth, "[", "]", (Collection)((JsonNode.ArrayNode)node).getElements(), (Function1)new Function1<JsonNode, CharSequence>(depth){
                final /* synthetic */ int $depth;
                {
                    this.$depth = $depth;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull JsonNode child) {
                    Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                    return Intrinsics.stringPlus((String)StringsKt.repeat((CharSequence)"  ", (int)(this.$depth + 1)), (Object)PrintKt.prettyPrint(child, this.$depth + 1));
                }
            });
        } else if (jsonNode instanceof JsonNode.ObjectNode) {
            string = PrintKt.prettyPrintElements(depth, "{", "}", (Collection)((JsonNode.ObjectNode)node).getElements().entrySet(), (Function1)new Function1<Map.Entry<? extends String, ? extends JsonNode>, CharSequence>(depth){
                final /* synthetic */ int $depth;
                {
                    this.$depth = $depth;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Map.Entry<String, ? extends JsonNode> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return StringsKt.repeat((CharSequence)"  ", (int)(this.$depth + 1)) + '\"' + it.getKey() + "\": " + PrintKt.prettyPrint(it.getValue(), this.$depth + 1);
                }
            });
        } else if (jsonNode instanceof JsonNode.BooleanNode) {
            string = String.valueOf(((JsonNode.BooleanNode)node).getValue());
        } else if (Intrinsics.areEqual((Object)jsonNode, (Object)JsonNode.NullNode.INSTANCE)) {
            string = "null";
        } else if (jsonNode instanceof JsonNode.NumberNode) {
            string = ((JsonNode.NumberNode)node).getContent();
        } else if (jsonNode instanceof JsonNode.StringNode) {
            string = '\"' + StringsKt.replace$default((String)((JsonNode.StringNode)node).getValue(), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + '\"';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static /* synthetic */ String prettyPrint$default(JsonNode jsonNode, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return PrintKt.prettyPrint(jsonNode, n);
    }

    private static final <S, T extends Collection<? extends S>> String prettyPrintElements(int depth, String prefix, String suffix, T elements, Function1<? super S, ? extends CharSequence> transform) {
        StringBuilder stringBuilder;
        StringBuilder $this$prettyPrintElements_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (elements.isEmpty()) {
            $this$prettyPrintElements_u24lambda_u2d0.append(Intrinsics.stringPlus((String)prefix, (Object)suffix));
        } else {
            CharSequence charSequence = $this$prettyPrintElements_u24lambda_u2d0.append(prefix);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"append(value)");
            StringBuilder stringBuilder2 = charSequence.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append('\\n')");
            StringBuilder stringBuilder3 = $this$prettyPrintElements_u24lambda_u2d0;
            charSequence = CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)",\n", null, null, (int)0, null, transform, (int)30, null);
            stringBuilder2 = stringBuilder3.append((String)charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append('\\n')");
            $this$prettyPrintElements_u24lambda_u2d0.append(Intrinsics.stringPlus((String)StringsKt.repeat((CharSequence)indent, (int)depth), (Object)suffix));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

