/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.json.schema;

import io.kotest.assertions.json.schema.JsonSchema;
import io.kotest.assertions.json.schema.JsonSchemaArraySerializer;
import io.kotest.assertions.json.schema.JsonSchemaElement;
import io.kotest.assertions.json.schema.JsonSchemaIntegerSerializer;
import io.kotest.assertions.json.schema.JsonSchemaNumberSerializer;
import io.kotest.assertions.json.schema.JsonSchemaStringSerializer;
import io.kotest.common.ExperimentalKotest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonContentPolymorphicSerializer;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lio/kotest/assertions/json/schema/SchemaDeserializer;", "Lkotlinx/serialization/json/JsonContentPolymorphicSerializer;", "Lio/kotest/assertions/json/schema/JsonSchemaElement;", "()V", "selectDeserializer", "Lkotlinx/serialization/DeserializationStrategy;", "element", "Lkotlinx/serialization/json/JsonElement;", "kotest-assertions-json"})
@ExperimentalKotest
public final class SchemaDeserializer
extends JsonContentPolymorphicSerializer<JsonSchemaElement> {
    @NotNull
    public static final SchemaDeserializer INSTANCE = new SchemaDeserializer();

    private SchemaDeserializer() {
        super(Reflection.getOrCreateKotlinClass(JsonSchemaElement.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected DeserializationStrategy<? extends JsonSchemaElement> selectDeserializer(@NotNull JsonElement element2) {
        String type;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        JsonElement jsonElement = (JsonElement)JsonElementKt.getJsonObject((JsonElement)element2).get((Object)"type");
        String string2 = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : (type = null);
        if (type == null) throw new IllegalStateException(("Unknown type: " + type).toString());
        int n = -1;
        switch (type.hashCode()) {
            case -1034364087: {
                if (type.equals("number")) {
                    n = 1;
                }
                break;
            }
            case 64711720: {
                if (type.equals("boolean")) {
                    n = 2;
                }
                break;
            }
            case -891985903: {
                if (type.equals("string")) {
                    n = 3;
                }
                break;
            }
            case 3392903: {
                if (type.equals("null")) {
                    n = 4;
                }
                break;
            }
            case 93090393: {
                if (type.equals("array")) {
                    n = 5;
                }
                break;
            }
            case 1958052158: {
                if (type.equals("integer")) {
                    n = 6;
                }
                break;
            }
            case -1023368385: {
                if (type.equals("object")) {
                    n = 7;
                }
                break;
            }
        }
        switch (n) {
            case 5: {
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonSchemaArraySerializer.INSTANCE;
                return deserializationStrategy;
            }
            case 7: {
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonSchema.JsonObject.Companion.serializer();
                return deserializationStrategy;
            }
            case 3: {
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonSchemaStringSerializer.INSTANCE;
                return deserializationStrategy;
            }
            case 6: {
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonSchemaIntegerSerializer.INSTANCE;
                return deserializationStrategy;
            }
            case 1: {
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonSchemaNumberSerializer.INSTANCE;
                return deserializationStrategy;
            }
            case 2: {
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonSchema.JsonBoolean.INSTANCE.serializer();
                return deserializationStrategy;
            }
            case 4: {
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonSchema.Null.INSTANCE.serializer();
                return deserializationStrategy;
            }
            default: {
                throw new IllegalStateException(("Unknown type: " + type).toString());
            }
        }
    }
}

